/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.events;

import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.settings.OutputEnvironmentVariablesBuildWrapper;
import com.microfocus.application.automation.tools.settings.RunnerMiscSettingsGlobalConfiguration;
import com.microfocus.application.automation.tools.sse.common.StringUtils;
import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Job;
import hudson.model.Run;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;

public class OutputEnvironmentParametersHelper {
    private static final String SPLIT_SYMBOL = "\\s++";
    private static Logger logger = SDKBasedLoggerProvider.getLogger(OutputEnvironmentParametersHelper.class);

    private OutputEnvironmentParametersHelper() {
    }

    public static Map<String, String> getOutputEnvironmentParams(Run run) {
        EnvVars environment = OutputEnvironmentParametersHelper.getEnvironment(run);
        if (environment == null) {
            return Collections.emptyMap();
        }
        ArrayList<String> paramKeysList = new ArrayList<String>();
        paramKeysList.addAll(OutputEnvironmentParametersHelper.getGlobalParamsList());
        paramKeysList.addAll(OutputEnvironmentParametersHelper.getJobParamsList(run));
        if (paramKeysList.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> outputEnvParams = new HashMap<String, String>();
        Set sensitiveBuildVariables = null;
        if (run instanceof AbstractBuild) {
            sensitiveBuildVariables = ((AbstractBuild)run).getSensitiveBuildVariables();
        }
        for (String key : paramKeysList) {
            String value;
            if (sensitiveBuildVariables != null && sensitiveBuildVariables.contains(key) || (value = (String)environment.get((Object)key)) == null) continue;
            outputEnvParams.put(key, value);
        }
        return outputEnvParams;
    }

    private static EnvVars getEnvironment(Run run) {
        EnvVars environment = null;
        try {
            environment = run.getEnvironment(null);
        }
        catch (IOException | InterruptedException e) {
            logger.error("Can not get Run(id: " + run.getId() + ") Environment: " + e.getMessage());
        }
        return environment;
    }

    private static List<String> getGlobalParamsList() {
        try {
            String paramsStr = RunnerMiscSettingsGlobalConfiguration.getInstance().getOutputEnvironmentParameters();
            return OutputEnvironmentParametersHelper.createParamsListFromString(paramsStr);
        }
        catch (NullPointerException ignored) {
            return Collections.emptyList();
        }
    }

    private static List<String> getJobParamsList(Run run) {
        String paramsStr;
        OutputEnvironmentVariablesBuildWrapper outputEnvVarsBuildWrapper;
        Job job = run.getParent();
        if (job instanceof BuildableItemWithBuildWrappers && (outputEnvVarsBuildWrapper = (OutputEnvironmentVariablesBuildWrapper)((BuildableItemWithBuildWrappers)job).getBuildWrappersList().get(OutputEnvironmentVariablesBuildWrapper.class)) != null && !StringUtils.isNullOrEmpty(paramsStr = outputEnvVarsBuildWrapper.getOutputEnvironmentParameters())) {
            return OutputEnvironmentParametersHelper.createParamsListFromString(paramsStr);
        }
        return Collections.emptyList();
    }

    private static List<String> createParamsListFromString(String params) {
        return Stream.of(params.split(SPLIT_SYMBOL)).filter(p -> !StringUtils.isNullOrEmpty(p)).collect(Collectors.toList());
    }
}

