/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.events;

import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.events.CIEvent;
import com.hp.octane.integrations.dto.events.CIEventType;
import com.hp.octane.integrations.dto.events.ItemType;
import com.microfocus.application.automation.tools.octane.CIJenkinsServicesImpl;
import com.microfocus.application.automation.tools.octane.configuration.ConfigurationService;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.executor.UftTestDiscoveryDispatcher;
import com.microfocus.application.automation.tools.octane.model.processors.projects.JobProcessorFactory;
import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerUtils;
import com.microfocus.application.automation.tools.settings.OctaneServerSettingsGlobalConfiguration;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import jenkins.model.Jenkins;
import org.apache.logging.log4j.Logger;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

@Extension
public class GlobalEventsListenerOctaneImpl
extends ItemListener {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(GlobalEventsListenerOctaneImpl.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();

    public void onLoaded() {
        logger.info("**********************************************************************");
        logger.info("********************STARTING JENKINS *********************************");
        logger.info("**********************************************************************");
        logger.info("Jenkins version " + String.valueOf(Jenkins.getVersion()));
        logger.info("Plugin version " + ConfigurationService.getPluginVersion());
        logger.info("CI SDK version " + OctaneSDK.SDK_VERSION);
        OctaneServerSettingsGlobalConfiguration.getInstance().initOctaneClients();
    }

    public void onDeleted(Item item) {
        if (!OctaneSDK.hasClients()) {
            return;
        }
        try {
            if (item.getParent() != null && item.getParent().getClass().getName().equalsIgnoreCase("org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject")) {
                CIEvent event = ((CIEvent)dtoFactory.newDTO(CIEvent.class)).setEventType(CIEventType.DELETED).setProject(JobProcessorFactory.getFlowProcessor((WorkflowJob)item).getTranslatedJobName());
                OctaneSDK.getClients().forEach(client -> client.getEventsService().publishEvent(event));
            }
        }
        catch (Throwable throwable) {
            logger.error("failed to build and/or dispatch DELETED event for " + String.valueOf(item), throwable);
        }
    }

    public void onBeforeShutdown() {
        OctaneSDK.getClients().forEach(OctaneSDK::removeClient);
        UftTestDiscoveryDispatcher dispatcher = (UftTestDiscoveryDispatcher)((Object)Jenkins.get().getExtensionList(UftTestDiscoveryDispatcher.class).get(0));
        dispatcher.close();
    }

    public void onLocationChanged(Item item, String oldFullName, String newFullName) {
        if (!OctaneSDK.hasClients()) {
            return;
        }
        boolean skip = JobProcessorFactory.isFolder(item) || JobProcessorFactory.isMultibranchChild(item);
        logger.info("onLocationChanged '" + oldFullName + "' to '" + newFullName + "'" + (skip ? ". Skipped." : ""));
        if (skip) {
            return;
        }
        try {
            CIEvent event = ((CIEvent)dtoFactory.newDTO(CIEvent.class)).setEventType(CIEventType.RENAMED);
            if (JobProcessorFactory.isJob(item)) {
                event.setItemType(ItemType.JOB);
            } else if (JobProcessorFactory.isMultibranch(item)) {
                event.setItemType(ItemType.MULTI_BRANCH);
            } else {
                logger.info("Cannot handle onLocationChanged for " + item.getClass().getName());
                return;
            }
            event.setProject(BuildHandlerUtils.translateFolderJobName(newFullName)).setProjectDisplayName(newFullName).setPreviousProject(BuildHandlerUtils.translateFolderJobName(oldFullName)).setPreviousProjectDisplayName(oldFullName);
            CIJenkinsServicesImpl.publishEventToRelevantClients(event);
            OctaneSDK.getClients().forEach(c -> {
                if (c.getConfigurationService().removeFromOctaneRoots(event.getPreviousProject())) {
                    c.getConfigurationService().addToOctaneRootsCache(event.getProject());
                }
            });
        }
        catch (Throwable throwable) {
            logger.error("failed to build and/or dispatch RENAMED event for " + String.valueOf(item), throwable);
        }
    }
}

