/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.events;

import com.hp.octane.integrations.OctaneSDK;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerUtils;
import hudson.model.Run;
import org.apache.logging.log4j.Logger;

public class BuildLogHelper {
    private static Logger logger = SDKBasedLoggerProvider.getLogger(BuildLogHelper.class);

    private BuildLogHelper() {
    }

    public static void enqueueBuildLog(Run run) {
        if (!OctaneSDK.hasClients()) {
            return;
        }
        try {
            String jobCiId = BuildHandlerUtils.getJobCiId(run);
            String buildCiId = BuildHandlerUtils.getBuildCiId(run);
            String parents = BuildHandlerUtils.getRootJobCiIds(run);
            logger.debug("enqueued build '" + jobCiId + " #" + buildCiId + "' for log submission");
            OctaneSDK.getClients().forEach(octaneClient -> octaneClient.getLogsService().enqueuePushBuildLog(jobCiId, buildCiId, parents));
        }
        catch (Exception t) {
            logger.error("failed to enqueue " + String.valueOf(run) + " for logs push to Octane", (Throwable)t);
        }
    }
}

