/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.events;

import com.google.inject.Inject;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.events.CIEvent;
import com.hp.octane.integrations.dto.events.CIEventType;
import com.hp.octane.integrations.dto.events.PhaseType;
import com.hp.octane.integrations.dto.pipelines.PipelineNode;
import com.hp.octane.integrations.dto.pipelines.PipelinePhase;
import com.microfocus.application.automation.tools.octane.CIJenkinsServicesImpl;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.events.BuildLogHelper;
import com.microfocus.application.automation.tools.octane.events.OutputEnvironmentParametersHelper;
import com.microfocus.application.automation.tools.octane.model.CIEventCausesFactory;
import com.microfocus.application.automation.tools.octane.model.processors.parameters.ParameterProcessors;
import com.microfocus.application.automation.tools.octane.model.processors.projects.JobProcessorFactory;
import com.microfocus.application.automation.tools.octane.model.processors.scm.CommonOriginRevision;
import com.microfocus.application.automation.tools.octane.model.processors.scm.SCMProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.scm.SCMProcessors;
import com.microfocus.application.automation.tools.octane.tests.TestListener;
import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerUtils;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.scm.SCM;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.logging.log4j.Logger;

@Extension
public final class AbstractBuildListenerOctaneImpl
extends RunListener<AbstractBuild> {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(AbstractBuildListenerOctaneImpl.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();
    @Inject
    private TestListener testListener;

    public void onStarted(AbstractBuild build, TaskListener listener) {
        if (!OctaneSDK.hasClients()) {
            return;
        }
        this.publishStartEvent(build);
    }

    private void publishStartEvent(AbstractBuild build) {
        try {
            CIEvent event = ((CIEvent)dtoFactory.newDTO(CIEvent.class)).setEventType(CIEventType.STARTED).setProject(BuildHandlerUtils.getJobCiId((Run)build)).setProjectDisplayName(BuildHandlerUtils.translateFullDisplayName(build.getParent().getFullDisplayName())).setBuildCiId(BuildHandlerUtils.getBuildCiId((Run)build)).setNumber(String.valueOf(build.getNumber())).setStartTime(Long.valueOf(build.getStartTimeInMillis())).setEstimatedDuration(Long.valueOf(build.getEstimatedDuration())).setCauses(CIEventCausesFactory.processCauses(build)).setParameters(ParameterProcessors.getInstances((Run)build));
            if (this.isInternal((Run)build)) {
                event.setPhaseType(PhaseType.INTERNAL);
            } else {
                event.setPhaseType(PhaseType.POST);
            }
            CIJenkinsServicesImpl.publishEventToRelevantClients(event);
        }
        catch (Throwable throwable) {
            logger.error("failed to build and/or dispatch STARTED event for " + String.valueOf(build), throwable);
        }
    }

    public void onFinalized(AbstractBuild build) {
        if (!OctaneSDK.hasClients()) {
            return;
        }
        this.publishFinishEvent(build);
        BuildLogHelper.enqueueBuildLog((Run)build);
    }

    private void publishFinishEvent(AbstractBuild build) {
        try {
            boolean hasTests = this.testListener.processBuild((Run)build);
            CIEvent event = ((CIEvent)dtoFactory.newDTO(CIEvent.class)).setEventType(CIEventType.FINISHED).setProject(BuildHandlerUtils.getJobCiId((Run)build)).setProjectDisplayName(BuildHandlerUtils.translateFullDisplayName(build.getParent().getFullDisplayName())).setBuildCiId(BuildHandlerUtils.getBuildCiId((Run)build)).setNumber(String.valueOf(build.getNumber())).setStartTime(Long.valueOf(build.getStartTimeInMillis())).setEstimatedDuration(Long.valueOf(build.getEstimatedDuration())).setCauses(CIEventCausesFactory.processCauses(build)).setParameters(ParameterProcessors.getInstances((Run)build)).setResult(BuildHandlerUtils.translateRunResult((Run)build)).setDuration(Long.valueOf(build.getDuration())).setTestResultExpected(hasTests).setEnvironmentOutputtedParameters(OutputEnvironmentParametersHelper.getOutputEnvironmentParams((Run)build));
            CommonOriginRevision commonOriginRevision = this.getCommonOriginRevision(build);
            if (commonOriginRevision != null) {
                event.setCommonHashId(commonOriginRevision.revision).setBranchName(commonOriginRevision.branch);
            }
            CIJenkinsServicesImpl.publishEventToRelevantClients(event);
        }
        catch (Throwable throwable) {
            logger.error("failed to build and/or dispatch FINISHED event for " + String.valueOf(build), throwable);
        }
    }

    private CommonOriginRevision getCommonOriginRevision(AbstractBuild build) {
        SCMProcessor scmProcessor;
        CommonOriginRevision commonOriginRevision = null;
        SCM scm = build.getProject().getScm();
        if (scm != null && (scmProcessor = SCMProcessors.getAppropriate(scm.getClass().getName())) != null) {
            commonOriginRevision = scmProcessor.getCommonOriginRevision((Run)build);
        }
        return commonOriginRevision;
    }

    private boolean isInternal(Run r) {
        boolean result = false;
        Cause.UpstreamCause upstreamCause = null;
        for (Object cause : r.getCauses()) {
            if (!(cause instanceof Cause.UpstreamCause)) continue;
            upstreamCause = (Cause.UpstreamCause)cause;
            break;
        }
        if (upstreamCause != null) {
            String causeJobName = upstreamCause.getUpstreamProject();
            Item parent = Jenkins.get().getItemByFullName(causeJobName);
            if (parent == null) {
                result = true;
            } else if (parent.getClass().getName().equals("org.jenkinsci.plugins.workflow.job.WorkflowJob")) {
                result = true;
            } else {
                List<PipelinePhase> phases = JobProcessorFactory.getFlowProcessor((Job)parent).getInternals();
                for (PipelinePhase p : phases) {
                    for (PipelineNode n : p.getJobs()) {
                        if (n == null || !n.getName().equals(r.getParent().getName())) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return result;
    }
}

