/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.configuration;

import com.microfocus.application.automation.tools.octane.configuration.ReflectionUtils;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.tasks.Publisher;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.logging.log4j.Logger;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class SSCServerConfigUtil {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(SSCServerConfigUtil.class);
    private static final String PUBLISHER_NEW_NAME = "com.fortify.plugin.jenkins.FortifyPlugin";
    private static final String PUBLISHER_OLD_VERSION = "com.fortify.plugin.jenkins.FPRPublisher";
    private static final String FORTIFY_UPLOAD_ACTION_NAME = "com.fortify.plugin.jenkins.FortifyUploadBuildAction";
    private static final String FORTIFY_UPLOAD_PROJECT_ACTIONS_METHOD = "getProjectActions";
    private static final String FORTIFY_UPLOAD_APP_NAME_METHOD = "getAppName";
    private static final String FORTIFY_UPLOAD_APP_VERSION_METHOD = "getAppVersion";

    public static String getSSCServer() {
        Descriptor sscDescriptor = SSCServerConfigUtil.getSSCDescriptor();
        return sscDescriptor != null ? SSCServerConfigUtil.getFieldValue(sscDescriptor, "url") : null;
    }

    public static SSCProjectVersionPair getProjectConfigurationFromBuild(AbstractBuild build) {
        return build != null ? SSCServerConfigUtil.getProjectVersion(build.getProject()) : null;
    }

    public static SSCProjectVersionPair getProjectConfigurationFromWorkflowRun(WorkflowRun run) {
        SSCProjectVersionPair projectVersionPair = null;
        List workflowActions = run != null ? run.getAllActions() : new ArrayList();
        for (Action action : workflowActions) {
            if (!action.getClass().getName().equals(FORTIFY_UPLOAD_ACTION_NAME)) continue;
            try {
                List projectActions = (List)ReflectionUtils.invokeMethodByName(action, FORTIFY_UPLOAD_PROJECT_ACTIONS_METHOD, null);
                Action projectMethods = projectActions != null && projectActions.size() > 0 ? (Action)projectActions.get(0) : null;
                if (projectMethods == null) continue;
                String projName = (String)ReflectionUtils.invokeMethodByName(projectMethods, FORTIFY_UPLOAD_APP_NAME_METHOD, null);
                String version = (String)ReflectionUtils.invokeMethodByName(projectMethods, FORTIFY_UPLOAD_APP_VERSION_METHOD, null);
                projectVersionPair = new SSCProjectVersionPair(projName, version);
            }
            catch (Exception e) {
                logger.error("Failed getProjectConfigurationFromWorkflowRun", (Throwable)e);
            }
        }
        return projectVersionPair;
    }

    private static SSCProjectVersionPair getProjectVersion(AbstractProject project) {
        for (Object publisher : project.getPublishersList()) {
            if (!(publisher instanceof Publisher) || !SSCServerConfigUtil.isSSCPublisher(publisher.getClass().getName())) continue;
            return SSCServerConfigUtil.getProjectNameByReflection(publisher);
        }
        return null;
    }

    private static boolean isSSCPublisher(String publisherName) {
        return PUBLISHER_NEW_NAME.equals(publisherName) || PUBLISHER_OLD_VERSION.equals(publisherName);
    }

    private static SSCProjectVersionPair getProjectNameByReflection(Object fprPublisher) {
        String projectName = SSCServerConfigUtil.getFieldValue(fprPublisher, "projectName");
        String projectVersion = SSCServerConfigUtil.getFieldValue(fprPublisher, "projectVersion");
        if (projectName != null && !projectName.isEmpty() && projectVersion != null && !projectVersion.isEmpty()) {
            return new SSCProjectVersionPair(projectName, projectVersion);
        }
        logger.warn("Version seems to be 18.20.1071 or higher");
        Object uploadSSC = SSCServerConfigUtil.getFieldValueAsObj(fprPublisher, "uploadSSC");
        if (uploadSSC == null) {
            Object analysisRunType = SSCServerConfigUtil.getFieldValueAsObj(fprPublisher, "analysisRunType");
            if (analysisRunType == null) {
                logger.warn("uploadSSC section was not found");
            } else {
                uploadSSC = SSCServerConfigUtil.getFieldValueAsObj(analysisRunType, "uploadSSC");
                if (uploadSSC == null) {
                    logger.warn("uploadSSC section was not found");
                } else {
                    projectName = SSCServerConfigUtil.getFieldValue(uploadSSC, "appName");
                    projectVersion = SSCServerConfigUtil.getFieldValue(uploadSSC, "appVersion");
                    if (projectName != null && !projectName.isEmpty() && projectVersion != null && !projectVersion.isEmpty()) {
                        return new SSCProjectVersionPair(projectName, projectVersion);
                    }
                }
                logger.warn("uploadSSC section was not found");
            }
        } else {
            logger.warn("uploadSSC was found ");
            projectName = SSCServerConfigUtil.getFieldValue(uploadSSC, "projectName");
            projectVersion = SSCServerConfigUtil.getFieldValue(uploadSSC, "projectVersion");
            logger.warn("projectName" + projectName + " , ProjectVersion" + projectVersion);
        }
        if (projectName != null && !projectName.isEmpty() && projectVersion != null && !projectVersion.isEmpty()) {
            return new SSCProjectVersionPair(projectName, projectVersion);
        }
        return null;
    }

    private static String getFieldValue(Object someObject, String fieldName) {
        for (Field field : someObject.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (!field.getName().equals(fieldName)) continue;
            Object value = null;
            try {
                value = field.get(someObject);
            }
            catch (IllegalAccessException e) {
                logger.error("Failed to getFieldValue", (Throwable)e);
            }
            if (value == null) continue;
            return value.toString();
        }
        return null;
    }

    private static Object getFieldValueAsObj(Object someObject, String fieldName) {
        for (Field field : someObject.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (!field.getName().equals(fieldName)) continue;
            try {
                return field.get(someObject);
            }
            catch (IllegalAccessException e) {
                logger.error("Failed to getFieldValue", (Throwable)e);
            }
        }
        return null;
    }

    private static Descriptor getSSCDescriptor() {
        Descriptor publisher = Jenkins.get().getDescriptorByName(PUBLISHER_OLD_VERSION);
        if (publisher == null) {
            logger.debug("didn't find Old SSC FPRPublisher");
            Descriptor plugin = Jenkins.get().getDescriptorByName(PUBLISHER_NEW_NAME);
            if (plugin == null) {
                logger.debug("didn't find Fortify Plugin of 18.20 version and above");
            }
            return plugin;
        }
        return publisher;
    }

    public static final class SSCProjectVersionPair {
        public final String project;
        public final String version;

        public SSCProjectVersionPair(String project, String version) {
            this.project = project;
            this.version = version;
        }
    }
}

