/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.configuration;

import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.entities.Entity;
import com.hp.octane.integrations.exceptions.OctaneConnectivityException;
import com.hp.octane.integrations.services.configurationparameters.JobListCacheAllowedParameter;
import com.hp.octane.integrations.services.configurationparameters.UftTestRunnerFolderParameter;
import com.hp.octane.integrations.services.configurationparameters.factory.ConfigurationParameter;
import com.hp.octane.integrations.services.configurationparameters.factory.ConfigurationParameterFactory;
import com.hp.octane.integrations.utils.OctaneUrlParser;
import com.microfocus.application.automation.tools.model.OctaneServerSettingsModel;
import com.microfocus.application.automation.tools.octane.CIJenkinsServicesImpl;
import com.microfocus.application.automation.tools.octane.ImpersonationUtil;
import com.microfocus.application.automation.tools.octane.Messages;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.exceptions.AggregatedMessagesException;
import com.microfocus.application.automation.tools.octane.model.processors.projects.JobProcessorFactory;
import hudson.ProxyConfiguration;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.User;
import hudson.security.ACLContext;
import hudson.security.Permission;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;

public class ConfigurationValidator {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(ConfigurationValidator.class);

    private ConfigurationValidator() {
    }

    public static OctaneUrlParser parseUiLocation(String uiLocation) throws FormValidation {
        try {
            return OctaneUrlParser.parse((String)uiLocation);
        }
        catch (IllegalArgumentException e) {
            throw ConfigurationValidator.wrapWithFormValidation(false, e.getMessage());
        }
    }

    public static FormValidation checkConfigurationAndWrapWithFormValidation(String location, String sharedSpace, String username, Secret password) {
        ArrayList<String> errors = new ArrayList<String>();
        ConfigurationValidator.checkConfiguration(errors, location, sharedSpace, username, password);
        return ConfigurationValidator.wrapWithFormValidation(errors.isEmpty(), errors.isEmpty() ? Messages.ConnectionSuccess() : (String)errors.get(0));
    }

    public static List<Entity> checkConfiguration(List<String> errorMessages, String location, String sharedSpace, String username, Secret password) {
        try {
            return OctaneSDK.testOctaneConfigurationAndFetchAvailableWorkspaces((String)location, (String)sharedSpace, (String)username, (String)password.getPlainText(), CIJenkinsServicesImpl.class);
        }
        catch (OctaneConnectivityException octaneException) {
            errorMessages.add(octaneException.getErrorMessageVal());
        }
        catch (IOException ioe) {
            logger.warn("Connection check failed due to communication problem", (Throwable)ioe);
            errorMessages.add(Messages.ConnectionFailure());
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkImpersonatedUser(List<String> errorMessages, String impersonatedUser) {
        User jenkinsUser = null;
        if (!StringUtils.isEmpty((String)impersonatedUser) && (jenkinsUser = User.get((String)impersonatedUser, (boolean)false, Collections.emptyMap())) == null) {
            errorMessages.add(String.format(Messages.JenkinsUserMisconfiguredFailure(), impersonatedUser));
            return;
        }
        ACLContext impersonatedContext = null;
        try {
            impersonatedContext = ImpersonationUtil.startImpersonation(jenkinsUser);
            HashMap<Permission, String> requiredPermissions = new HashMap<Permission, String>();
            requiredPermissions.put(Item.BUILD, "Job.BUILD");
            requiredPermissions.put(Item.READ, "Job.READ");
            Jenkins jenkins = Jenkins.get();
            Set missingPermissions = requiredPermissions.keySet().stream().filter(p -> !jenkins.hasPermission(p)).map(p -> (String)requiredPermissions.get(p)).collect(Collectors.toSet());
            if (!missingPermissions.isEmpty()) {
                errorMessages.add(String.format(Messages.JenkinsUserPermissionsFailure(), jenkinsUser != null ? jenkinsUser.getId() : impersonatedUser, StringUtils.join(missingPermissions, (String)", ")));
            }
        }
        catch (Exception e) {
            errorMessages.add(String.format(Messages.JenkinsUserUnexpectedError(), impersonatedUser, e.getMessage()));
        }
        finally {
            ImpersonationUtil.stopImpersonation(impersonatedContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getAvailableJobNames(List<String> errorMessages, String impersonatedUser) {
        User jenkinsUser = User.get((String)impersonatedUser, (boolean)false, Collections.emptyMap());
        if (jenkinsUser == null) {
            errorMessages.add(String.format(Messages.JenkinsUserMisconfiguredFailure(), impersonatedUser));
            return Collections.emptySet();
        }
        ACLContext impersonatedContext = null;
        try {
            impersonatedContext = ImpersonationUtil.startImpersonation(jenkinsUser);
            Collection jobNames = Jenkins.get().getJobNames();
            Set<String> validJobNames = jobNames.stream().filter(jobName -> CIJenkinsServicesImpl.isJobIsRelevantForPipelineModule((Job)Jenkins.get().getItemByFullName(jobName))).collect(Collectors.toSet());
            if (validJobNames.isEmpty()) {
                errorMessages.add(String.format("No job is available to the workspace Jenkins user '%s'", impersonatedUser));
            }
            Set<String> set = validJobNames;
            return set;
        }
        catch (Exception e) {
            errorMessages.add(String.format(Messages.JenkinsUserUnexpectedError(), impersonatedUser, e.getMessage()));
            Set<String> set = Collections.emptySet();
            return set;
        }
        finally {
            ImpersonationUtil.stopImpersonation(impersonatedContext);
        }
    }

    public static FormValidation wrapWithFormValidation(boolean success, String message) {
        String color = success ? "green" : "red";
        String msg = "<font color=\"" + color + "\" >" + message + "</font>";
        if (success) {
            return FormValidation.okWithMarkup((String)msg);
        }
        return FormValidation.errorWithMarkup((String)msg);
    }

    public static void checkHoProxySettins(List<String> errorMessages) {
        boolean containsHttp;
        ProxyConfiguration proxy = Jenkins.get().proxy;
        boolean bl = containsHttp = proxy != null && proxy.getNoProxyHostPatterns().stream().anyMatch(p -> p.pattern().toLowerCase().startsWith("http"));
        if (containsHttp) {
            errorMessages.add("In the HTTP Proxy Configuration area, the No Proxy Host field must contain a host name only. Remove the http:// prefix before the host name.");
        }
    }

    public static Map<Long, String> checkWorkspace2ImpersonatedUserConf(String workspace2ImpersonatedUserConf, List<Entity> availableWorkspaces, String impersonatedUser, List<String> errorMessages) {
        Map<Long, String> workspace2ImpersonatedUser = Collections.emptyMap();
        if (workspace2ImpersonatedUserConf == null || workspace2ImpersonatedUserConf.trim().isEmpty()) {
            return workspace2ImpersonatedUser;
        }
        try {
            OctaneServerSettingsModel.parseWorkspace2ImpersonatedUserConf(workspace2ImpersonatedUserConf, false);
        }
        catch (AggregatedMessagesException e) {
            errorMessages.addAll(e.getMessages());
        }
        if (!availableWorkspaces.isEmpty()) {
            workspace2ImpersonatedUser = OctaneServerSettingsModel.parseWorkspace2ImpersonatedUserConf(workspace2ImpersonatedUserConf, true);
            Set accessibleWorkspaceIds = availableWorkspaces.stream().map(Entity::getId).map(id -> Long.parseLong(id)).collect(Collectors.toSet());
            List notAccessibleWorkspaceIds = workspace2ImpersonatedUser.keySet().stream().filter(workspaceId -> !accessibleWorkspaceIds.contains(workspaceId)).collect(Collectors.toList());
            if (!notAccessibleWorkspaceIds.isEmpty()) {
                errorMessages.add("Workspace configuration contains non-accessible Software Delivery Management workspaces: " + String.valueOf(notAccessibleWorkspaceIds));
            }
            ArrayList<String> tempErrorListForGeneralImpersonatedUser = new ArrayList<String>();
            Set<String> availableJobsForGeneralJenkinsUser = ConfigurationValidator.getAvailableJobNames(tempErrorListForGeneralImpersonatedUser, impersonatedUser);
            Set<String> userNames = workspace2ImpersonatedUser.values().stream().collect(Collectors.toSet());
            userNames.forEach(user -> {
                Set unavailableJobsByGeneralImpersonatedUser;
                Set<String> availableJobs = ConfigurationValidator.getAvailableJobNames(errorMessages, user);
                if (!availableJobs.isEmpty() && !(unavailableJobsByGeneralImpersonatedUser = availableJobs.stream().filter(jobName -> !availableJobsForGeneralJenkinsUser.contains(jobName)).collect(Collectors.toSet())).isEmpty()) {
                    errorMessages.add(String.format("There are jobs that are not accessible by '%s', but are accessible by the workspace jenkins user '%s', for example %s ", impersonatedUser, user, unavailableJobsByGeneralImpersonatedUser.stream().limit(3L).collect(Collectors.toSet())));
                }
            });
        }
        return workspace2ImpersonatedUser;
    }

    public static void checkParameters(String parameters, String impersonatedUser, Map<Long, String> workspace2ImpersonatedUser, List<String> fails) {
        Map<String, String> params = OctaneServerSettingsModel.parseParameters(parameters);
        params.entrySet().forEach(entry -> {
            try {
                ConfigurationParameter parameter = ConfigurationParameterFactory.tryCreate((String)((String)entry.getKey()), (String)((String)entry.getValue()));
                if (parameter.getKey().equals("UFT_TEST_RUNNER_FOLDER")) {
                    ConfigurationValidator.checkUftFolderParameterWithImpersonation((UftTestRunnerFolderParameter)parameter, impersonatedUser, fails);
                }
                if (parameter.getKey().equals("JOB_LIST_CACHE_ALLOWED") && ((JobListCacheAllowedParameter)parameter).isAllowed() && !workspace2ImpersonatedUser.isEmpty()) {
                    fails.add("JOB_LIST_CACHE_ALLOWED - is not compatible with defining 'Jenkins user for specific workspaces'");
                }
            }
            catch (NoSuchElementException e1) {
                String failMessage = e1.getMessage() + ". Validate that you use correct format : <param_name> : <param value>";
                fails.add(failMessage);
            }
            catch (Exception ex) {
                fails.add(ex.getMessage());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkUftFolderParameterWithImpersonation(UftTestRunnerFolderParameter param, String impersonatedUser, List<String> fails) {
        User jenkinsUser = null;
        if (!StringUtils.isEmpty((String)impersonatedUser) && (jenkinsUser = User.get((String)impersonatedUser, (boolean)false, Collections.emptyMap())) == null) {
            return;
        }
        ACLContext acl = ImpersonationUtil.startImpersonation(jenkinsUser);
        try {
            ConfigurationValidator.checkUftFolderParameter(param, fails);
        }
        catch (Exception e) {
            fails.add("UFT_TEST_RUNNER_FOLDER - Failed to check parameter : " + e.getMessage());
        }
        finally {
            ImpersonationUtil.stopImpersonation(acl);
        }
    }

    public static void checkUftFolderParameter(UftTestRunnerFolderParameter param, List<String> fails) {
        String folder = param.getFolder();
        Item item = Jenkins.get().getItemByFullName(folder);
        if (item == null) {
            String msg = "UFT_TEST_RUNNER_FOLDER : folder '" + folder + "' is not found. Validate that folder exist and jenkins user has READ permission on the folder.";
            if (folder.contains("/job/")) {
                msg = msg + " Replace '/job/' by '/'.";
            }
            fails.add(msg);
        } else if (!JobProcessorFactory.isFolder(item)) {
            fails.add("UFT_TEST_RUNNER_FOLDER : '" + folder + "' is not a folder.");
        }
    }
}

