/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.branches;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.hp.octane.integrations.OctaneClient;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.exceptions.OctaneBulkException;
import com.hp.octane.integrations.exceptions.OctaneValidationException;
import com.hp.octane.integrations.services.pullrequestsandbranches.BranchSyncResult;
import com.hp.octane.integrations.services.pullrequestsandbranches.PullRequestAndBranchService;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.BranchFetchParameters;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.FetchFactory;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.FetchHandler;
import com.hp.octane.integrations.services.pullrequestsandbranches.rest.ScmTool;
import com.hp.octane.integrations.services.pullrequestsandbranches.rest.authentication.AuthenticationStrategy;
import com.microfocus.application.automation.tools.octane.GitFetchUtils;
import com.microfocus.application.automation.tools.octane.JellyUtils;
import com.microfocus.application.automation.tools.octane.branches.BranchesBuildAction;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class BranchesPublisher
extends Recorder
implements SimpleBuildStep {
    private String configurationId;
    private String workspaceId;
    private String repositoryUrl;
    private String credentialsId;
    private String filter;
    private String scmTool;
    private String useSSHFormat;

    @DataBoundConstructor
    public BranchesPublisher(String configurationId, String workspaceId, String scmTool, String repositoryUrl, String credentialsId, String filter) {
        this.configurationId = "none".equalsIgnoreCase(configurationId) ? null : configurationId;
        this.workspaceId = "none".equalsIgnoreCase(workspaceId) ? null : workspaceId;
        this.repositoryUrl = repositoryUrl;
        this.credentialsId = credentialsId;
        this.filter = filter;
        this.scmTool = "none".equalsIgnoreCase(scmTool) ? null : scmTool;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        this.performInternal(run, taskListener);
    }

    public boolean perform(AbstractBuild build, @Nonnull Launcher launcher, BuildListener listener) {
        this.performInternal((Run<?, ?>)build, (TaskListener)listener);
        return build.getResult() == Result.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performInternal(@Nonnull Run<?, ?> run, @Nonnull TaskListener taskListener) {
        LogConsumer logConsumer = new LogConsumer(taskListener.getLogger());
        logConsumer.printLog("BranchPublisher is started ***********************************************************************");
        if (this.configurationId == null) {
            throw new IllegalArgumentException("Software Delivery Management configuration is not defined.");
        }
        if (this.workspaceId == null) {
            throw new IllegalArgumentException("Software Delivery Management workspace is not defined.");
        }
        if (this.scmTool == null) {
            throw new IllegalArgumentException("SCM Tool is not defined.");
        }
        String myCredentialsId = this.credentialsId;
        String myConfigurationId = this.configurationId;
        String myWorkspaceId = this.workspaceId;
        String myScmTool = this.scmTool;
        String myUseSshFormat = this.useSSHFormat;
        try {
            EnvVars env = run.getEnvironment(taskListener);
            myCredentialsId = env.expand(this.credentialsId);
            myConfigurationId = env.expand(this.configurationId);
            myWorkspaceId = env.expand(this.workspaceId);
            myScmTool = env.expand(this.scmTool);
            myUseSshFormat = env.expand(this.useSSHFormat);
        }
        catch (IOException | InterruptedException e) {
            taskListener.error("Failed loading build environment " + String.valueOf(e));
        }
        BranchFetchParameters fp = this.createFetchParameters(run, taskListener, myUseSshFormat, logConsumer::printLog);
        StandardCredentials credentials = GitFetchUtils.getCredentialsById(myCredentialsId, run, taskListener.getLogger());
        AuthenticationStrategy authenticationStrategy = GitFetchUtils.getAuthenticationStrategy(credentials);
        try {
            String secret = GitFetchUtils.getCredentialsPassword(credentials);
            FetchHandler fetchHandler = FetchFactory.getHandler((ScmTool)ScmTool.fromValue((String)myScmTool), (AuthenticationStrategy)authenticationStrategy, (String)secret);
            OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)myConfigurationId);
            logConsumer.printLog("Software Delivery Management " + octaneClient.getConfigurationService().getConfiguration().getLocationForLog() + ", workspace - " + myWorkspaceId);
            octaneClient.validateOctaneIsActiveAndSupportVersion("15.1.80");
            PullRequestAndBranchService service = OctaneSDK.getClientByInstanceId((String)myConfigurationId).getPullRequestAndBranchService();
            BranchSyncResult result = service.syncBranchesToOctane(fetchHandler, fp, Long.valueOf(Long.parseLong(myWorkspaceId)), GitFetchUtils::getUserIdForCommit, logConsumer::printLog);
            String repoUrlForOctane = fp.isUseSSHFormat() ? fp.getRepoUrlSsh() : fp.getRepoUrl();
            GitFetchUtils.updateRepoTemplates(service, fetchHandler, fp.getRepoUrl(), repoUrlForOctane, Long.parseLong(myWorkspaceId), logConsumer::printLog);
            Class<BranchesBuildAction> clazz = BranchesBuildAction.class;
            synchronized (BranchesBuildAction.class) {
                long index = run.getActions(BranchesBuildAction.class).size();
                BranchesBuildAction buildAction = new BranchesBuildAction(run, result, fp.getRepoUrl(), fp.getFilter(), index);
                run.addAction((Action)buildAction);
                // ** MonitorExit[var18_24] (shouldn't be in output)
            }
        }
        catch (OctaneValidationException e) {
            logConsumer.printLog("Software Delivery Management branch collector failed on validation : " + e.getMessage());
            run.setResult(Result.FAILURE);
        }
        catch (OctaneBulkException e) {
            String exceptions = e.getData().getErrors().stream().map(m -> m.getDescriptionTranslated()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().map(entry -> (String)entry.getKey() + "(" + String.valueOf(entry.getValue()) + ")").collect(Collectors.joining(System.lineSeparator() + "  - ", " Exceptions are : " + System.lineSeparator() + "  - ", ""));
            logConsumer.printLog("Software Delivery Management branch collector failed : " + e.getMessage() + exceptions);
            run.setResult(Result.FAILURE);
        }
        catch (IllegalStateException e) {
            logConsumer.printLog("Software Delivery Management branch collector failed : " + e.getMessage());
            if (e.getMessage() != null && e.getMessage().contains("Duplicate key")) {
                run.setResult(Result.UNSTABLE);
            } else {
                run.setResult(Result.FAILURE);
                e.printStackTrace(taskListener.getLogger());
            }
        }
        catch (Exception e) {
            logConsumer.printLog("Software Delivery Management branch collector failed : " + e.getMessage());
            e.printStackTrace(taskListener.getLogger());
            run.setResult(Result.FAILURE);
        }
        {
            return;
        }
    }

    @DataBoundSetter
    public void setUseSSHFormat(boolean useSSHFormat) {
        this.useSSHFormat = Boolean.toString(useSSHFormat);
    }

    public boolean getUseSSHFormat() {
        return Boolean.parseBoolean(this.useSSHFormat);
    }

    private BranchFetchParameters createFetchParameters(@Nonnull Run<?, ?> run, @Nonnull TaskListener taskListener, String myUseSshFormat, Consumer<String> logConsumer) {
        BranchFetchParameters fp;
        try {
            EnvVars env = run.getEnvironment(taskListener);
            fp = new BranchFetchParameters().setRepoUrl(env.expand(this.repositoryUrl)).setFilter(env.expand(this.filter)).setUseSSHFormat(Boolean.parseBoolean(env.expand(myUseSshFormat)));
        }
        catch (IOException | InterruptedException e) {
            taskListener.error("Failed loading build environment " + String.valueOf(e));
            fp = new BranchFetchParameters().setRepoUrl(this.repositoryUrl).setFilter(this.filter).setUseSSHFormat(Boolean.parseBoolean(myUseSshFormat));
        }
        ParametersAction parameterAction = (ParametersAction)run.getAction(ParametersAction.class);
        if (parameterAction != null) {
            fp.setPageSize(this.getIntegerValueParameter(parameterAction, "branches_page_size"));
            fp.setActiveBranchDays(this.getIntegerValueParameter(parameterAction, "branches_active_branch_days"));
            fp.setMaxBranchesToFill(this.getIntegerValueParameter(parameterAction, "branches_max_branches_to_fill"));
            fp.setSearchBranchOctaneRootRepositoryId(this.getIntegerValueParameter(parameterAction, "search_branch_octane_root_repository_id"));
        }
        logConsumer.accept("Repository URL       : " + fp.getRepoUrl());
        logConsumer.accept("Filter               : " + fp.getFilter());
        logConsumer.accept("Page size            : " + fp.getPageSize());
        logConsumer.accept("Max branches to fill : " + fp.getMaxBranchesToFill());
        logConsumer.accept("Branch active days   : " + fp.getActiveBranchDays());
        logConsumer.accept("Use ssh format       : " + fp.isUseSSHFormat());
        return fp;
    }

    private Integer getIntegerValueParameter(ParametersAction parameterAction, String paramValue) {
        ParameterValue pv = parameterAction.getParameter(paramValue);
        if (pv != null && pv.getValue() instanceof String) {
            try {
                return Integer.valueOf((String)pv.getValue());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public String getConfigurationId() {
        return this.configurationId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getScmTool() {
        return this.scmTool;
    }

    private static class LogConsumer {
        private final PrintStream ps;

        public LogConsumer(PrintStream ps) {
            this.ps = ps;
        }

        public void printLog(String msg) {
            this.ps.println("BranchPublisher : " + msg);
        }
    }

    @Symbol(value={"collectBranchesToAlmOctane"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        static final CredentialsMatcher CREDENTIALS_MATCHER = CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(StringCredentials.class)});

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project, @QueryParameter String credentialsId) {
            return JellyUtils.fillCredentialsIdItems(project, credentialsId, CREDENTIALS_MATCHER);
        }

        public ListBoxModel doFillScmToolItems() {
            ListBoxModel m = JellyUtils.createComboModelWithNoneValue();
            for (ScmTool tool : ScmTool.values()) {
                m.add(tool.getDesc(), tool.getValue());
            }
            return m;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public ListBoxModel doFillConfigurationIdItems() {
            return JellyUtils.fillConfigurationIdModel();
        }

        public ListBoxModel doFillWorkspaceIdItems(@QueryParameter String configurationId, @QueryParameter(value="workspaceId") String workspaceId) {
            return JellyUtils.fillWorkspaceModel(configurationId, workspaceId);
        }

        public String getDisplayName() {
            return "Software Delivery Management branch collector";
        }
    }
}

