/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.branches;

import com.hp.octane.integrations.services.pullrequestsandbranches.BranchSyncResult;
import com.microfocus.application.automation.tools.octane.GitFetchUtils;
import com.microfocus.application.automation.tools.octane.Messages;
import hudson.model.Action;
import hudson.model.Run;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.CheckForNull;

public class BranchesBuildAction
implements Action {
    private final Run<?, ?> build;
    private final BranchSyncResult branchSyncResult;
    private final String filter;
    private final String repositoryUrl;
    private final Long index;
    private SimpleDateFormat dateFormat = null;

    @CheckForNull
    public String getIconFileName() {
        return "notepad.png";
    }

    public BranchesBuildAction(Run<?, ?> build, BranchSyncResult branchSyncResult, String repositoryUrl, String filter, long index) {
        this.index = index;
        this.build = build;
        this.branchSyncResult = branchSyncResult;
        this.filter = filter;
        this.repositoryUrl = repositoryUrl;
    }

    @CheckForNull
    public String getDisplayName() {
        return Messages.BranchActionConfigurationLabel();
    }

    @CheckForNull
    public String getUrlName() {
        return "branch-report" + (String)(this.index == null || this.index.equals(0L) ? "" : "-" + this.index);
    }

    public BranchSyncResult getBranchSyncResult() {
        return this.branchSyncResult;
    }

    public final Run<?, ?> getBuild() {
        return this.build;
    }

    public String getFormattedDate(long longTime) {
        if (this.dateFormat == null) {
            this.dateFormat = GitFetchUtils.generateDateFormat();
        }
        return this.dateFormat.format(new Date(longTime));
    }

    public String getFilter() {
        return this.filter;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }
}

