/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.actions.cucumber;

import com.microfocus.application.automation.tools.octane.Messages;
import com.microfocus.application.automation.tools.octane.actions.cucumber.CucumberResultsService;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CucumberTestResultsAction
implements Action {
    private final String glob;
    private final Run<?, ?> build;

    CucumberTestResultsAction(Run<?, ?> run, String glob, TaskListener listener) {
        this.build = run;
        this.glob = glob;
        CucumberResultsService.setListener(listener);
    }

    public boolean copyResultsToBuildFolder(Run<?, ?> run, FilePath workspace) {
        try {
            CucumberResultsService.log(Messages.CucumberResultsActionCollecting(), new String[0]);
            String[] files = CucumberResultsService.getCucumberResultFiles(workspace, this.glob);
            boolean found = files.length > 0;
            for (String fileName : files) {
                File resultFile = new File(workspace.child(fileName).toURI());
                if (resultFile.lastModified() == 0L || run.getStartTimeInMillis() < resultFile.lastModified()) {
                    CucumberResultsService.copyResultFile(resultFile, this.build.getRootDir(), workspace);
                    continue;
                }
                String pattern = "yyyy-MM-dd HH:mm:ss";
                SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
                CucumberResultsService.log("Found outdated file %s, build started at %s (%s), while file last update time is %s (%s) ", resultFile.getPath(), dateFormat.format(new Date(run.getStartTimeInMillis())), String.valueOf(run.getStartTimeInMillis()), dateFormat.format(new Date(resultFile.lastModified())), String.valueOf(resultFile.lastModified()));
            }
            if (!found && this.build.getResult() != Result.FAILURE) {
                CucumberResultsService.log(Messages.CucumberResultsActionNotFound(), new String[0]);
            }
            return found;
        }
        catch (Exception e) {
            CucumberResultsService.log(Messages.CucumberResultsActionError(), e.toString());
            return false;
        }
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }
}

