/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.actions.coverage;

import com.microfocus.application.automation.tools.octane.actions.coverage.CoverageService;
import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerUtils;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class CoveragePublisherAction
implements Action {
    private final Run build;

    public CoveragePublisherAction(Run build, TaskListener listener) {
        this.build = build;
        CoverageService.setListener(listener);
    }

    public List<String> copyCoverageReportsToBuildFolder(String filePattern, String defaultFileName) {
        LinkedList<String> result = new LinkedList<String>();
        FilePath workspace = BuildHandlerUtils.getWorkspace(this.build);
        if (workspace != null) {
            try {
                CoverageService.log("start copying coverage report to build folder, using file patten of " + filePattern);
                String[] files = CoverageService.getCoverageFiles(workspace, filePattern);
                ArrayList<String> matchingReportFiles = this.filterFilesByFileExtension(files);
                int index = 0;
                for (String fileName : matchingReportFiles) {
                    File resultFile = new File(workspace.child(fileName).toURI());
                    String nextOutputFilename = CoverageService.getCoverageReportFileName(index++, defaultFileName);
                    result.add(nextOutputFilename);
                    File targetReportFile = new File(this.build.getRootDir(), nextOutputFilename);
                    CoverageService.copyCoverageFile(resultFile, targetReportFile, workspace);
                }
                if (result.isEmpty()) {
                    CoverageService.log("No coverage file that matched the specified pattern was found in workspace");
                }
            }
            catch (Exception e) {
                CoverageService.log("Copying coverage files to build folder failed because of " + e.toString());
            }
        }
        return result;
    }

    private ArrayList<String> filterFilesByFileExtension(String[] files) {
        ArrayList<String> filteredList = new ArrayList<String>();
        for (String fileFullPath : files) {
            if (!fileFullPath.endsWith(".info") && !fileFullPath.endsWith(".xml")) continue;
            filteredList.add(fileFullPath);
        }
        return filteredList;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }
}

