/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.actions;

import com.hp.octane.integrations.OctaneClient;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.services.vulnerabilities.ToolType;
import com.microfocus.application.automation.tools.octane.ImpersonationUtil;
import com.microfocus.application.automation.tools.octane.actions.WebhookAction;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.model.SonarHelper;
import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerUtils;
import com.microfocus.application.automation.tools.octane.vulnerabilities.VulnerabilitiesUtils;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.UnprotectedRootAction;
import hudson.security.ACLContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import org.apache.logging.log4j.Logger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class Webhooks
implements UnprotectedRootAction {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(Webhooks.class);
    public static final String WEBHOOK_PATH = "webhooks";
    public static final String NOTIFY_METHOD = "/notify";
    private String PROJECT_KEY_KEY = "PROJECT_KEY";
    private String SONAR_URL_KEY = "SONAR_URL";
    private String SONAR_TOKEN_KEY = "SONAR_TOKEN";
    private String REMOTE_TAG_KEY = "REMOTE_TAG";
    private final String PROJECT = "project";
    private final String SONAR_PROJECT_KEY_NAME = "key";
    private final String IS_EXPECTING_FILE_NAME = "is_expecting.txt";
    private final String JOB_NAME_PARAM_NAME = "sonar.analysis.jobName";
    private final String BUILD_NUMBER_PARAM_NAME = "sonar.analysis.buildNumber";
    private static final String PROJECT_KEY_HEADER = "X-SonarQube-Project";

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return WEBHOOK_PATH;
    }

    @RequirePOST
    public void doNotify(StaplerRequest req, StaplerResponse res) throws IOException {
        Map sonarAttachedProperties;
        logger.info("Received POST from " + req.getRemoteHost());
        JSONObject inputNotification = (JSONObject)JSONValue.parse((InputStream)req.getInputStream());
        Object properties = inputNotification.get((Object)"properties");
        ExtensionList allConfigurations = GlobalConfiguration.all();
        GlobalConfiguration sonarConfiguration = (GlobalConfiguration)allConfigurations.getDynamic("hudson.plugins.sonar.SonarGlobalConfiguration");
        if (sonarConfiguration != null && !req.getHeader(PROJECT_KEY_HEADER).isEmpty() && properties instanceof Map && (sonarAttachedProperties = (Map)properties).containsKey("sonar.analysis.buildNumber") && sonarAttachedProperties.containsKey("sonar.analysis.jobName")) {
            int buildId;
            String jobName = (String)sonarAttachedProperties.get("sonar.analysis.jobName");
            String buildIdStr = (String)sonarAttachedProperties.get("sonar.analysis.buildNumber");
            try {
                buildId = Integer.parseInt(buildIdStr);
            }
            catch (NumberFormatException e) {
                logger.warn("Got request from sonarqube webhook listener, but buildIdStr is illegal : " + buildIdStr);
                res.setStatus(406);
                return;
            }
            logger.warn(String.format("Got sonarqube webhook for : %s #%s", jobName, buildIdStr));
            Run run = null;
            for (OctaneClient octaneClient : OctaneSDK.getClients()) {
                try {
                    Job jenkinsJob;
                    if (octaneClient.getConfigurationService().getConfiguration().isDisabled() || (jenkinsJob = this.getJob(octaneClient, jobName)) == null) continue;
                    run = jenkinsJob.getBuildByNumber(buildId);
                    if (run == null) {
                        logger.warn("Got request from sonarqube webhook listener, but build " + buildIdStr + " context could not be resolved");
                        res.setStatus(406);
                        return;
                    }
                    if (!this.isRunExpectingToGetWebhookCall(run).booleanValue() || this.isRunAlreadyGotWebhookCall(run).booleanValue()) {
                        return;
                    }
                    WebhookAction action = (WebhookAction)run.getAction(WebhookAction.class);
                    String parents = BuildHandlerUtils.getRootJobCiIds(run);
                    String sonarToken = SonarHelper.getSonarInstallationTokenByUrl(sonarConfiguration, action.getServerUrl(), run);
                    HashMap project = (HashMap)inputNotification.get((Object)"project");
                    String sonarProjectKey = (String)project.get("key");
                    String ciJobId = BuildHandlerUtils.translateFolderJobName(jobName);
                    if (action.getDataTypeSet().contains((Object)SonarHelper.DataType.COVERAGE)) {
                        octaneClient.getSonarService().enqueueFetchAndPushSonarCoverage(ciJobId, buildIdStr, sonarProjectKey, action.getServerUrl(), sonarToken, parents);
                    }
                    if (action.getDataTypeSet().contains((Object)SonarHelper.DataType.VULNERABILITIES)) {
                        HashMap<String, String> additionalProperties = new HashMap<String, String>();
                        additionalProperties.put(this.PROJECT_KEY_KEY, sonarProjectKey);
                        additionalProperties.put(this.SONAR_URL_KEY, action.getServerUrl());
                        additionalProperties.put(this.SONAR_TOKEN_KEY, sonarToken);
                        additionalProperties.put(this.REMOTE_TAG_KEY, sonarProjectKey);
                        octaneClient.getVulnerabilitiesService().enqueueRetrieveAndPushVulnerabilities(ciJobId, buildIdStr, ToolType.SONAR, run.getStartTimeInMillis(), (long)VulnerabilitiesUtils.getFortifyTimeoutHours(octaneClient.getInstanceId()), additionalProperties, parents);
                    }
                    res.setStatus(200);
                }
                catch (Exception e) {
                    logger.error("exception occurred while trying to enqueue fetchAndPush task to octane, clientId: " + octaneClient.getInstanceId() + ", jobName: " + jobName + ", build: " + buildIdStr + ",", (Throwable)e);
                }
            }
            if (run != null) {
                this.markBuildAsReceivedWebhookCall(run);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Job getJob(OctaneClient octaneClient, String jobName) {
        ACLContext aclContext = null;
        try {
            aclContext = ImpersonationUtil.startImpersonation(octaneClient.getInstanceId(), null);
            Item topLevelItem = Jenkins.get().getItemByFullName(jobName);
            if (topLevelItem != null && topLevelItem instanceof Job) {
                Job jenkinsJob;
                Job job = jenkinsJob = (Job)topLevelItem;
                return job;
            }
            Job job = null;
            return job;
        }
        finally {
            if (aclContext != null) {
                ImpersonationUtil.stopImpersonation(aclContext);
            }
        }
    }

    private Boolean isRunAlreadyGotWebhookCall(Run run) {
        try {
            File rootDir = run.getRootDir();
            File isExpectingFile = new File(rootDir, "is_expecting.txt");
            FileInputStream fis = new FileInputStream(isExpectingFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            return (Boolean)ois.readObject();
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    private Boolean isRunExpectingToGetWebhookCall(Run run) {
        WebhookAction action = (WebhookAction)run.getAction(WebhookAction.class);
        return action != null && action.getExpectingToGetWebhookCall() != false;
    }

    private void markBuildAsReceivedWebhookCall(Run run) throws IOException {
        if (run == null) {
            return;
        }
        File buildBaseFolder = run.getRootDir();
        File isExpectingFile = new File(buildBaseFolder, "is_expecting.txt");
        FileOutputStream fos = new FileOutputStream(isExpectingFile);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(true);
    }
}

