/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.actions;

import com.hp.octane.integrations.OctaneClient;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.entities.Entity;
import com.hp.octane.integrations.dto.entities.impl.EntityImpl;
import com.hp.octane.integrations.dto.executor.impl.TestingToolType;
import com.hp.octane.integrations.dto.scm.SCMType;
import com.hp.octane.integrations.services.configuration.ConfigurationService;
import com.hp.octane.integrations.services.entities.EntitiesService;
import com.hp.octane.integrations.services.entities.QueryHelper;
import com.hp.octane.integrations.uft.items.UftTestDiscoveryResult;
import com.microfocus.application.automation.tools.octane.JellyUtils;
import com.microfocus.application.automation.tools.octane.Messages;
import com.microfocus.application.automation.tools.octane.actions.UFTActionDetectionBuildAction;
import com.microfocus.application.automation.tools.octane.actions.UFTTestDetectionBuildAction;
import com.microfocus.application.automation.tools.octane.executor.FullSyncRequiredCause;
import com.microfocus.application.automation.tools.octane.executor.UFTTestDetectionCallable;
import com.microfocus.application.automation.tools.octane.executor.UFTTestDetectionService;
import com.microfocus.application.automation.tools.octane.executor.UftTestDiscoveryDispatcher;
import com.microfocus.application.automation.tools.octane.executor.scmmanager.ScmPluginFactory;
import com.microfocus.application.automation.tools.octane.executor.scmmanager.ScmPluginHandler;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BooleanParameterValue;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.FreeStyleProject;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.NullSCM;
import hudson.scm.SCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class UFTTestDetectionPublisher
extends Recorder {
    private String configurationId;
    private String workspaceName;
    private String scmRepositoryId;
    private TestingToolType testingToolType;

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public String getScmRepositoryId() {
        return this.scmRepositoryId;
    }

    @DataBoundConstructor
    public UFTTestDetectionPublisher(String configurationId, String workspaceName, String scmRepositoryId) {
        this.configurationId = configurationId;
        this.workspaceName = workspaceName;
        this.scmRepositoryId = scmRepositoryId;
        this.testingToolType = TestingToolType.UFT;
    }

    public void setTestingToolType(TestingToolType testingToolType) {
        this.testingToolType = testingToolType;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        UFTTestDetectionService.printToConsole(listener, "UFTTestDetectionPublisher is started.");
        try {
            if (this.configurationId == null || "none".equals(this.configurationId)) {
                throw new IllegalArgumentException("Software Delivery Management configuration is missing.");
            }
            if (this.workspaceName == null || "none".equals(this.workspaceName)) {
                throw new IllegalArgumentException("Software Delivery Management workspace is missing.");
            }
            if (StringUtils.isEmpty((String)this.scmRepositoryId)) {
                this.generateScmRepository(build, listener);
            }
        }
        catch (IllegalArgumentException e) {
            UFTTestDetectionService.printToConsole(listener, e.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
        try {
            if (this.testingToolType == null || TestingToolType.UNKNOWN.equals((Object)this.testingToolType)) {
                this.testingToolType = TestingToolType.UFT;
            }
            UftTestDiscoveryResult results = (UftTestDiscoveryResult)build.getWorkspace().act((FilePath.FileCallable)new UFTTestDetectionCallable(build, this.configurationId, this.workspaceName, this.getScmRepositoryId(), listener, this.testingToolType));
            Action buildAction = UFTTestDetectionPublisher.getBuildAction(this.testingToolType, build, results);
            build.addAction(buildAction);
            if (results.hasChanges()) {
                UFTTestDetectionService.publishDetectionResults((Run)build, (TaskListener)listener, results);
                UftTestDiscoveryDispatcher dispatcher = UFTTestDetectionPublisher.getExtension(UftTestDiscoveryDispatcher.class);
                dispatcher.enqueueResult(this.configurationId, build.getProject().getFullName(), build.getNumber(), this.workspaceName);
            }
            if (!results.getDeletedFolders().isEmpty()) {
                UFTTestDetectionService.printToConsole(listener, String.format("Found %s deleted folders", results.getDeletedFolders().size()));
                UFTTestDetectionService.printToConsole(listener, "To sync deleted items - full sync required. Triggering job with full sync parameter.");
                this.handleDeletedFolders(build);
            }
        }
        catch (Exception e) {
            UFTTestDetectionService.printToConsole(listener, "UFTTestDetectionPublisher.perform is failed : " + e.getMessage());
            build.setResult(Result.FAILURE);
        }
        return true;
    }

    private static Action getBuildAction(TestingToolType testingToolType, AbstractBuild<?, ?> build, UftTestDiscoveryResult results) {
        if (TestingToolType.MBT.equals((Object)testingToolType)) {
            return new UFTActionDetectionBuildAction(build, results);
        }
        return new UFTTestDetectionBuildAction(build, results);
    }

    private void generateScmRepository(AbstractBuild build, BuildListener listener) {
        SCM scm = build.getProject().getScm();
        if (scm instanceof NullSCM) {
            throw new IllegalArgumentException("SCM definition is missing in the job");
        }
        ScmPluginHandler scmPluginHandler = ScmPluginFactory.getScmHandlerByScmPluginName(scm.getType());
        String url = ScmPluginFactory.getScmHandlerByScmPluginName(scm.getType()).getScmRepositoryUrl(scm);
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException("SCM url is not defined in the job");
        }
        OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)this.configurationId);
        EntitiesService entitiesService = octaneClient.getEntitiesService();
        ConfigurationService configurationService = octaneClient.getConfigurationService();
        long workspaceId = Long.parseLong(this.workspaceName);
        this.scmRepositoryId = configurationService.isOctaneVersionGreaterOrEqual("15.1.28") ? UFTTestDetectionPublisher.getScmRepositoriesWithRoots(listener, scmPluginHandler, url, entitiesService, workspaceId) : UFTTestDetectionPublisher.getScmRepositoriesLegacy(listener, scmPluginHandler, url, entitiesService, workspaceId);
        try {
            build.getProject().save();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to save job with updated SCM repository. Update manually SCM repository to " + this.scmRepositoryId + ". Error message : " + e.getMessage());
        }
        UFTTestDetectionService.printToConsole(listener, "SCM repository field value is updated to " + this.scmRepositoryId);
    }

    private static String getScmRepositoriesLegacy(BuildListener listener, ScmPluginHandler scmPluginHandler, String url, EntitiesService entitiesService, long workspaceId) {
        String scmRepoId;
        String collectionName = "scm_repositories";
        List<String> conditions = Collections.singletonList(QueryHelper.condition((String)"url", (String)url));
        List foundEntities = entitiesService.getEntities(Long.valueOf(workspaceId), collectionName, conditions, Collections.singletonList("id"));
        if (!foundEntities.isEmpty()) {
            scmRepoId = ((Entity)foundEntities.get(0)).getId();
            UFTTestDetectionService.printToConsole(listener, "SCM repository " + url + " is already exist in Software Delivery Management with id=" + scmRepoId);
        } else {
            Entity newScmRepository = UFTTestDetectionPublisher.buildNewRepoEntity(scmPluginHandler, url, "scm_repository");
            String name = scmPluginHandler.tryExtractUrlShortName(url) + (SCMType.GIT.equals((Object)scmPluginHandler.getScmType()) ? ":master" : "");
            newScmRepository.setName(name);
            List createEntities = entitiesService.postEntities(Long.valueOf(workspaceId), collectionName, Collections.singletonList(newScmRepository));
            scmRepoId = ((Entity)createEntities.get(0)).getId();
            UFTTestDetectionService.printToConsole(listener, "SCM repository " + url + " is created in Software Delivery Management with id=" + scmRepoId);
        }
        return scmRepoId;
    }

    private static String getScmRepositoriesWithRoots(BuildListener listener, ScmPluginHandler scmPluginHandler, String url, EntitiesService entitiesService, long workspaceId) {
        String scmBranchId;
        String scmRootId;
        String branchCollectionName = "scm_repositories";
        String rootCollectionName = "scm_repository_roots";
        boolean isGit = SCMType.GIT.equals((Object)scmPluginHandler.getScmType());
        List<String> conditions = Collections.singletonList(QueryHelper.condition((String)"url", (String)url));
        List foundEntities = entitiesService.getEntities(Long.valueOf(workspaceId), rootCollectionName, conditions, Collections.singletonList("id"));
        if (!foundEntities.isEmpty()) {
            scmRootId = ((Entity)foundEntities.get(0)).getId();
            UFTTestDetectionService.printToConsole(listener, String.format("SCM repository root %s is already exist in Software Delivery Management with id=%s", url, scmRootId));
        } else {
            Entity newScmRepositoryRoot = UFTTestDetectionPublisher.buildNewRepoEntity(scmPluginHandler, url, "scm_repository_root");
            List createEntities = entitiesService.postEntities(Long.valueOf(workspaceId), rootCollectionName, Collections.singletonList(newScmRepositoryRoot));
            scmRootId = ((Entity)createEntities.get(0)).getId();
            UFTTestDetectionService.printToConsole(listener, String.format("SCM repository root %s  is created in Software Delivery Management with id=%s", url, scmRootId));
        }
        String name = scmPluginHandler.tryExtractUrlShortName(url) + (isGit ? ":master" : "");
        String branchCondition = QueryHelper.orConditions((String[])new String[]{QueryHelper.condition((String)"branch", (String)"master"), QueryHelper.conditionEmpty((String)"branch")});
        conditions = Collections.singletonList(branchCondition);
        foundEntities = entitiesService.getEntities(Long.valueOf(workspaceId), branchCollectionName, conditions, Arrays.asList("id", "branch"));
        if (!foundEntities.isEmpty()) {
            scmBranchId = ((Entity)foundEntities.get(0)).getId();
            UFTTestDetectionService.printToConsole(listener, String.format("SCM branch %s is already exist in Software Delivery Management with id=%s", name, scmBranchId));
        } else {
            Entity newBranch = UFTTestDetectionPublisher.buildNewRepoEntity(scmPluginHandler, url, "scm_repository");
            newBranch.setName(name);
            if (isGit) {
                newBranch.setField("branch", (Object)"master");
            }
            Entity scmRoot = new EntityImpl().setType("scm_repository_root").setId(scmRootId);
            newBranch.setField("repository", (Object)scmRoot);
            List createEntities = entitiesService.postEntities(Long.valueOf(workspaceId), branchCollectionName, Collections.singletonList(newBranch));
            scmBranchId = ((Entity)createEntities.get(0)).getId();
            UFTTestDetectionService.printToConsole(listener, String.format("SCM branch %s is created in Software Delivery Management with id=%s", name, scmBranchId));
        }
        return scmBranchId;
    }

    private static Entity buildNewRepoEntity(ScmPluginHandler scmPluginHandler, String url, String entityType) {
        EntityImpl newScmRepositoryRoot = new EntityImpl();
        newScmRepositoryRoot.setType(entityType);
        String name = scmPluginHandler.tryExtractUrlShortName(url);
        newScmRepositoryRoot.setName(name);
        newScmRepositoryRoot.setField("url", (Object)url);
        newScmRepositoryRoot.setField("scm_type", (Object)scmPluginHandler.getScmType().getOctaneId());
        return newScmRepositoryRoot;
    }

    private void handleDeletedFolders(AbstractBuild build) {
        FreeStyleProject proj = (FreeStyleProject)build.getParent();
        ArrayList<ParameterValue> newParameters = new ArrayList<ParameterValue>();
        for (ParameterValue param : ((ParametersAction)build.getAction(ParametersAction.class)).getParameters()) {
            Object paramForSet = param.getName().equals("Full sync") ? new BooleanParameterValue("Full sync", true) : param;
            newParameters.add((ParameterValue)paramForSet);
        }
        ParametersAction parameters = new ParametersAction(newParameters);
        CauseAction causeAction = new CauseAction((Cause)new FullSyncRequiredCause(build.getId()));
        proj.scheduleBuild2(60, new Action[]{parameters, causeAction});
    }

    private static <T> T getExtension(Class<T> clazz) {
        ExtensionList items = Jenkins.get().getExtensionList(clazz);
        return (T)items.get(0);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getConfigurationId() {
        return this.configurationId;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public ListBoxModel doFillConfigurationIdItems() {
            return JellyUtils.fillConfigurationIdModel();
        }

        public ListBoxModel doFillWorkspaceNameItems(@QueryParameter String configurationId, @QueryParameter(value="workspaceName") String workspaceName) {
            return JellyUtils.fillWorkspaceModel(configurationId, workspaceName);
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return aClass.equals(FreeStyleProject.class);
        }

        public String getDisplayName() {
            return Messages.UFTTestDetectionPublisherConfigurationLabel();
        }
    }
}

