/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.actions;

import com.hp.octane.integrations.uft.items.OctaneStatus;
import com.hp.octane.integrations.uft.items.SupportsOctaneStatus;
import com.hp.octane.integrations.uft.items.UftTestDiscoveryResult;
import com.microfocus.application.automation.tools.octane.Messages;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Run;
import java.util.List;

public class UFTTestDetectionBuildAction
implements Action {
    private AbstractBuild<?, ?> build;
    private UftTestDiscoveryResult results;

    public String getIconFileName() {
        return "notepad.png";
    }

    public String getDisplayName() {
        return Messages.UFTTestDetectionBuildActionConfigurationLabel();
    }

    public String getUrlName() {
        return "uft_report";
    }

    public final Run<?, ?> getBuild() {
        return this.build;
    }

    public UFTTestDetectionBuildAction(AbstractBuild<?, ?> build, UftTestDiscoveryResult results) {
        this.build = build;
        this.results = results == null ? new UftTestDiscoveryResult() : results;
    }

    public UftTestDiscoveryResult getResults() {
        return this.results;
    }

    public boolean getHasNewTests() {
        return UFTTestDetectionBuildAction.countItemsWithStatus(OctaneStatus.NEW, this.results.getAllTests()) > 0;
    }

    public boolean getHasDeletedTests() {
        return UFTTestDetectionBuildAction.countItemsWithStatus(OctaneStatus.DELETED, this.results.getAllTests()) > 0;
    }

    public boolean getHasUpdatedTests() {
        return UFTTestDetectionBuildAction.countItemsWithStatus(OctaneStatus.MODIFIED, this.results.getAllTests()) > 0;
    }

    public boolean getHasQuotedPaths() {
        return this.results.isHasQuotedPaths();
    }

    public boolean getHasNewScmResources() {
        return UFTTestDetectionBuildAction.countItemsWithStatus(OctaneStatus.NEW, this.results.getAllScmResourceFiles()) > 0;
    }

    public boolean getHasDeletedScmResources() {
        return UFTTestDetectionBuildAction.countItemsWithStatus(OctaneStatus.DELETED, this.results.getAllScmResourceFiles()) > 0;
    }

    public boolean getHasUpdatedScmResources() {
        return UFTTestDetectionBuildAction.countItemsWithStatus(OctaneStatus.MODIFIED, this.results.getAllScmResourceFiles()) > 0;
    }

    public boolean getHasDeletedFolders() {
        return this.results.getDeletedFolders().size() > 0;
    }

    public void setResults(UftTestDiscoveryResult results) {
        this.results = results;
    }

    private static int countItemsWithStatus(OctaneStatus status, List<? extends SupportsOctaneStatus> items) {
        int count = 0;
        for (SupportsOctaneStatus supportsOctaneStatus : items) {
            if (!supportsOctaneStatus.getOctaneStatus().equals((Object)status)) continue;
            ++count;
        }
        return count;
    }
}

