/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.hp.octane.integrations.OctaneClient;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.entities.Entity;
import com.hp.octane.integrations.services.entities.EntitiesService;
import com.microfocus.application.automation.tools.model.OctaneServerSettingsModel;
import com.microfocus.application.automation.tools.octane.configuration.ConfigurationService;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class JellyUtils {
    public static final String NONE = "none";
    public static final String NONE_DISPLAY = "- none - ";

    private JellyUtils() {
    }

    public static ListBoxModel createComboModelWithNoneValue() {
        ListBoxModel m = new ListBoxModel();
        m.add(NONE_DISPLAY, NONE);
        return m;
    }

    public static ListBoxModel fillWorkspaceModel(String configurationId, String workspaceId) {
        ListBoxModel m = JellyUtils.createComboModelWithNoneValue();
        if (StringUtils.isNotEmpty((String)configurationId) && !NONE.equals(configurationId)) {
            try {
                EntitiesService entitiesService = OctaneSDK.getClientByInstanceId((String)configurationId).getEntitiesService();
                List workspaces = entitiesService.getEntities(null, "workspaces", null, null);
                for (Entity workspace : workspaces) {
                    m.add(workspace.getId() + " " + workspace.getName(), String.valueOf(workspace.getId()));
                }
            }
            catch (Exception e) {
                m.add(workspaceId, workspaceId);
                return m;
            }
        }
        return m;
    }

    public static ListBoxModel fillConfigurationIdModel() {
        ListBoxModel m = JellyUtils.createComboModelWithNoneValue();
        for (OctaneClient octaneClient : OctaneSDK.getClients()) {
            OctaneServerSettingsModel model = ConfigurationService.getSettings(octaneClient.getInstanceId());
            m.add(model.getCaption(), model.getIdentity());
        }
        return m;
    }

    public static ListBoxModel fillCredentialsIdItems(Item project, String credentialsId, CredentialsMatcher credentialsMatcher) {
        if (project == null || !project.hasPermission(Item.CONFIGURE)) {
            return new StandardUsernameListBoxModel().includeCurrentValue(credentialsId);
        }
        return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(project instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM, project, StandardCredentials.class, URIRequirementBuilder.create().build(), credentialsMatcher).includeCurrentValue(credentialsId);
    }
}

