/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane;

import com.hp.octane.integrations.exceptions.PermissionException;
import com.microfocus.application.automation.tools.model.OctaneServerSettingsModel;
import com.microfocus.application.automation.tools.octane.configuration.ConfigurationService;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.util.Collections;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;

public class ImpersonationUtil {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(ImpersonationUtil.class);

    public static String getUserNameForImpersonation(String instanceId, Long workspaceId) {
        String userName;
        OctaneServerSettingsModel settings = ConfigurationService.getSettings(instanceId);
        if (settings == null) {
            throw new IllegalStateException("failed to retrieve configuration settings by instance ID " + instanceId);
        }
        if (workspaceId != null && settings.getWorkspace2ImpersonatedUserMap().containsKey(workspaceId)) {
            userName = settings.getWorkspace2ImpersonatedUserMap().get(workspaceId);
            logger.info(String.format("Using workspace jenkins user '%s' for workspace '%s'", userName, workspaceId));
        } else {
            userName = settings.getImpersonatedUser();
        }
        return userName;
    }

    public static ACLContext startImpersonation(String instanceId, Long workspaceId) {
        String userName = ImpersonationUtil.getUserNameForImpersonation(instanceId, workspaceId);
        User jenkinsUser = null;
        if (!StringUtils.isEmpty((String)userName) && (jenkinsUser = User.get((String)userName, (boolean)false, Collections.emptyMap())) == null) {
            throw new PermissionException(401);
        }
        return ImpersonationUtil.startImpersonation(jenkinsUser);
    }

    public static ACLContext startImpersonation(User jenkinsUser) {
        ACLContext impersonatedContext;
        try {
            impersonatedContext = ACL.as((User)jenkinsUser);
        }
        catch (UsernameNotFoundException e) {
            logger.debug("Failed to get impersonatedContext from user. Trial to get impersonatedContext by manual auth creation.");
            Authentication auth = jenkinsUser == null ? Jenkins.ANONYMOUS : new UsernamePasswordAuthenticationToken((Object)jenkinsUser.getId(), (Object)"", new GrantedAuthority[0]);
            impersonatedContext = ACL.as((Authentication)auth);
        }
        return impersonatedContext;
    }

    public static void stopImpersonation(ACLContext impersonatedContext) {
        if (impersonatedContext != null) {
            impersonatedContext.close();
        }
    }
}

