/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.hp.octane.integrations.CIPluginServices;
import com.hp.octane.integrations.OctaneClient;
import com.hp.octane.integrations.OctaneConfiguration;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.configuration.CIProxyConfiguration;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.events.CIEvent;
import com.hp.octane.integrations.dto.events.MultiBranchType;
import com.hp.octane.integrations.dto.executor.CredentialsInfo;
import com.hp.octane.integrations.dto.executor.DiscoveryInfo;
import com.hp.octane.integrations.dto.executor.TestConnectivityInfo;
import com.hp.octane.integrations.dto.general.CIBranchesList;
import com.hp.octane.integrations.dto.general.CIBuildStatusInfo;
import com.hp.octane.integrations.dto.general.CIJobsList;
import com.hp.octane.integrations.dto.general.CIPluginInfo;
import com.hp.octane.integrations.dto.general.CIServerInfo;
import com.hp.octane.integrations.dto.general.CIServerTypes;
import com.hp.octane.integrations.dto.parameters.CIParameter;
import com.hp.octane.integrations.dto.parameters.CIParameters;
import com.hp.octane.integrations.dto.pipelines.PipelineNode;
import com.hp.octane.integrations.dto.scm.Branch;
import com.hp.octane.integrations.dto.securityscans.FodServerConfiguration;
import com.hp.octane.integrations.dto.securityscans.SSCProjectConfiguration;
import com.hp.octane.integrations.dto.snapshots.CIBuildResult;
import com.hp.octane.integrations.dto.snapshots.CIBuildStatus;
import com.hp.octane.integrations.exceptions.ConfigurationException;
import com.hp.octane.integrations.exceptions.PermissionException;
import com.hp.octane.integrations.services.configurationparameters.FortifySSCTokenParameter;
import com.hp.octane.integrations.services.configurationparameters.UftTestRunnerFolderParameter;
import com.hp.octane.integrations.services.configurationparameters.factory.ConfigurationParameterFactory;
import com.microfocus.application.automation.tools.model.OctaneServerSettingsModel;
import com.microfocus.application.automation.tools.octane.ImpersonationUtil;
import com.microfocus.application.automation.tools.octane.configuration.ConfigurationService;
import com.microfocus.application.automation.tools.octane.configuration.ConfigurationValidator;
import com.microfocus.application.automation.tools.octane.configuration.FodConfigUtil;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.configuration.SSCServerConfigUtil;
import com.microfocus.application.automation.tools.octane.executor.ExecutorConnectivityService;
import com.microfocus.application.automation.tools.octane.executor.TestExecutionJobCreatorService;
import com.microfocus.application.automation.tools.octane.executor.UftJobRecognizer;
import com.microfocus.application.automation.tools.octane.model.ModelFactory;
import com.microfocus.application.automation.tools.octane.model.processors.parameters.ParameterProcessors;
import com.microfocus.application.automation.tools.octane.model.processors.projects.AbstractProjectProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.projects.JobProcessorFactory;
import com.microfocus.application.automation.tools.octane.model.processors.scm.SCMUtils;
import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerUtils;
import com.microfocus.application.automation.tools.settings.RunnerMiscSettingsGlobalConfiguration;
import hudson.ProxyConfiguration;
import hudson.console.PlainTextConsoleOutputStream;
import hudson.matrix.MatrixConfiguration;
import hudson.maven.MavenModule;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BooleanParameterValue;
import hudson.model.Cause;
import hudson.model.FileParameterDefinition;
import hudson.model.FileParameterValue;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.PasswordParameterValue;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.security.ACLContext;
import hudson.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.acegisecurity.AccessDeniedException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;

public class CIJenkinsServicesImpl
extends CIPluginServices {
    private static boolean skipOctaneAllowedStoragePrint = false;
    private static Object skipOctaneAllowedStoragePrintLock = new Object();
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();
    private static final org.apache.logging.log4j.Logger logger = SDKBasedLoggerProvider.getLogger(CIJenkinsServicesImpl.class);
    private static final Logger systemLogger = Logger.getLogger(CIJenkinsServicesImpl.class.getName());
    private static final String DEFAULT_BRANCHES_SEPARATOR = " ";

    public CIServerInfo getServerInfo() {
        return CIJenkinsServicesImpl.getJenkinsServerInfo();
    }

    public CIPluginInfo getPluginInfo() {
        CIPluginInfo result = (CIPluginInfo)dtoFactory.newDTO(CIPluginInfo.class);
        result.setVersion(ConfigurationService.getPluginVersion());
        return result;
    }

    public void suspendCIEvents(boolean suspend) {
        OctaneServerSettingsModel model = ConfigurationService.getSettings(this.getInstanceId());
        model.setSuspend(suspend);
        ConfigurationService.configurePlugin(model);
        logger.info("suspend ci event: " + suspend);
    }

    public File getAllowedOctaneStorage() {
        return CIJenkinsServicesImpl.getAllowedStorageFile();
    }

    public CIProxyConfiguration getProxyConfiguration(URL targetUrl) {
        return CIJenkinsServicesImpl.getProxySupplier(targetUrl);
    }

    public static CIProxyConfiguration getProxySupplier(URL targetUrl) {
        CIProxyConfiguration result = null;
        ProxyConfiguration proxy = Jenkins.get().proxy;
        if (proxy != null) {
            boolean noProxyHost = false;
            for (Pattern pattern : proxy.getNoProxyHostPatterns()) {
                if (!pattern.matcher(targetUrl.getHost()).matches()) continue;
                noProxyHost = true;
                break;
            }
            if (!noProxyHost) {
                result = ((CIProxyConfiguration)dtoFactory.newDTO(CIProxyConfiguration.class)).setHost(proxy.name).setPort(Integer.valueOf(proxy.port)).setUsername(proxy.getUserName()).setPassword(proxy.getPassword());
            }
        }
        return result;
    }

    public CIJobsList getJobsList(boolean includeParameters, Long workspaceId) {
        ACLContext securityContext = this.startImpersonation(workspaceId);
        CIJobsList result = (CIJobsList)dtoFactory.newDTO(CIJobsList.class);
        HashMap<String, PipelineNode> jobsMap = new HashMap<String, PipelineNode>();
        try {
            long start = System.currentTimeMillis();
            Collection jobNames = Jenkins.get().getJobNames();
            logger.debug("Get job names took {} ms", (Object)(System.currentTimeMillis() - start));
            Iterator iterator = jobNames.iterator();
            while (iterator.hasNext()) {
                String jobName;
                String tempJobName = jobName = (String)iterator.next();
                try {
                    PipelineNode tmpConfig;
                    long startProcessJob = System.currentTimeMillis();
                    Job tmpJob = (Job)Jenkins.get().getItemByFullName(tempJobName);
                    if (!CIJenkinsServicesImpl.isJobIsRelevantForPipelineModule(tmpJob)) continue;
                    if (tmpJob != null && "org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject".equals(tmpJob.getParent().getClass().getName())) {
                        tempJobName = tmpJob.getParent().getFullName();
                        WorkflowMultiBranchProject parentItem = (WorkflowMultiBranchProject)Jenkins.get().getItem(tempJobName);
                        if (parentItem != null && parentItem.isDisabled() || jobsMap.containsKey(tempJobName)) continue;
                        tmpConfig = this.createPipelineNodeFromJobName(tempJobName);
                    } else {
                        tmpConfig = this.createPipelineNode(tempJobName, tmpJob, includeParameters);
                    }
                    jobsMap.put(tempJobName, tmpConfig);
                    if (System.currentTimeMillis() - startProcessJob <= 2000L) continue;
                    logger.warn("Job {} took {} ms", (Object)tempJobName, (Object)(System.currentTimeMillis() - startProcessJob));
                }
                catch (Throwable e) {
                    logger.error("failed to add job '" + tempJobName + "' to JobList", e);
                }
            }
            logger.info("Get job list took {} ms", (Object)(System.currentTimeMillis() - start));
            if (jobsMap.isEmpty() && !Jenkins.get().hasPermission(Item.READ)) {
                String userName = ImpersonationUtil.getUserNameForImpersonation(this.getInstanceId(), workspaceId);
                if (StringUtils.isEmpty((String)userName)) {
                    userName = "anonymous";
                }
                String msg = String.format("User %s does not have READ permission", userName);
                throw new PermissionException(msg, 403);
            }
            result.setJobs(jobsMap.values().toArray(new PipelineNode[0]));
        }
        catch (AccessDeniedException ade) {
            throw new PermissionException(403);
        }
        finally {
            this.stopImpersonation(securityContext);
        }
        return result;
    }

    public static boolean isJobIsRelevantForPipelineModule(Job job) {
        return job != null && (!(job instanceof AbstractProject) || !((AbstractProject)job).isDisabled()) && !(job instanceof MatrixConfiguration) && !(job instanceof MavenModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PipelineNode getPipeline(String rootJobCiId) {
        ACLContext securityContext = this.startImpersonation();
        try {
            Item item = this.getItemByRefId(rootJobCiId);
            if (item == null) {
                logger.warn("Failed to get project from jobRefId: '" + rootJobCiId + "' check plugin user Job Read/Overall Read permissions / project name");
                throw new ConfigurationException(404);
            }
            if (!Jenkins.get().hasPermission(Item.READ) && !item.hasPermission(Item.READ)) {
                logger.warn("Insufficient permissions to access jobRefId: '{}'.", (Object)rootJobCiId);
                throw new PermissionException(403);
            }
            if (item instanceof Job) {
                PipelineNode pipelineNode = ModelFactory.createStructureItem((Job)item);
                return pipelineNode;
            }
            PipelineNode result = this.createPipelineNodeFromJobName(item.getFullName());
            if (item.getClass().getName().equals("org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject")) {
                WorkflowMultiBranchProject parentItem = (WorkflowMultiBranchProject)item;
                if (!parentItem.isDisabled()) {
                    this.addParametersAndDefaultBranchFromConfig(item, result);
                    result.setMultiBranchType(MultiBranchType.MULTI_BRANCH_PARENT);
                } else {
                    result = null;
                }
            }
            PipelineNode pipelineNode = result;
            return pipelineNode;
        }
        finally {
            this.stopImpersonation(securityContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runPipeline(String jobCiId, CIParameters ciParameters) {
        block7: {
            ACLContext securityContext = this.startImpersonation();
            try {
                Job job = this.getJobByRefId(jobCiId);
                if (job != null) {
                    if (job instanceof AbstractProject && ((AbstractProject)job).isDisabled()) {
                        throw new ConfigurationException(404);
                    }
                    boolean hasBuildPermission = job.hasPermission(Item.BUILD);
                    if (!hasBuildPermission) {
                        this.stopImpersonation(securityContext);
                        throw new PermissionException(403);
                    }
                    if (job instanceof AbstractProject || job.getClass().getName().equals("org.jenkinsci.plugins.workflow.job.WorkflowJob")) {
                        this.doRunImpl(job, ciParameters);
                    }
                    break block7;
                }
                throw new ConfigurationException(404);
            }
            finally {
                this.stopImpersonation(securityContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPipelineRun(String jobCiId, CIParameters ciParameters) {
        block6: {
            ACLContext securityContext = this.startImpersonation();
            try {
                Job job = this.getJobByRefId(jobCiId);
                if (job != null) {
                    boolean hasAbortPermissions = job.hasPermission(Item.CANCEL);
                    if (!hasAbortPermissions) {
                        this.stopImpersonation(securityContext);
                        throw new PermissionException(403);
                    }
                    if (job instanceof AbstractProject || job.getClass().getName().equals("org.jenkinsci.plugins.workflow.job.WorkflowJob")) {
                        this.doStopImpl(job, ciParameters);
                    }
                    break block6;
                }
                throw new ConfigurationException(404);
            }
            finally {
                this.stopImpersonation(securityContext);
            }
        }
    }

    public CIBranchesList getBranchesList(String jobCiId, String filterBranchName) {
        ACLContext securityContext = this.startImpersonation();
        List<Object> result = new ArrayList();
        try {
            Item item = Jenkins.get().getItemByFullName(jobCiId);
            if (item != null) {
                boolean hasRead = Jenkins.get().hasPermission(Item.READ);
                if (!hasRead) {
                    throw new PermissionException("Missing READ permission to job " + jobCiId, 403);
                }
                if (item.getClass().getName().equals("org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject")) {
                    result = this.doGetListOfBranchesImpl(item, filterBranchName);
                }
                CIBranchesList cIBranchesList = ((CIBranchesList)dtoFactory.newDTO(CIBranchesList.class)).setBranches(result);
                return cIBranchesList;
            }
            throw new ConfigurationException(404);
        }
        finally {
            this.stopImpersonation(securityContext);
        }
    }

    private List<Branch> doGetListOfBranchesImpl(Item item, String filterBranchName) {
        Collection allJobs = item.getAllJobs();
        return allJobs.stream().filter(job -> this.getDisplayNameFromJob((Job)job).equals(filterBranchName)).map(job -> ((Branch)dtoFactory.newDTO(Branch.class)).setName(job.getDisplayName()).setInternalId(job.getName())).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIBuildStatusInfo getJobBuildStatus(String jobCiId, String parameterName, String parameterValue) {
        ACLContext securityContext = this.startImpersonation();
        try {
            Job job = this.getJobByRefId(jobCiId);
            boolean hasRead = Jenkins.get().hasPermission(Item.READ);
            if (!hasRead) {
                throw new PermissionException("Missing READ permission to job " + jobCiId, 403);
            }
            if (job == null) {
                CIBuildStatusInfo cIBuildStatusInfo = this.getUnavailableJobStatus(jobCiId, parameterName, parameterValue);
                return cIBuildStatusInfo;
            }
            AbstractProjectProcessor<Job> jobProcessor = JobProcessorFactory.getFlowProcessor(job);
            CIBuildStatusInfo cIBuildStatusInfo = jobProcessor.getBuildStatus(parameterName, parameterValue);
            return cIBuildStatusInfo;
        }
        finally {
            this.stopImpersonation(securityContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getTestsResult(String jobId, String buildId) {
        ACLContext originalContext = this.startImpersonation();
        try {
            FileInputStream result = null;
            Run run = this.getRunByRefNames(jobId, buildId);
            if (run != null) {
                try {
                    result = new FileInputStream(String.valueOf(run.getRootDir()) + File.separator + "mqmTests.xml");
                }
                catch (Exception fnfe) {
                    logger.error("'mqmTests.xml' file no longer exists, test results of '" + jobId + " #" + buildId + "' won't be pushed to Octane", (Throwable)fnfe);
                }
                this.tryRemoveTempTestResultFile(run);
            } else {
                logger.error("build '" + jobId + " #" + buildId + "' not found");
            }
            FileInputStream fileInputStream = result;
            return fileInputStream;
        }
        finally {
            this.stopImpersonation(originalContext);
        }
    }

    private void tryRemoveTempTestResultFile(Run run) {
        try {
            File[] matches = run.getRootDir().listFiles((dir, name) -> name.startsWith("GetJUnitTestResults"));
            if (matches != null) {
                for (File f : matches) {
                    try {
                        Files.deleteIfExists(f.toPath());
                    }
                    catch (Exception e) {
                        logger.error("Failed to delete the temp test result file at '" + f.getPath() + "'", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Fail to tryRemoveTempTestResultFile : " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBuildLog(String jobId, String buildId) {
        ACLContext originalContext = this.startImpersonation();
        try {
            InputStream result = null;
            Run run = this.getRunByRefNames(jobId, buildId);
            if (run != null) {
                result = this.getOctaneLogFile(run);
            } else {
                logger.error("build '" + jobId + " #" + buildId + "' not found");
            }
            InputStream inputStream = result;
            return inputStream;
        }
        finally {
            this.stopImpersonation(originalContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getCoverageReport(String jobId, String buildId, String reportFileName) {
        ACLContext originalContext = this.startImpersonation();
        try {
            FileInputStream result = null;
            Run run = this.getRunByRefNames(jobId, buildId);
            if (run != null) {
                File coverageReport = new File(run.getRootDir(), reportFileName);
                if (coverageReport.exists()) {
                    try {
                        result = new FileInputStream(coverageReport);
                    }
                    catch (FileNotFoundException fnfe) {
                        logger.warn("file not found for '" + reportFileName + "' although just verified its existence, concurrency?");
                    }
                }
            } else {
                logger.error("build '" + jobId + " #" + buildId + "' not found");
            }
            FileInputStream fileInputStream = result;
            return fileInputStream;
        }
        finally {
            this.stopImpersonation(originalContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getSCMData(String jobId, String buildId) {
        ACLContext originalContext = this.startImpersonation();
        InputStream result = null;
        try {
            Run run = this.getRunByRefNames(jobId, buildId);
            if (run != null) {
                result = SCMUtils.getSCMData(run);
            } else {
                logger.error("build '" + jobId + " #" + buildId + "' not found");
            }
        }
        catch (IOException | InterruptedException e) {
            logger.error("Failed to load SCMData for jobId " + jobId + " buildId " + buildId, (Throwable)e);
        }
        finally {
            this.stopImpersonation(originalContext);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSCProjectConfiguration getSSCProjectConfiguration(String jobId, String buildId) {
        ACLContext originalContext = this.startImpersonation();
        try {
            SSCProjectConfiguration result = null;
            Run run = this.getRunByRefNames(jobId, buildId);
            SSCServerConfigUtil.SSCProjectVersionPair projectVersionPair = null;
            if (run instanceof AbstractBuild) {
                projectVersionPair = SSCServerConfigUtil.getProjectConfigurationFromBuild((AbstractBuild)run);
            } else if (run instanceof WorkflowRun) {
                projectVersionPair = SSCServerConfigUtil.getProjectConfigurationFromWorkflowRun((WorkflowRun)run);
            } else {
                logger.error("build '" + jobId + " #" + buildId + "' (of specific type AbstractBuild or WorkflowRun) not found");
                SSCProjectConfiguration sSCProjectConfiguration = result;
                return sSCProjectConfiguration;
            }
            String sscServerUrl = SSCServerConfigUtil.getSSCServer();
            String sscAuthToken = this.getFortifySSCToken();
            if (sscServerUrl != null && !sscServerUrl.isEmpty() && projectVersionPair != null) {
                result = ((SSCProjectConfiguration)dtoFactory.newDTO(SSCProjectConfiguration.class)).setSSCUrl(sscServerUrl).setSSCBaseAuthToken(sscAuthToken).setProjectName(projectVersionPair.project).setProjectVersion(projectVersionPair.version);
            }
            SSCProjectConfiguration sSCProjectConfiguration = result;
            return sSCProjectConfiguration;
        }
        finally {
            this.stopImpersonation(originalContext);
        }
    }

    private String getFortifySSCToken() {
        OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)this.getInstanceId());
        FortifySSCTokenParameter parameter = (FortifySSCTokenParameter)octaneClient.getConfigurationService().getConfiguration().getParameter("FORTIFY_SSC_TOKEN");
        if (parameter != null) {
            return parameter.getToken();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getFodRelease(String jobId, String buildId) {
        ACLContext originalContext = this.startImpersonation();
        try {
            Run run = this.getRunByRefNames(jobId, buildId);
            if (run instanceof AbstractBuild) {
                Long l = FodConfigUtil.getFODReleaseFromBuild((AbstractBuild)run);
                return l;
            }
            logger.error("build '" + jobId + " #" + buildId + "' (of specific type AbstractBuild) not found");
            Long l = null;
            return l;
        }
        finally {
            this.stopImpersonation(originalContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FodServerConfiguration getFodServerConfiguration() {
        ACLContext originalContext = this.startImpersonation();
        try {
            FodConfigUtil.ServerConnectConfig fodServerConfig = FodConfigUtil.getFODServerConfig();
            if (fodServerConfig != null) {
                FodServerConfiguration fodServerConfiguration = ((FodServerConfiguration)dtoFactory.newDTO(FodServerConfiguration.class)).setClientId(fodServerConfig.clientId).setClientSecret(fodServerConfig.clientSecret).setApiUrl(fodServerConfig.apiUrl).setBaseUrl(fodServerConfig.baseUrl);
                return fodServerConfiguration;
            }
            FodServerConfiguration fodServerConfiguration = null;
            return fodServerConfiguration;
        }
        finally {
            this.stopImpersonation(originalContext);
        }
    }

    public void runTestDiscovery(DiscoveryInfo discoveryInfo) {
        ACLContext securityContext = this.startImpersonation();
        try {
            TestExecutionJobCreatorService.runTestDiscovery(discoveryInfo);
        }
        finally {
            this.stopImpersonation(securityContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PipelineNode createExecutor(DiscoveryInfo discoveryInfo) {
        if ("uft_test_runner".equals(discoveryInfo.getExecutorType())) {
            ACLContext securityContext = this.startImpersonation();
            try {
                FreeStyleProject project = TestExecutionJobCreatorService.createExecutor(discoveryInfo);
                PipelineNode pipelineNode = ModelFactory.createStructureItem((Job)project);
                return pipelineNode;
            }
            finally {
                this.stopImpersonation(securityContext);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OctaneResponse checkRepositoryConnectivity(TestConnectivityInfo testConnectivityInfo) {
        ACLContext securityContext = this.startImpersonation();
        try {
            UftTestRunnerFolderParameter uftFolderParameter;
            OctaneResponse response;
            OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)this.getInstanceId());
            if (ConfigurationParameterFactory.isUftTestConnectionDisabled((OctaneConfiguration)octaneClient.getConfigurationService().getConfiguration())) {
                logger.info("checkRepositoryConnectivity : validation disabled");
                response = ((OctaneResponse)DTOFactory.getInstance().newDTO(OctaneResponse.class)).setStatus(200);
            } else {
                response = ExecutorConnectivityService.checkRepositoryConnectivity(testConnectivityInfo);
            }
            if (response.getStatus() == 200 && (uftFolderParameter = (UftTestRunnerFolderParameter)octaneClient.getConfigurationService().getConfiguration().getParameter("UFT_TEST_RUNNER_FOLDER")) != null) {
                ArrayList<String> errors = new ArrayList<String>();
                ConfigurationValidator.checkUftFolderParameter(uftFolderParameter, errors);
                if (!errors.isEmpty()) {
                    response.setStatus(400);
                    response.setBody((String)errors.get(0));
                }
            }
            OctaneResponse octaneResponse = response;
            return octaneResponse;
        }
        finally {
            this.stopImpersonation(securityContext);
        }
    }

    public void deleteExecutor(String id) {
        ACLContext securityContext = this.startImpersonation();
        try {
            UftJobRecognizer.deleteDiscoveryJobByExecutor(id);
            UftJobRecognizer.deleteExecutionJobByExecutorIfNeverExecuted(id);
        }
        finally {
            this.stopImpersonation(securityContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OctaneResponse upsertCredentials(CredentialsInfo credentialsInfo) {
        ACLContext securityContext = this.startImpersonation();
        try {
            OctaneResponse octaneResponse = ExecutorConnectivityService.upsertRepositoryCredentials(credentialsInfo);
            return octaneResponse;
        }
        finally {
            this.stopImpersonation(securityContext);
        }
    }

    public List<CredentialsInfo> getCredentials() {
        List list = CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)null, null, (DomainRequirement[])new DomainRequirement[]{null});
        List<CredentialsInfo> output = list.stream().map(c -> ((CredentialsInfo)dtoFactory.newDTO(CredentialsInfo.class)).setCredentialsId(c.getId()).setUsername(CredentialsNameProvider.name((Credentials)c))).collect(Collectors.toList());
        return output;
    }

    private ACLContext startImpersonation() {
        return this.startImpersonation(null);
    }

    private ACLContext startImpersonation(Long workspaceId) {
        return ImpersonationUtil.startImpersonation(this.getInstanceId(), workspaceId);
    }

    private void stopImpersonation(ACLContext impersonatedContext) {
        ImpersonationUtil.stopImpersonation(impersonatedContext);
    }

    private PipelineNode createPipelineNode(String name, Job job, boolean includeParameters) {
        PipelineNode tmpConfig = ((PipelineNode)dtoFactory.newDTO(PipelineNode.class)).setJobCiId(JobProcessorFactory.getFlowProcessor(job).getTranslatedJobName()).setName(name);
        if (includeParameters) {
            tmpConfig.setParameters(ParameterProcessors.getConfigs(job));
            if (tmpConfig.getParameters() != null) {
                Optional<CIParameter> opt = tmpConfig.getParameters().stream().filter(p -> "testsToRun".equals(p.getName())).findFirst();
                tmpConfig.setIsTestRunner(Boolean.valueOf(opt.isPresent()));
            }
            if (job instanceof AbstractProject) {
                List upstreams = Jenkins.get().getDependencyGraph().getUpstream((AbstractProject)job);
                tmpConfig.setHasUpstream(Boolean.valueOf(upstreams.size() > 0));
            }
        }
        return tmpConfig;
    }

    private PipelineNode createPipelineNodeFromJobName(String name) {
        return ((PipelineNode)dtoFactory.newDTO(PipelineNode.class)).setJobCiId(BuildHandlerUtils.translateFolderJobName(name)).setName(name);
    }

    private CIBuildStatusInfo getUnavailableJobStatus(String ciJobId, String paramName, String paramValue) {
        return ((CIBuildStatusInfo)DTOFactory.getInstance().newDTO(CIBuildStatusInfo.class)).setBuildStatus(CIBuildStatus.UNAVAILABLE).setJobCiId(ciJobId).setParamName(paramName).setParamValue(paramValue).setResult(CIBuildResult.UNAVAILABLE);
    }

    private void addParametersAndDefaultBranchFromConfig(Item item, PipelineNode result) {
        String defaultBranchesConfig;
        String string = defaultBranchesConfig = RunnerMiscSettingsGlobalConfiguration.getInstance() != null ? RunnerMiscSettingsGlobalConfiguration.getInstance().getDefaultBranches() : null;
        if (defaultBranchesConfig != null && !defaultBranchesConfig.isEmpty()) {
            String[] defaultBranchesArray = defaultBranchesConfig.split(DEFAULT_BRANCHES_SEPARATOR);
            Set defaultBranches = Arrays.stream(defaultBranchesArray).map(String::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
            Collection allJobs = item.getAllJobs();
            Job job = allJobs.stream().filter(tempJob -> defaultBranches.contains(this.getDisplayNameFromJob((Job)tempJob))).findFirst().orElse(null);
            if (job != null) {
                String defaultBranch = this.getDisplayNameFromJob(job);
                result.setParameters(ParameterProcessors.getConfigs(job)).setDefaultBranchName(defaultBranch);
            }
        }
    }

    private String getDisplayNameFromJob(Job tempJob) {
        return tempJob.getDisplayName() != null ? tempJob.getDisplayName() : tempJob.getName();
    }

    private InputStream getOctaneLogFile(Run run) {
        FileInputStream result = null;
        String octaneLogFilePath = String.valueOf(run.getRootDir()) + File.separator + "octane_log";
        File logFile = new File(octaneLogFilePath);
        if (!logFile.exists()) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(logFile);
                 InputStream logStream = run.getLogInputStream();
                 PlainTextConsoleOutputStream out = new PlainTextConsoleOutputStream((OutputStream)fileOutputStream);){
                IOUtils.copy((InputStream)logStream, (OutputStream)out);
                out.flush();
            }
            catch (IOException ioe) {
                logger.error("failed to transfer native log to Octane's one for " + String.valueOf(run));
            }
        }
        try {
            result = new FileInputStream(octaneLogFilePath);
        }
        catch (IOException ioe) {
            logger.error("failed to obtain log for " + String.valueOf(run));
        }
        return result;
    }

    private Run getRunByRefNames(String jobId, String buildId) {
        Run result = null;
        Job project = this.getJobByRefId(jobId);
        if (project != null) {
            result = project.getBuildByNumber(Integer.parseInt(buildId));
        }
        return result;
    }

    private void doRunImpl(Job job, CIParameters ciParameters) {
        AbstractProjectProcessor<Job> jobProcessor = JobProcessorFactory.getFlowProcessor(job);
        this.doRunStopImpl(jobProcessor::scheduleBuild, "execution", job, ciParameters);
    }

    private void doStopImpl(Job job, CIParameters ciParameters) {
        AbstractProjectProcessor<Job> jobProcessor = JobProcessorFactory.getFlowProcessor(job);
        this.doRunStopImpl(jobProcessor::cancelBuild, "stop", job, ciParameters);
    }

    private void doRunStopImpl(BiConsumer<Cause, ParametersAction> method, String methodName, Job job, CIParameters ciParameters) {
        ParametersAction parametersAction = new ParametersAction(new ParameterValue[0]);
        if (ciParameters != null) {
            parametersAction = new ParametersAction(CIJenkinsServicesImpl.createParameters(job, ciParameters));
        }
        Cause.RemoteCause cause = new Cause.RemoteCause(ConfigurationService.getSettings(this.getInstanceId()) == null ? "non available URL" : ConfigurationService.getSettings(this.getInstanceId()).getLocation(), "octane driven " + methodName);
        method.accept((Cause)cause, parametersAction);
    }

    public static List<ParameterValue> createParameters(Job project, CIParameters ciParameters) {
        StringParameterValue tmpValue;
        ArrayList<ParameterValue> result = new ArrayList<ParameterValue>();
        ParametersDefinitionProperty paramsDefProperty = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
        if (paramsDefProperty == null) {
            paramsDefProperty = new ParametersDefinitionProperty(new ParameterDefinition[0]);
        }
        Map ciParametersMap = ciParameters.getParameters().stream().collect(Collectors.toMap(CIParameter::getName, Function.identity()));
        for (ParameterDefinition paramDef : paramsDefProperty.getParameterDefinitions()) {
            boolean parameterHandled = false;
            CIParameter ciParameter = (CIParameter)ciParametersMap.remove(paramDef.getName());
            if (ciParameter != null) {
                tmpValue = null;
                switch (ciParameter.getType()) {
                    case NUMBER: 
                    case STRING: {
                        tmpValue = new StringParameterValue(ciParameter.getName(), ciParameter.getValue().toString());
                        break;
                    }
                    case BOOLEAN: {
                        tmpValue = new BooleanParameterValue(ciParameter.getName(), Boolean.parseBoolean(ciParameter.getValue().toString()));
                        break;
                    }
                    case PASSWORD: {
                        tmpValue = new PasswordParameterValue(ciParameter.getName(), ciParameter.getValue().toString());
                        break;
                    }
                }
                if (tmpValue != null) {
                    result.add((ParameterValue)tmpValue);
                    parameterHandled = true;
                }
            }
            if (parameterHandled) continue;
            if (paramDef instanceof FileParameterDefinition) {
                File file = new File("");
                try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                    outputStream.write(new byte[0]);
                }
                catch (IOException ioe) {
                    logger.error("failed to create default value for file parameter '" + paramDef.getName() + "'", (Throwable)ioe);
                }
                tmpValue = new FileParameterValue(paramDef.getName(), file, file.getName());
                result.add((ParameterValue)tmpValue);
                continue;
            }
            result.add(paramDef.getDefaultParameterValue());
        }
        for (CIParameter notDefinedParameter : ciParametersMap.values()) {
            tmpValue = new StringParameterValue(notDefinedParameter.getName(), notDefinedParameter.getValue().toString());
            result.add((ParameterValue)tmpValue);
        }
        return result;
    }

    private Job getJobByRefId(String jobName) {
        Item item = this.getItemByRefId(jobName);
        return item instanceof Job ? (Job)item : null;
    }

    private Item getItemByRefId(String jobName) {
        String notDuplicatedParentPrefix2;
        String parentPrefix;
        String notDuplicatedParentPrefix1;
        int jobNameIndex;
        String myJobName = BuildHandlerUtils.revertTranslateFolderJobName(jobName);
        Item item = Jenkins.get().getItemByFullName(myJobName);
        if (item == null && (jobNameIndex = myJobName.lastIndexOf(47)) > 0 && StringUtils.equals((String)(notDuplicatedParentPrefix1 = myJobName.substring(0, (parentPrefix = myJobName.substring(0, jobNameIndex)).length() / 2)), (String)(notDuplicatedParentPrefix2 = myJobName.substring(parentPrefix.length() / 2 + 1, jobNameIndex)))) {
            String alternativeJobName = notDuplicatedParentPrefix1 + myJobName.substring(jobNameIndex);
            item = Jenkins.get().getItemByFullName(alternativeJobName);
        }
        return item;
    }

    public static File getAllowedStorageFile() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        File folder = jenkins != null ? CIJenkinsServicesImpl.getAllowedStorageFileForMasterJenkins(jenkins) : new File("octanePluginContent");
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getAllowedStorageFileForMasterJenkins(Jenkins jenkins) {
        File folder;
        boolean allowPrint;
        Object object = skipOctaneAllowedStoragePrintLock;
        synchronized (object) {
            allowPrint = !skipOctaneAllowedStoragePrint;
            skipOctaneAllowedStoragePrint = true;
        }
        String prop = System.getProperty("octaneAllowedStorage");
        if (StringUtils.isNotEmpty((String)prop)) {
            folder = new File(prop);
            if (!folder.isAbsolute()) {
                folder = new File(jenkins.getRootDir(), prop);
            }
            if (allowPrint) {
                systemLogger.info("octaneAllowedStorage : " + folder.getAbsolutePath());
                if (!folder.exists() && !folder.mkdirs()) {
                    systemLogger.warning("Failed to create octaneAllowedStorage : " + folder.getAbsolutePath() + ". Create this folder and restart Jenkins.");
                }
            }
        } else {
            folder = new File(jenkins.getRootDir(), "userContent");
        }
        return folder;
    }

    public static CIServerInfo getJenkinsServerInfo() {
        CIServerInfo result = (CIServerInfo)dtoFactory.newDTO(CIServerInfo.class);
        String serverUrl = Jenkins.get().getRootUrl();
        if (serverUrl != null && serverUrl.endsWith("/")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
        }
        result.setType(CIServerTypes.JENKINS.value()).setVersion(Jenkins.VERSION).setUrl(serverUrl).setSendingTime(Long.valueOf(System.currentTimeMillis()));
        return result;
    }

    public static void publishEventToRelevantClients(CIEvent event) {
        OctaneSDK.getClients().forEach(c -> c.getEventsService().publishEvent(event));
    }

    public String getParentJobName(String jobId) {
        if (jobId != null && jobId.contains("/job/")) {
            int index = jobId.lastIndexOf("/job/");
            String parent = jobId.substring(0, index);
            return parent;
        }
        return null;
    }
}

