/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane;

import com.microfocus.application.automation.tools.octane.ResultQueue;
import com.squareup.tape.FileObjectQueue;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.io.IOUtils;

public abstract class AbstractResultQueueImpl
implements ResultQueue {
    private static final int RETRIES = 3;
    private final int MAX_RETRIES;
    private FileObjectQueue<ResultQueue.QueueItem> queue;
    private ResultQueue.QueueItem currentItem;

    public AbstractResultQueueImpl() {
        this.MAX_RETRIES = 3;
    }

    public AbstractResultQueueImpl(int maxRetries) {
        this.MAX_RETRIES = maxRetries;
    }

    protected void init(File queueFile) throws IOException {
        this.queue = new FileObjectQueue(queueFile, (FileObjectQueue.Converter)new JsonConverter());
    }

    @Override
    public synchronized ResultQueue.QueueItem peekFirst() {
        if (this.currentItem == null) {
            this.currentItem = (ResultQueue.QueueItem)this.queue.peek();
        }
        return this.currentItem;
    }

    @Override
    public synchronized boolean failed() {
        if (this.currentItem != null) {
            boolean retry;
            if (++this.currentItem.failCount <= this.MAX_RETRIES) {
                this.queue.add((Object)this.currentItem);
                retry = true;
            } else {
                retry = false;
            }
            this.remove();
            return retry;
        }
        throw new IllegalStateException("no outstanding item");
    }

    @Override
    public synchronized void remove() {
        if (this.currentItem == null) {
            throw new IllegalStateException("no outstanding item");
        }
        this.queue.remove();
        this.currentItem = null;
    }

    @Override
    public synchronized void add(ResultQueue.QueueItem item) {
        this.queue.add((Object)item);
    }

    @Override
    public synchronized void add(String projectName, int buildNumber) {
        this.queue.add((Object)new ResultQueue.QueueItem(projectName, buildNumber));
    }

    @Override
    public synchronized void add(String projectName, String type, int buildNumber) {
        this.queue.add((Object)new ResultQueue.QueueItem(projectName, type, buildNumber));
    }

    @Override
    public synchronized void add(String projectName, int buildNumber, String workspace) {
        this.queue.add((Object)new ResultQueue.QueueItem(projectName, buildNumber, workspace));
    }

    @Override
    public synchronized void add(String instanceId, String projectName, int buildNumber, String workspace) {
        ResultQueue.QueueItem item = new ResultQueue.QueueItem(projectName, buildNumber, workspace);
        item.setInstanceId(instanceId);
        this.queue.add((Object)item);
    }

    public int size() {
        return this.queue.size();
    }

    @Override
    public synchronized void clear() {
        while (this.queue.size() > 0) {
            this.queue.remove();
        }
        this.currentItem = null;
    }

    @Override
    public void close() {
        if (this.queue != null) {
            this.queue.close();
        }
    }

    private static class JsonConverter
    implements FileObjectQueue.Converter<ResultQueue.QueueItem> {
        public static final String INSTANCE_ID = "instanceId";

        private JsonConverter() {
        }

        public ResultQueue.QueueItem from(byte[] bytes) throws IOException {
            JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)IOUtils.toString((InputStream)new ByteArrayInputStream(bytes)));
            return JsonConverter.objectFromJson(json);
        }

        public void toStream(ResultQueue.QueueItem item, OutputStream bytes) throws IOException {
            JSONObject json = JsonConverter.jsonFromObject(item);
            OutputStreamWriter writer = new OutputStreamWriter(bytes);
            writer.append(json.toString());
            writer.close();
        }

        private static ResultQueue.QueueItem objectFromJson(JSONObject json) {
            ResultQueue.QueueItem queueItem;
            ResultQueue.QueueItem queueItem2 = queueItem = json.containsKey((Object)"workspace") ? new ResultQueue.QueueItem(json.getString("project"), json.getInt("build"), json.getInt("count"), json.getString("workspace")) : new ResultQueue.QueueItem(json.getString("project"), json.getInt("build"), json.getInt("count"));
            if (json.containsKey((Object)"type")) {
                queueItem.setType(json.getString("type"));
            }
            if (json.containsKey((Object)"sendAfter")) {
                queueItem.setSendAfter(json.getLong("sendAfter"));
            }
            if (json.containsKey((Object)INSTANCE_ID)) {
                queueItem.setInstanceId(json.getString(INSTANCE_ID));
            }
            return queueItem;
        }

        private static JSONObject jsonFromObject(ResultQueue.QueueItem item) {
            JSONObject json = new JSONObject();
            json.put("project", (Object)item.projectName);
            json.put("build", (Object)item.buildNumber);
            json.put("count", (Object)item.failCount);
            json.put("workspace", (Object)item.workspace);
            json.put("type", (Object)item.type);
            json.put("sendAfter", (Object)item.sendAfter);
            json.put(INSTANCE_ID, (Object)item.instanceId);
            return json;
        }
    }
}

