/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.nodes;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Node;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.util.Secret;
import org.kohsuke.stapler.DataBoundConstructor;

@Extension
public class EncryptionNodeProperty
extends NodeProperty<Node> {
    private Secret publicKey;

    @DataBoundConstructor
    public EncryptionNodeProperty() {
    }

    @CheckForNull
    public String getPublicKey() {
        if (this.publicKey == null) {
            return null;
        }
        return this.publicKey.getEncryptedValue();
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = Secret.fromString((String)publicKey);
    }

    @Extension
    public static class DescriptorImpl
    extends NodePropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Encryption for Functional Testing sensitive data";
        }

        public boolean isApplicableAsGlobal() {
            return false;
        }
    }
}

