/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.model;

import com.microfocus.application.automation.tools.model.EnumDescription;
import hudson.EnvVars;
import hudson.Util;
import hudson.util.Secret;
import hudson.util.VariableResolver;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class UploadTestResultToAlmModel {
    public static final int DEFAULT_TIMEOUT = 36000;
    public static final String ALM_PASSWORD_KEY = "almPassword";
    public static final EnumDescription testingFrameworkJunit = new EnumDescription("JUnit", "JUnit");
    public static final EnumDescription testingFrameworkTestNG = new EnumDescription("TestNG", "TestNG");
    public static final EnumDescription testingFrameworkNUnit = new EnumDescription("NUnit", "NUnit");
    public static final List<EnumDescription> testingFrameworks = Arrays.asList(testingFrameworkJunit, testingFrameworkTestNG, testingFrameworkNUnit);
    private String almServerName;
    private String almUserName;
    private Secret almPassword;
    private String almDomain;
    private String clientType;
    private String almProject;
    private String almTimeout;
    private String almTestFolder;
    private String almTestSetFolder;
    private String testingFramework;
    private String testingTool;
    private String testingResultFile;
    private String testingAttachments;
    private String jenkinsServerUrl;

    @DataBoundConstructor
    public UploadTestResultToAlmModel(String almServerName, String almUserName, String almPassword, String almDomain, String clientType, String almProject, String testingFramework, String testingTool, String almTestFolder, String almTestSetFolder, String almTimeout, String testingResultFile, String testingAttachments, String jenkinsServerUrl) {
        this.almServerName = almServerName;
        this.almUserName = almUserName;
        this.almPassword = Secret.fromString((String)almPassword);
        this.almDomain = almDomain;
        this.clientType = clientType;
        this.almProject = almProject;
        this.almTimeout = almTimeout;
        this.almTestFolder = almTestFolder;
        this.almTestSetFolder = almTestSetFolder;
        this.testingFramework = testingFramework;
        this.testingTool = testingTool;
        this.testingResultFile = testingResultFile;
        this.testingAttachments = testingAttachments;
        this.jenkinsServerUrl = jenkinsServerUrl;
    }

    public String getAlmUserName() {
        return this.almUserName;
    }

    public String getAlmDomain() {
        return this.almDomain;
    }

    public String getClientType() {
        return this.clientType;
    }

    public String getAlmPassword() {
        return this.almPassword.getPlainText();
    }

    public String getAlmProject() {
        return this.almProject;
    }

    public String getTestingFramework() {
        return this.testingFramework;
    }

    public String getTestingTool() {
        return this.testingTool;
    }

    public String getAlmTimeout() {
        return this.almTimeout;
    }

    public String getAlmTestFolder() {
        return this.almTestFolder;
    }

    public String getAlmTestSetFolder() {
        return this.almTestSetFolder;
    }

    public String getAlmServerName() {
        return this.almServerName;
    }

    public String getTestingResultFile() {
        return this.testingResultFile;
    }

    public String getTestingAttachments() {
        return this.testingAttachments;
    }

    public String getJenkinsServerUrl() {
        return this.jenkinsServerUrl;
    }

    public Properties getProperties(EnvVars envVars, VariableResolver<String> varResolver) {
        return this.CreateProperties(envVars, varResolver);
    }

    public Properties getProperties() {
        return this.CreateProperties(null, null);
    }

    private Properties CreateProperties(EnvVars envVars, VariableResolver<String> varResolver) {
        Properties props = new Properties();
        if (envVars == null) {
            props.put("almUserName", this.almUserName);
            props.put(ALM_PASSWORD_KEY, this.almPassword);
            props.put("almDomain", this.almDomain);
            props.put("almProject", this.almProject);
        } else {
            props.put("almUserName", Util.replaceMacro((String)envVars.expand(this.almUserName), varResolver));
            props.put(ALM_PASSWORD_KEY, this.almPassword);
            props.put("almDomain", Util.replaceMacro((String)envVars.expand(this.almDomain), varResolver));
            props.put("almProject", Util.replaceMacro((String)envVars.expand(this.almProject), varResolver));
        }
        if (!StringUtils.isEmpty((String)this.testingFramework)) {
            props.put("testingFramework", this.testingFramework);
        } else {
            props.put("testingFramework", "");
        }
        if (!StringUtils.isEmpty((String)this.testingTool)) {
            props.put("testingTool", this.testingTool);
        } else {
            props.put("testingTool", "");
        }
        if (!StringUtils.isEmpty((String)this.almTestFolder)) {
            props.put("almTestFolder", this.almTestFolder);
        } else {
            props.put("almTestFolder", "");
        }
        if (!StringUtils.isEmpty((String)this.almTestSetFolder)) {
            props.put("almTestSetFolder", this.almTestSetFolder);
        } else {
            props.put("almTestSetFolder", "");
        }
        if (StringUtils.isEmpty((String)this.almTimeout)) {
            props.put("almTimeout", "-1");
        } else {
            props.put("almTimeout", this.almTimeout);
        }
        if (!StringUtils.isEmpty((String)this.testingResultFile)) {
            props.put("testingResultFile", this.testingResultFile);
        } else {
            props.put("testingResultFile", "");
        }
        if (!StringUtils.isEmpty((String)this.testingAttachments)) {
            props.put("testingAttachments", this.testingAttachments);
        } else {
            props.put("testingAttachments", "");
        }
        if (!StringUtils.isEmpty((String)this.jenkinsServerUrl)) {
            props.put("jenkinsServerUrl", this.jenkinsServerUrl);
        } else {
            props.put("jenkinsServerUrl", "");
        }
        return props;
    }

    public String toString() {
        return this.almServerName + "," + this.almUserName + "," + String.valueOf(this.almPassword) + "," + this.almDomain + "," + this.clientType + "," + this.almProject + "," + this.almTimeout + "," + this.almTestFolder + "," + this.almTestSetFolder + "," + this.testingFramework + "," + this.testingTool + "," + this.testingResultFile + "," + this.jenkinsServerUrl;
    }
}

