/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.model;

import com.microfocus.application.automation.tools.model.AuthModel;
import com.microfocus.application.automation.tools.model.ProxySettings;
import com.microfocus.application.automation.tools.model.UploadAppPathModel;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class UploadAppModel {
    private String mcServerName;
    private AuthModel authModel;
    private ProxySettings proxySettings;
    private List<UploadAppPathModel> applicationPaths;

    @DataBoundConstructor
    public UploadAppModel(String mcServerName, AuthModel authModel, ProxySettings proxySettings, List<UploadAppPathModel> applicationPaths) {
        this.mcServerName = mcServerName;
        this.authModel = authModel;
        this.proxySettings = proxySettings;
        this.applicationPaths = applicationPaths;
    }

    public String getMcServerName() {
        return this.mcServerName;
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public boolean isUseProxy() {
        return this.proxySettings != null;
    }

    public boolean isUseAuthentication() {
        return this.proxySettings != null && StringUtils.isNotBlank((String)this.proxySettings.getFsProxyUserName());
    }

    public List<UploadAppPathModel> getApplicationPaths() {
        return this.applicationPaths;
    }

    public AuthModel getAuthModel() {
        return this.authModel;
    }

    public String getAuthType() {
        return this.authModel == null ? "base" : this.authModel.getValue();
    }
}

