/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.model;

import com.microfocus.application.automation.tools.EncryptionUtils;
import com.microfocus.application.automation.tools.mc.JobConfigurationProxy;
import com.microfocus.application.automation.tools.model.AuthModel;
import com.microfocus.application.automation.tools.model.CloudBrowserModel;
import com.microfocus.application.automation.tools.model.EnumDescription;
import com.microfocus.application.automation.tools.model.ProxySettings;
import com.microfocus.application.automation.tools.uft.utils.UftToolUtils;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Node;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class RunFromFileSystemModel
extends AbstractDescribableImpl<RunFromFileSystemModel> {
    public static final String MOBILE_PROXY_SETTING_PASSWORD_FIELD = "MobileProxySetting_Password";
    public static final String MOBILE_PROXY_SETTING_USER_NAME = "MobileProxySetting_UserName";
    public static final String MOBILE_PROXY_SETTING_AUTHENTICATION = "MobileProxySetting_Authentication";
    public static final String MOBILE_USE_SSL = "MobileUseSSL";
    public static final EnumDescription FAST_RUN_MODE = new EnumDescription("Fast", "Fast");
    public static final EnumDescription NORMAL_RUN_MODE = new EnumDescription("Normal", "Normal");
    public static final List<EnumDescription> fsUftRunModes = Arrays.asList(FAST_RUN_MODE, NORMAL_RUN_MODE);
    public static final List<String> encodings = Arrays.asList("", "ASCII", "UTF-7", "UTF-8", "UTF-16");
    private String fsTests;
    private String fsTimeout;
    private String outEncoding;
    private String fsUftRunMode;
    private String controllerPollingInterval;
    private String perScenarioTimeOut;
    private String ignoreErrorStrings;
    private String analysisTemplate;
    private String displayController;
    private String mcServerName;
    private String fsReportPath;
    private String fsDeviceId;
    private String fsOs;
    private String fsManufacturerAndModel;
    private String fsTargetLab;
    private String fsAutActions;
    private String fsLaunchAppName;
    private String fsInstrumented;
    private String fsDevicesMetrics;
    private String fsExtraApps;
    private String fsJobId;
    private ProxySettings proxySettings;
    private String workspaceId;
    private String workspaceName;
    private boolean useSSL;
    private AuthModel authModel;
    private CloudBrowserModel cloudBrowserModel;

    public RunFromFileSystemModel(String fsTests, String fsTimeout, String fsUftRunMode, String controllerPollingInterval, String perScenarioTimeOut, String ignoreErrorStrings, String analysisTemplate, String displayController, String mcServerName, AuthModel authModel, String workspaceId, String fsDeviceId, String fsTargetLab, String fsManufacturerAndModel, String fsOs, String fsAutActions, String fsLaunchAppName, String fsDevicesMetrics, String fsInstrumented, String fsExtraApps, String fsJobId, ProxySettings proxySettings, boolean useSSL, String fsReportPath, CloudBrowserModel cloudBrowserModel) {
        this.setFsTests(fsTests);
        this.fsTimeout = fsTimeout;
        this.fsReportPath = fsReportPath;
        this.fsUftRunMode = fsUftRunMode;
        this.perScenarioTimeOut = perScenarioTimeOut;
        this.controllerPollingInterval = controllerPollingInterval;
        this.ignoreErrorStrings = ignoreErrorStrings;
        this.analysisTemplate = analysisTemplate;
        this.displayController = displayController;
        this.mcServerName = mcServerName;
        this.workspaceId = workspaceId;
        this.fsDeviceId = fsDeviceId;
        this.fsOs = fsOs;
        this.fsManufacturerAndModel = fsManufacturerAndModel;
        this.fsTargetLab = fsTargetLab;
        this.fsAutActions = fsAutActions;
        this.fsLaunchAppName = fsLaunchAppName;
        this.fsAutActions = fsAutActions;
        this.fsDevicesMetrics = fsDevicesMetrics;
        this.fsInstrumented = fsInstrumented;
        this.fsExtraApps = fsExtraApps;
        this.fsJobId = fsJobId;
        this.proxySettings = proxySettings;
        this.useSSL = useSSL;
        this.authModel = authModel;
        this.cloudBrowserModel = cloudBrowserModel;
    }

    @DataBoundConstructor
    public RunFromFileSystemModel(String fsTests) {
        this.setFsTests(fsTests);
        this.outEncoding = StringUtils.defaultString((String)this.outEncoding);
        this.fsTimeout = "";
        this.fsUftRunMode = fsUftRunModes.get(0).getValue();
        this.controllerPollingInterval = "30";
        this.perScenarioTimeOut = "10";
        this.ignoreErrorStrings = "";
        this.displayController = "false";
        this.analysisTemplate = "";
        this.fsReportPath = "";
        this.outEncoding = "";
    }

    public void setFsTests(String fsTests) {
        this.fsTests = fsTests.trim();
        if (!this.fsTests.contains("\n")) {
            this.fsTests = this.fsTests + "\n";
        }
    }

    public void setFsTimeout(String fsTimeout) {
        this.fsTimeout = fsTimeout;
    }

    public void setOutEncoding(String encoding) {
        this.outEncoding = encoding;
    }

    public String getOutEncoding() {
        return this.outEncoding;
    }

    public void setFsUftRunMode(String fsUftRunMode) {
        this.fsUftRunMode = fsUftRunMode;
    }

    public void setMcServerName(String mcServerName) {
        this.mcServerName = mcServerName;
    }

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public void setFsDeviceId(String fsDeviceId) {
        this.fsDeviceId = fsDeviceId;
    }

    public void setFsOs(String fsOs) {
        this.fsOs = fsOs;
    }

    public void setFsManufacturerAndModel(String fsManufacturerAndModel) {
        this.fsManufacturerAndModel = fsManufacturerAndModel;
    }

    public void setFsTargetLab(String fsTargetLab) {
        this.fsTargetLab = fsTargetLab;
    }

    public void setFsAutActions(String fsAutActions) {
        this.fsAutActions = fsAutActions;
    }

    public void setFsLaunchAppName(String fsLaunchAppName) {
        this.fsLaunchAppName = fsLaunchAppName;
    }

    public void setFsInstrumented(String fsInstrumented) {
        this.fsInstrumented = fsInstrumented;
    }

    public void setFsDevicesMetrics(String fsDevicesMetrics) {
        this.fsDevicesMetrics = fsDevicesMetrics;
    }

    public void setFsExtraApps(String fsExtraApps) {
        this.fsExtraApps = fsExtraApps;
    }

    public void setFsJobId(String fsJobId) {
        this.fsJobId = fsJobId;
    }

    public void setProxySettings(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public String getFsTests() {
        return this.fsTests;
    }

    public String getFsTimeout() {
        return this.fsTimeout;
    }

    public String getFsUftRunMode() {
        return this.fsUftRunMode;
    }

    public List<EnumDescription> getFsUftRunModes() {
        return fsUftRunModes;
    }

    public String getMcServerName() {
        return this.mcServerName;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setFsReportPath(String fsReportPath) {
        this.fsReportPath = fsReportPath;
    }

    public CloudBrowserModel getCloudBrowserModel() {
        return this.cloudBrowserModel;
    }

    public void setCloudBrowserModel(CloudBrowserModel cloudBrowserModel) {
        this.cloudBrowserModel = cloudBrowserModel;
    }

    public String getMcPassword() {
        if (this.authModel == null || this.authModel.getMcPassword() == null) {
            return null;
        }
        return this.authModel.getMcEncryptedPassword();
    }

    public String getMcExecToken() {
        if (this.authModel == null || this.authModel.getMcExecToken() == null) {
            return null;
        }
        return this.authModel.getMcEncryptedExecToken();
    }

    public String getFsDeviceId() {
        return this.fsDeviceId;
    }

    public String getFsOs() {
        return this.fsOs;
    }

    public String getFsManufacturerAndModel() {
        return this.fsManufacturerAndModel;
    }

    public String getFsTargetLab() {
        return this.fsTargetLab;
    }

    public String getFsAutActions() {
        return this.fsAutActions;
    }

    public String getFsLaunchAppName() {
        return this.fsLaunchAppName;
    }

    public String getFsInstrumented() {
        return this.fsInstrumented;
    }

    public String getFsDevicesMetrics() {
        return this.fsDevicesMetrics;
    }

    public String getFsExtraApps() {
        return this.fsExtraApps;
    }

    public String getFsJobId() {
        return this.fsJobId;
    }

    public boolean isUseProxy() {
        return this.proxySettings != null;
    }

    public boolean isUseProxyAuth() {
        return this.proxySettings != null && this.proxySettings.isFsUseAuthentication();
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public String getControllerPollingInterval() {
        return this.controllerPollingInterval;
    }

    public String getFsReportPath() {
        return this.fsReportPath;
    }

    public void setControllerPollingInterval(String controllerPollingInterval) {
        this.controllerPollingInterval = controllerPollingInterval;
    }

    public String getAnalysisTemplate() {
        return this.analysisTemplate;
    }

    public void setAnalysisTemplate(String analysisTemplate) {
        this.analysisTemplate = analysisTemplate;
    }

    public String getDisplayController() {
        return this.displayController;
    }

    public void setDisplayController(String displayController) {
        this.displayController = displayController;
    }

    public String getIgnoreErrorStrings() {
        return this.ignoreErrorStrings;
    }

    public void setIgnoreErrorStrings(String ignoreErrorStrings) {
        this.ignoreErrorStrings = ignoreErrorStrings;
    }

    public String getPerScenarioTimeOut() {
        return this.perScenarioTimeOut;
    }

    public void setPerScenarioTimeOut(String perScenarioTimeOut) {
        this.perScenarioTimeOut = perScenarioTimeOut;
    }

    public AuthModel getAuthModel() {
        return this.authModel;
    }

    public void setAuthModel(AuthModel authModel) {
        this.authModel = authModel;
    }

    public String getAuthType() {
        return this.authModel == null ? "base" : this.authModel.getValue();
    }

    @Nullable
    public Properties getProperties(EnvVars envVars, Node currNode) {
        return this.createProperties(envVars, currNode);
    }

    private Properties createProperties(EnvVars envVars, Node currNode) {
        Properties props = new Properties();
        this.addTestsToProps(envVars, props);
        this.addUFTSpecificSettingsToProps(envVars, props);
        if (this.addMobileSpecificSettingsToProps(currNode, props)) {
            return null;
        }
        return props;
    }

    private boolean addMobileSpecificSettingsToProps(Node currNode, Properties props) {
        if (this.isUseProxy()) {
            props.put("MobileUseProxy", "1");
            props.put("MobileProxyType", "2");
            props.put("MobileProxySetting_Address", this.proxySettings.getFsProxyAddress());
            if (this.isUseProxyAuth() && StringUtils.isNotBlank((String)this.proxySettings.getFsProxyUserName())) {
                String encryptedPassword;
                props.put(MOBILE_PROXY_SETTING_AUTHENTICATION, "1");
                props.put(MOBILE_PROXY_SETTING_USER_NAME, this.proxySettings.getFsProxyUserName());
                try {
                    encryptedPassword = EncryptionUtils.encrypt(this.proxySettings.getFsProxyPassword(), currNode);
                }
                catch (Exception ex) {
                    return true;
                }
                props.put(MOBILE_PROXY_SETTING_PASSWORD_FIELD, encryptedPassword);
            } else {
                props.put(MOBILE_PROXY_SETTING_AUTHENTICATION, "0");
                props.put(MOBILE_PROXY_SETTING_USER_NAME, "");
                props.put(MOBILE_PROXY_SETTING_PASSWORD_FIELD, "");
            }
        } else {
            props.put("MobileUseProxy", "0");
            props.put("MobileProxyType", "0");
            props.put(MOBILE_PROXY_SETTING_AUTHENTICATION, "0");
            props.put("MobileProxySetting_Address", "");
            props.put(MOBILE_PROXY_SETTING_USER_NAME, "");
            props.put(MOBILE_PROXY_SETTING_PASSWORD_FIELD, "");
        }
        if (this.useSSL) {
            props.put(MOBILE_USE_SSL, "1");
        } else {
            props.put(MOBILE_USE_SSL, "0");
        }
        if (this.workspaceId != null && !this.workspaceId.isEmpty()) {
            props.put("MobileWorkspaceName", this.workspaceId);
        } else {
            props.put("MobileWorkspaceName", "");
        }
        if (this.fsDevicesMetrics != null && !this.fsDevicesMetrics.isEmpty()) {
            props.put("MobileDeviceMetrics", this.fsDevicesMetrics);
        } else {
            props.put("MobileDeviceMetrics", "");
        }
        if (this.authModel != null && this.authModel.getValue().equals("base") && StringUtils.isNotBlank((String)this.authModel.getMcUserName())) {
            props.put("MobileUserName", this.authModel.getMcUserName());
        }
        return false;
    }

    private void addUFTSpecificSettingsToProps(EnvVars envVars, Properties props) {
        String fsTimeoutVal = StringUtils.isEmpty((String)this.fsTimeout) ? "-1" : envVars.expand(this.fsTimeout);
        props.put("fsTimeout", fsTimeoutVal);
        String fsUFTRunModeVal = StringUtils.isEmpty((String)this.fsUftRunMode) ? "Fast" : this.fsUftRunMode;
        props.put("fsUftRunMode", fsUFTRunModeVal);
        String controllerPollingIntervalValue = StringUtils.isEmpty((String)this.controllerPollingInterval) ? "30" : this.controllerPollingInterval;
        props.put("controllerPollingInterval", controllerPollingIntervalValue);
        String analysisTemplateVal = StringUtils.isEmpty((String)this.analysisTemplate) ? "" : this.analysisTemplate;
        props.put("analysisTemplate", analysisTemplateVal);
        String displayControllerVal = StringUtils.isEmpty((String)this.displayController) || this.displayController.equals("false") ? "0" : "1";
        props.put("displayController", displayControllerVal);
        String perScenarioTimeOutVal = StringUtils.isEmpty((String)this.perScenarioTimeOut) ? "10" : envVars.expand(this.perScenarioTimeOut);
        props.put("PerScenarioTimeOut", perScenarioTimeOutVal);
        if (!StringUtils.isEmpty((String)this.ignoreErrorStrings.replaceAll("\\r|\\n", ""))) {
            props.put("ignoreErrorStrings", this.ignoreErrorStrings.replaceAll("\r", ""));
        }
        if (StringUtils.isNotBlank((String)this.fsReportPath)) {
            props.put("fsReportPath", this.fsReportPath);
        }
    }

    private void addTestsToProps(EnvVars envVars, Properties props) {
        if (!StringUtils.isEmpty((String)this.fsTests)) {
            String expandedFsTests = envVars.expand(this.fsTests);
            String[] testsArr = UftToolUtils.isMtbxContent(expandedFsTests) ? new String[]{expandedFsTests} : expandedFsTests.replaceAll("\r", "").split("\n");
            int i = 1;
            for (String test : testsArr) {
                test = test.trim();
                props.put("Test" + i, test);
                ++i;
            }
        } else {
            props.put("fsTests", "");
        }
    }

    public JSONObject getJobDetails(String mcUrl) {
        return JobConfigurationProxy.getInstance().getJobById(mcUrl, this.authModel, this.proxySettings, this.fsJobId);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<RunFromFileSystemModel> {
        @Nonnull
        public String getDisplayName() {
            return "UFT File System Model";
        }

        public List<EnumDescription> getFsUftRunModes() {
            return fsUftRunModes;
        }
    }
}

