/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.model;

import com.microfocus.application.automation.tools.model.CredentialsScope;
import com.microfocus.application.automation.tools.model.EnumDescription;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.Secret;
import hudson.util.VariableResolver;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class RunFromAlmModel
extends AbstractDescribableImpl<RunFromAlmModel> {
    public static final EnumDescription runModeLocal = new EnumDescription("RUN_LOCAL", "Run locally");
    public static final EnumDescription runModePlannedHost = new EnumDescription("RUN_PLANNED_HOST", "Run on planned host");
    public static final EnumDescription runModeRemote = new EnumDescription("RUN_REMOTE", "Run remotely");
    public static final List<EnumDescription> runModes = Arrays.asList(runModeLocal, runModePlannedHost, runModeRemote);
    public static final int DEFAULT_TIMEOUT = 36000;
    public static final String ALM_PASSWORD_KEY = "almPassword";
    public static final String ALM_API_KEY_SECRET = "almApiKeySecret";
    private String almServerName;
    private String almUserName;
    private Secret almPassword;
    private String almDomain;
    private String almProject;
    private String almTestSets;
    private String almRunResultsMode;
    private String almTimeout;
    private String almRunMode;
    private String almRunHost;
    private Boolean isSSOEnabled;
    private String almClientID;
    private Secret almApiKey;
    private CredentialsScope credentialsScope;

    @DataBoundConstructor
    public RunFromAlmModel(String almServerName, String almUserName, String almPassword, String almDomain, String almProject, String almTestSets, String almRunResultsMode, String almTimeout, String almRunMode, String almRunHost, Boolean isSSOEnabled, String almClientID, String almApiKey, CredentialsScope credentialsScope) {
        this.almServerName = almServerName;
        this.credentialsScope = credentialsScope;
        this.almUserName = StringUtils.defaultString((String)almUserName);
        this.almPassword = StringUtils.isBlank((String)almUserName) ? null : Secret.fromString((String)almPassword);
        this.almDomain = almDomain;
        this.almProject = almProject;
        this.almTestSets = almTestSets;
        if (!this.almTestSets.contains("\n")) {
            this.almTestSets = this.almTestSets + "\n";
        }
        this.almRunResultsMode = almRunResultsMode;
        this.almTimeout = almTimeout;
        this.almRunMode = almRunMode;
        this.almRunHost = almRunHost;
        this.isSSOEnabled = isSSOEnabled;
        this.almClientID = StringUtils.defaultString((String)almClientID);
        this.almApiKey = StringUtils.isBlank((String)almClientID) ? null : Secret.fromString((String)almApiKey);
    }

    public String getAlmUserName() {
        return this.almUserName;
    }

    public String getAlmDomain() {
        return this.almDomain;
    }

    public Secret getAlmPassword() {
        return this.almPassword;
    }

    public String getAlmProject() {
        return this.almProject;
    }

    public String getAlmTestSets() {
        return this.almTestSets;
    }

    public String getAlmRunResultsMode() {
        return this.almRunResultsMode;
    }

    public String getAlmTimeout() {
        return this.almTimeout;
    }

    public String getAlmRunHost() {
        return this.almRunHost;
    }

    public String getAlmRunMode() {
        return this.almRunMode;
    }

    public String getAlmServerName() {
        return this.almServerName;
    }

    public CredentialsScope getCredentialsScope() {
        return this.credentialsScope;
    }

    public Boolean isSSOEnabled() {
        return this.isSSOEnabled;
    }

    public void setIsSSOEnabled(Boolean isSSOEnabled) {
        this.isSSOEnabled = isSSOEnabled;
    }

    public String getAlmClientID() {
        return this.almClientID;
    }

    public Secret getAlmApiKey() {
        return this.almApiKey;
    }

    public Properties getProperties(EnvVars envVars, VariableResolver<String> varResolver) {
        return this.CreateProperties(envVars, varResolver);
    }

    public String getCredentialsScopeValue() {
        return this.credentialsScope == null ? "" : this.credentialsScope.getValue();
    }

    public String getPasswordEncryptedValue() {
        return this.almPassword == null ? "" : this.almPassword.getEncryptedValue();
    }

    public String getApiKeyEncryptedValue() {
        return this.almApiKey == null || StringUtils.isBlank((String)this.almApiKey.getPlainText()) ? "" : this.almApiKey.getEncryptedValue();
    }

    public String getPasswordPlainText() {
        return this.almPassword == null ? "" : this.almPassword.getPlainText();
    }

    public String getApiKeyPlainText() {
        return this.almApiKey == null ? "" : this.almApiKey.getPlainText();
    }

    public Properties getProperties() {
        return this.CreateProperties(null, null);
    }

    private Properties CreateProperties(EnvVars envVars, VariableResolver<String> varResolver) {
        Properties props = new Properties();
        if (this.isSSOEnabled != null) {
            props.put("SSOEnabled", Boolean.toString(this.isSSOEnabled));
        } else {
            props.put("SSOEnabled", Boolean.toString(false));
        }
        if (envVars == null) {
            props.put("almUsername", this.almUserName);
            props.put("almDomain", this.almDomain);
            props.put("almProject", this.almProject);
            props.put("almRunHost", this.almRunHost);
        } else {
            props.put("almUsername", Util.replaceMacro((String)envVars.expand(this.almUserName), varResolver));
            props.put("almDomain", Util.replaceMacro((String)envVars.expand(this.almDomain), varResolver));
            props.put("almProject", Util.replaceMacro((String)envVars.expand(this.almProject), varResolver));
            props.put("almRunHost", Util.replaceMacro((String)envVars.expand(this.almRunHost), varResolver));
        }
        if (!StringUtils.isEmpty((String)this.almTestSets)) {
            String[] testSetsArr = this.almTestSets.replaceAll("\r", "").split("\n");
            int i = 1;
            for (String testSet : testSetsArr) {
                if (StringUtils.isBlank((String)testSet)) continue;
                props.put("TestSet" + i, Util.replaceMacro((String)envVars.expand(testSet), varResolver));
                ++i;
            }
            props.put("numOfTests", String.valueOf(i - 1));
        } else {
            props.put("almTestSets", "");
        }
        if (StringUtils.isEmpty((String)this.almTimeout)) {
            props.put("almTimeout", "-1");
        } else {
            props.put("almTimeout", this.almTimeout);
        }
        props.put("almRunMode", this.almRunMode);
        return props;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<RunFromAlmModel> {
        @Nonnull
        public String getDisplayName() {
            return "UFT ALM Model";
        }

        public List<EnumDescription> getAlmRunModes() {
            return runModes;
        }
    }
}

