/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.model;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ParallelRunnerEnvironmentModel
extends AbstractDescribableImpl<ParallelRunnerEnvironmentModel> {
    private String environment;
    private String environmentType;

    @DataBoundConstructor
    public ParallelRunnerEnvironmentModel(String environment, String environmentType) {
        this.environment = environment;
        this.environmentType = environmentType;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getEnvironmentType() {
        return this.environmentType;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ParallelRunnerEnvironmentModel> {
        private static final String DeviceIdKey = "deviceid";
        private static final String OsTypeKey = "ostype";
        private static final String OsVersionKey = "osversion";
        private static final String ManufacturerAndModelKey = "manufacturerandmodel";
        private static final String BrowserKey = "browser";
        private static final List<String> SupportedBrowsers = new ArrayList<String>(){
            {
                this.add("IE");
                this.add("IE64");
                this.add("CHROME");
                this.add("FIREFOX");
                this.add("FIREFOX64");
            }
        };
        private static final List<String> KnownProperties = new ArrayList<String>(){
            {
                this.add(DescriptorImpl.DeviceIdKey);
                this.add(DescriptorImpl.OsTypeKey);
                this.add(DescriptorImpl.OsVersionKey);
                this.add(DescriptorImpl.ManufacturerAndModelKey);
                this.add(DescriptorImpl.BrowserKey);
            }
        };

        public DescriptorImpl() {
            this.load();
        }

        @Nonnull
        public String getDisplayName() {
            return "Parallel Runner Environment model.";
        }

        private Map<String, String> getEnvironmentKeyValuePairs(String environment) {
            String[] tokens;
            HashMap<String, String> pairs = new HashMap<String, String>();
            for (String token : tokens = environment.toLowerCase().split(",")) {
                String key;
                String[] keyValue = token.split(":");
                if (keyValue.length < 2 || (key = keyValue[0].trim()).isEmpty()) continue;
                String value = StringUtils.join(Arrays.asList(keyValue).subList(1, keyValue.length), (String)"").trim();
                pairs.put(key, value);
            }
            return pairs;
        }

        private boolean isSupportedBrowser(String browserName) {
            for (String browser : SupportedBrowsers) {
                if (!browser.equalsIgnoreCase(browserName)) continue;
                return true;
            }
            return false;
        }

        private boolean isKnownProperty(String property) {
            for (String knownProperty : KnownProperties) {
                if (!knownProperty.equalsIgnoreCase(property)) continue;
                return true;
            }
            return false;
        }

        private void checkKeyValueValidity(String key, Map<String, String> pairs, String message) throws EnvironmentValidationException {
            if (pairs.containsKey(key) && pairs.get(key).trim().isEmpty()) {
                throw new EnvironmentValidationException(message);
            }
        }

        private void validateEnvironmentString(String environment) throws EnvironmentValidationException {
            Map<String, String> pairs = this.getEnvironmentKeyValuePairs(environment);
            if (pairs.isEmpty()) {
                throw new EnvironmentValidationException("No property provided. Enter properties using the following syntax: <name>:<value>");
            }
            for (String key : pairs.keySet()) {
                if (this.isKnownProperty(key)) continue;
                throw new EnvironmentValidationException("Invalid property name: " + key);
            }
            this.checkKeyValueValidity(DeviceIdKey, pairs, "DeviceId value must not be empty!");
            this.checkKeyValueValidity(OsVersionKey, pairs, "OsVersion value must not be empty!");
            this.checkKeyValueValidity(OsTypeKey, pairs, "OsType value must not be empty!");
            this.checkKeyValueValidity(ManufacturerAndModelKey, pairs, "ManufacturerAndModel value must not be empty!");
            if (pairs.containsKey(BrowserKey)) {
                String browserName = pairs.get(BrowserKey).trim();
                if (browserName.isEmpty()) {
                    throw new EnvironmentValidationException("Browser value must not be empty!");
                }
                if (!this.isSupportedBrowser(browserName)) {
                    throw new EnvironmentValidationException(String.format("Invalid browser. %s is not supported!", browserName.toUpperCase()));
                }
            }
        }

        public FormValidation doCheckEnvironment(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.ok();
            }
            try {
                this.validateEnvironmentString(value);
            }
            catch (EnvironmentValidationException e) {
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok();
        }
    }

    private static class EnvironmentValidationException
    extends Exception {
        public EnvironmentValidationException(String message) {
            super(message);
        }
    }
}

