/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.mc;

import com.microfocus.application.automation.tools.mc.AuthType;
import com.microfocus.application.automation.tools.mc.HttpResponse;
import com.microfocus.application.automation.tools.mc.HttpUtils;
import com.microfocus.application.automation.tools.mc.Oauth2TokenUtil;
import com.microfocus.application.automation.tools.model.AuthModel;
import com.microfocus.application.automation.tools.model.ProxySettings;
import com.microfocus.application.automation.tools.sse.common.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;

public class JobConfigurationProxy {
    private static final String TOKEN = "token";
    private static final String EXTRA_APPS = "extraApps";
    private static final String INSTRUMENTED = "instrumented";
    private static final String PACKAGED = "Packaged";
    private static final String NOT_PACKAGED = "Not Packaged";
    private static JobConfigurationProxy instance = null;

    private JobConfigurationProxy() {
    }

    public static JobConfigurationProxy getInstance() {
        if (instance == null) {
            instance = new JobConfigurationProxy();
        }
        return instance;
    }

    public JSONObject loginToMC(String mcUrl, AuthModel authModel, ProxySettings proxy) {
        JSONObject returnObject = new JSONObject();
        try {
            HttpResponse response;
            AuthType authType;
            Map<String, String> headers = this.getRequestHeaders();
            JSONObject sendObject = new JSONObject();
            if (null == proxy) {
                proxy = new ProxySettings();
            }
            if ((authType = authModel.getAuthType()) == AuthType.BASE) {
                sendObject.put((Object)"name", (Object)authModel.getMcUserName());
                sendObject.put((Object)"password", (Object)authModel.getMcPassword());
                sendObject.put((Object)"accountName", (Object)"default");
                response = this.doPost(proxy, mcUrl + "/rest/client/login", headers, sendObject);
            } else if (Oauth2TokenUtil.isValid(authModel.getMcExecToken())) {
                sendObject = Oauth2TokenUtil.getJSONObject();
                response = this.doPost(proxy, mcUrl + "/rest/client/v2/oauth2/login", headers, sendObject);
            } else {
                System.out.println("ERROR:: oauth token is invalid.");
                return returnObject;
            }
            return this.parseLoginResponse(response, authType);
        }
        catch (Exception e) {
            e.printStackTrace();
            return returnObject;
        }
    }

    private JSONObject generateNewToken(String mcUrl, String accessKey, ProxySettings proxy) {
        try {
            Map<String, String> headers = this.getRequestHeaders();
            if (null == proxy) {
                proxy = new ProxySettings();
            }
            if (Oauth2TokenUtil.isValid(accessKey)) {
                JSONObject sendObject = Oauth2TokenUtil.getJSONObject();
                String url = mcUrl + "/rest/oauth2/token";
                HttpResponse response = this.doPost(proxy, url, headers, sendObject);
                return this.parseTokenResponse(response, AuthType.TOKEN);
            }
            System.out.println("ERROR: oauth token is invalid.");
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json;charset=UTF-8");
        return headers;
    }

    private JSONObject parseLoginResponse(HttpResponse response, AuthType authType) {
        List<String> cookies;
        JSONObject returnObject = new JSONObject();
        if (response == null || response.getHeaders() == null) {
            return null;
        }
        if (response.getJsonObject() != null && response.getJsonObject().containsKey((Object)"error") && response.getJsonObject().getAsString("error").equals("true")) {
            return null;
        }
        Map<String, List<String>> headerFields = response.getHeaders();
        List<String> hp4mSecretList = headerFields.get("x-hp4msecret");
        if (hp4mSecretList != null && !hp4mSecretList.isEmpty() && !StringUtils.isNullOrEmpty(hp4mSecretList.get(0))) {
            returnObject.put((Object)"x-hp4msecret", (Object)hp4mSecretList.get(0));
        }
        if (authType == AuthType.TOKEN && headerFields.containsKey("Set-Cookie") && (cookies = headerFields.get("Set-Cookie")) != null && !cookies.isEmpty()) {
            for (String cookie : cookies) {
                if (!cookie.startsWith("OAUTH2_COOKIE_KEY")) continue;
                returnObject.put((Object)"OAUTH2_COOKIE_KEY", (Object)this.getCookieValue(cookie, "OAUTH2_COOKIE_KEY"));
                break;
            }
        }
        returnObject.put((Object)"Cookies", (Object)response.getCookiesAsString());
        return returnObject;
    }

    private JSONObject parseTokenResponse(HttpResponse response, AuthType authType) {
        JSONObject body;
        JSONObject returnObject = this.parseLoginResponse(response, authType);
        if (returnObject != null && (body = response.getJsonObject()) != null) {
            returnObject.put((Object)"access_token", (Object)body.getAsString("access_token"));
            returnObject.put((Object)"token_type", (Object)body.getAsString("token_type"));
        }
        return returnObject;
    }

    public JSONObject isWorkspaceExist(Map<String, String> headers, String mcUrl, ProxySettings proxy, String appUploadWorkspace) throws IOException {
        HttpUtils.ProxyInfo proxyInfo;
        HttpResponse response;
        String getWorkspaceUrl;
        if (null == proxy) {
            proxy = new ProxySettings();
        }
        if (!StringUtils.isNullOrEmpty(getWorkspaceUrl = mcUrl + "/rest/v2/workspaces")) {
            getWorkspaceUrl = getWorkspaceUrl + String.format("/%s", appUploadWorkspace);
        }
        if ((response = HttpUtils.doGet(proxyInfo = HttpUtils.setProxyCfg(proxy.getFsProxyAddress(), proxy.getFsProxyUserName(), proxy.getFsProxyPassword()), getWorkspaceUrl, headers, null)) != null && response.getJsonObject() != null) {
            return response.getJsonObject();
        }
        return null;
    }

    public String isSigningServiceEnabled(Map<String, String> headers, String mcUrl, ProxySettings proxy) throws IOException {
        HttpUtils.ProxyInfo proxyInfo;
        HttpResponse response;
        String getAdminSettingUrl;
        if (null == proxy) {
            proxy = new ProxySettings();
        }
        if (!StringUtils.isNullOrEmpty(getAdminSettingUrl = mcUrl + "/rest/v2/adminSettings")) {
            getAdminSettingUrl = getAdminSettingUrl + String.format("/%s", "PACKAGING_IOS");
        }
        if ((response = HttpUtils.doGet(proxyInfo = HttpUtils.setProxyCfg(proxy.getFsProxyAddress(), proxy.getFsProxyUserName(), proxy.getFsProxyPassword()), getAdminSettingUrl, headers, null)) != null && response.getJsonArray() != null) {
            for (int i = 0; i < response.getJsonArray().size(); ++i) {
                JSONObject setting = (JSONObject)response.getJsonArray().get(i);
                if (!setting.getAsString("name").equals("IOS_PACKAGER_ENABLE")) continue;
                return setting.getAsString("value");
            }
        }
        return null;
    }

    public Map<String, String> login(String mcUrl, AuthModel authModel, ProxySettings proxy) {
        Map<String, String> headers = new HashMap<String, String>();
        try {
            if (null == proxy) {
                proxy = new ProxySettings();
            }
            JSONObject loginJson = this.loginToMC(mcUrl, authModel, proxy);
            headers = this.initHeaders(authModel, loginJson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return headers;
    }

    public JSONObject upload(Map<String, String> headers, String mcUrl, ProxySettings proxy, String appPath, String appUploadWorkspace) throws IOException {
        File appFile = new File(appPath);
        String uploadUrl = mcUrl + "/rest/v2/apps";
        String signingServiceEnabled = this.isSigningServiceEnabled(headers, mcUrl, proxy);
        uploadUrl = !StringUtils.isNullOrEmpty(signingServiceEnabled) && signingServiceEnabled.equalsIgnoreCase("true") ? uploadUrl + "?asyncInstrumentation=false&instrument=true&resign=true&isAppUploadPage=true" : uploadUrl + "?asyncInstrumentation=false&instrument=true&resign=false&isAppUploadPage=true";
        if (!StringUtils.isNullOrEmpty(appUploadWorkspace)) {
            uploadUrl = uploadUrl + String.format("&workspaceId=%s", appUploadWorkspace);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StringBuilder content = new StringBuilder();
        content.append("\r\n").append("------").append("randomstring").append("\r\n");
        content.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + appFile.getName() + "\"\r\n");
        content.append("Content-Type: application/octet-stream\r\n\r\n");
        outputStream.write(content.toString().getBytes());
        try (FileInputStream in = new FileInputStream(appFile);){
            byte[] b = new byte[1024];
            int i = 0;
            while ((i = in.read(b)) != -1) {
                outputStream.write(b, 0, i);
            }
        }
        outputStream.write("\r\n------randomstring--\r\n".getBytes());
        byte[] bytes = outputStream.toByteArray();
        outputStream.close();
        if (null == proxy) {
            proxy = new ProxySettings();
        }
        headers.put("Content-Type", "multipart/form-data; boundary=----randomstring");
        headers.put("filename", appFile.getName());
        HttpUtils.ProxyInfo proxyInfo = HttpUtils.setProxyCfg(proxy.getFsProxyAddress(), proxy.getFsProxyUserName(), proxy.getFsProxyPassword());
        HttpResponse response = HttpUtils.doPost(proxyInfo, uploadUrl, headers, bytes);
        if (response != null && response.getJsonObject() != null) {
            return response.getJsonObject();
        }
        return null;
    }

    public String isAllowUploadToSharedAssert(Map<String, String> headers, String mcUrl, ProxySettings proxy) throws IOException {
        HttpUtils.ProxyInfo proxyInfo;
        HttpResponse response;
        String getAdminSettingUrl;
        if (null == proxy) {
            proxy = new ProxySettings();
        }
        if (!StringUtils.isNullOrEmpty(getAdminSettingUrl = mcUrl + "/rest/v2/adminSettings")) {
            getAdminSettingUrl = getAdminSettingUrl + String.format("/%s", "USER_PERMISSION");
        }
        if ((response = HttpUtils.doGet(proxyInfo = HttpUtils.setProxyCfg(proxy.getFsProxyAddress(), proxy.getFsProxyUserName(), proxy.getFsProxyPassword()), getAdminSettingUrl, headers, null)) != null && response.getJsonArray() != null) {
            for (int i = 0; i < response.getJsonArray().size(); ++i) {
                JSONObject setting = (JSONObject)response.getJsonArray().get(i);
                if (!setting.getAsString("name").equals("USER_PERMISSION_UPLOAD_APP_TO_SHARED_ASSETS")) continue;
                return setting.getAsString("value");
            }
        }
        return null;
    }

    public JSONArray getAllValidWorkspaces(String mcUrl, AuthModel authModel, ProxySettings proxy) throws IOException {
        try {
            HttpResponse response;
            Map<String, String> headers = this.login(mcUrl, authModel, proxy);
            HttpUtils.ProxyInfo proxyInfo = proxy == null ? null : HttpUtils.setProxyCfg(proxy.getFsProxyAddress(), proxy.getFsProxyUserName(), proxy.getFsProxyPassword());
            String queryString = "includeSharedAssets=true";
            String strAllowUploadToSharedAssert = this.isAllowUploadToSharedAssert(headers, mcUrl, proxy);
            if (!StringUtils.isNullOrEmpty(strAllowUploadToSharedAssert) && strAllowUploadToSharedAssert.equalsIgnoreCase("false")) {
                queryString = "includeSharedAssets=false";
            }
            if ((response = HttpUtils.doGet(proxyInfo, mcUrl + "/rest/v2/workspaces", headers, queryString)) != null && response.getJsonArray() != null) {
                return response.getJsonArray();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String createTempJobWithHeaders(String mcUrl, ProxySettings proxy, Map<String, String> headers) {
        JSONObject job;
        HttpUtils.ProxyInfo proxyInfo;
        HttpResponse response;
        if (headers != null && (response = HttpUtils.doGet(proxyInfo = proxy == null ? null : HttpUtils.setProxyCfg(proxy.getFsProxyAddress(), proxy.getFsProxyUserName(), proxy.getFsProxyPassword()), mcUrl + "/rest/job/createTempJob", headers, null)) != null && response.getJsonObject() != null && (job = response.getJsonObject()) != null && job.get((Object)"data") != null) {
            JSONObject data = (JSONObject)job.get((Object)"data");
            return data.getAsString("id");
        }
        return null;
    }

    public JSONObject getJobById(String mcUrl, AuthModel authModel, ProxySettings proxy, String jobUUID) {
        JSONObject jobJsonObject = null;
        try {
            JSONObject loginJson = this.loginToMC(mcUrl, authModel, proxy);
            Map<String, String> headers = this.initHeaders(authModel, loginJson);
            jobJsonObject = this.getJobByIdWithHeaders(mcUrl, proxy, jobUUID, headers);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.removeIcon(jobJsonObject);
    }

    public JSONObject getJobByIdWithHeaders(String mcUrl, ProxySettings proxy, String jobUUID, Map<String, String> headers) {
        JSONObject jobJsonObject = null;
        if (!StringUtils.isNullOrEmpty(jobUUID) && headers != null) {
            HttpUtils.ProxyInfo proxyInfo = proxy == null ? null : HttpUtils.setProxyCfg(proxy.getFsProxyAddress(), proxy.getFsProxyUserName(), proxy.getFsProxyPassword());
            HttpResponse response = HttpUtils.doGet(proxyInfo, mcUrl + "/rest/job/" + jobUUID, headers, null);
            if (response != null && response.getJsonObject() != null) {
                jobJsonObject = response.getJsonObject();
            }
            if (jobJsonObject != null) {
                jobJsonObject = (JSONObject)jobJsonObject.get((Object)"data");
            }
        }
        return jobJsonObject;
    }

    public JSONObject getBrowserLab(String mcUrl, String accessKey, ProxySettings proxy) {
        JSONObject jsonObject = null;
        try {
            String cookies;
            String tokenType;
            String token;
            JSONObject loginJson = this.generateNewToken(mcUrl, accessKey, proxy);
            if (loginJson == null) {
                return null;
            }
            String hp4mSecret = loginJson.getAsString("x-hp4msecret");
            if (this.thereIsNoArgumentNullOrEmpty(hp4mSecret, token = loginJson.getAsString("access_token"), tokenType = loginJson.getAsString("token_type"), cookies = loginJson.getAsString("Cookies"))) {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Accept", "application/json");
                headers.put("x-hp4msecret", hp4mSecret);
                headers.put("Cookie", cookies);
                headers.put("Authorization", String.format("%s %s", tokenType, token));
                HttpUtils.ProxyInfo proxyInfo = proxy == null ? null : HttpUtils.setProxyCfg(proxy.getFsProxyAddress(), proxy.getFsProxyUserName(), proxy.getFsProxyPassword());
                String url = String.format("%s%s?toolVersion=23.4", mcUrl, "/rest/v2/browser-lab/uftone/templates");
                HttpResponse response = HttpUtils.doGet(proxyInfo, url, headers, null);
                if (response != null && response.getJsonObject() != null) {
                    jsonObject = response.getJsonObject();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    public JSONObject getJobJSONData(String mcUrl, AuthModel authModel, ProxySettings proxy, String jobUUID) {
        String headerStr;
        JSONObject headerJSON;
        JSONObject deviceJSON;
        JSONObject jobJSON = this.getJobById(mcUrl, authModel, proxy, jobUUID);
        JSONObject returnJSON = new JSONObject();
        if (jobJSON == null) {
            return returnJSON;
        }
        JSONObject returnDeviceCapabilityJSON = new JSONObject();
        JSONObject detailJSON = (JSONObject)jobJSON.get((Object)"capableDeviceFilterDetails");
        if (detailJSON != null) {
            String osType = (String)detailJSON.get((Object)"platformName");
            String osVersion = (String)detailJSON.get((Object)"platformVersion");
            String manufacturerAndModel = (String)detailJSON.get((Object)"deviceName");
            String targetLab = (String)detailJSON.get((Object)"source");
            returnDeviceCapabilityJSON.put((Object)"OS", (Object)(osType + osVersion));
            returnDeviceCapabilityJSON.put((Object)"manufacturerAndModel", (Object)manufacturerAndModel);
            returnDeviceCapabilityJSON.put((Object)"targetLab", (Object)targetLab);
        }
        JSONObject returnDeviceJSON = new JSONObject();
        JSONArray devices = (JSONArray)jobJSON.get((Object)"devices");
        if (devices != null && (deviceJSON = (JSONObject)devices.get(0)) != null) {
            String deviceID = deviceJSON.getAsString("deviceID");
            String osType = deviceJSON.getAsString("osType");
            String osVersion = deviceJSON.getAsString("osVersion");
            String manufacturerAndModel = deviceJSON.getAsString("model");
            returnDeviceJSON.put((Object)"deviceId", (Object)deviceID);
            returnDeviceJSON.put((Object)"OS", (Object)(osType + " " + osVersion));
            returnDeviceJSON.put((Object)"manufacturerAndModel", (Object)manufacturerAndModel);
        }
        JSONArray returnExtraJSONArray = new JSONArray();
        StringBuilder extraApps = new StringBuilder();
        JSONArray extraAppJSONArray = (JSONArray)jobJSON.get((Object)EXTRA_APPS);
        if (extraAppJSONArray != null) {
            Iterator iterator = extraAppJSONArray.iterator();
            while (iterator.hasNext()) {
                JSONObject extraAPPJSON = new JSONObject();
                JSONObject nextJSONObject = (JSONObject)iterator.next();
                String extraAppName = (String)nextJSONObject.get((Object)"name");
                Boolean instrumented = (Boolean)nextJSONObject.get((Object)INSTRUMENTED);
                extraAPPJSON.put((Object)"extraAppName", (Object)extraAppName);
                extraAPPJSON.put((Object)INSTRUMENTED, (Object)(instrumented != false ? PACKAGED : NOT_PACKAGED));
                if (extraApps.length() > 1) {
                    extraApps.append(";\n");
                }
                extraApps.append(extraAppName).append("\t\t").append(instrumented != false ? PACKAGED : NOT_PACKAGED);
                returnExtraJSONArray.add((Object)extraAPPJSON);
            }
        }
        JSONObject returnDefinitionJSON = new JSONObject();
        JSONObject applicationJSON = (JSONObject)jobJSON.get((Object)"application");
        if (applicationJSON != null) {
            String launchApplicationName = (String)applicationJSON.get((Object)"name");
            Boolean instrumented = (Boolean)applicationJSON.get((Object)INSTRUMENTED);
            returnDefinitionJSON.put((Object)"launchApplicationName", (Object)launchApplicationName);
            returnDefinitionJSON.put((Object)INSTRUMENTED, (Object)(instrumented != false ? PACKAGED : NOT_PACKAGED));
        }
        if ((headerJSON = this.parseJSONString(headerStr = (String)jobJSON.get((Object)"header"))) != null) {
            JSONObject configurationJSONObject = (JSONObject)headerJSON.get((Object)"configuration");
            Boolean restart = (Boolean)configurationJSONObject.get((Object)"restartApp");
            Boolean install = (Boolean)configurationJSONObject.get((Object)"installAppBeforeExecution");
            Boolean uninstall = (Boolean)configurationJSONObject.get((Object)"deleteAppAfterExecution");
            StringBuilder sb = new StringBuilder("");
            if (restart.booleanValue()) {
                sb.append("Restart;");
            }
            if (install.booleanValue()) {
                sb.append("Install;");
            }
            if (uninstall.booleanValue()) {
                sb.append("Uninstall;");
            }
            JSONObject collectJSON = (JSONObject)headerJSON.get((Object)"collect");
            StringBuilder deviceMetricsSb = new StringBuilder("");
            if (collectJSON != null) {
                Boolean useCPU = (Boolean)collectJSON.get((Object)"cpu");
                Boolean useMemory = (Boolean)collectJSON.get((Object)"memory");
                Boolean useLogs = (Boolean)collectJSON.get((Object)"logs");
                Boolean useScreenshot = (Boolean)collectJSON.get((Object)"screenshot");
                Boolean useFreeMemory = (Boolean)collectJSON.get((Object)"freeMemory");
                if (useCPU.booleanValue()) {
                    deviceMetricsSb.append("CPU;");
                }
                if (useMemory.booleanValue()) {
                    deviceMetricsSb.append("Memory;");
                }
                if (useLogs.booleanValue()) {
                    deviceMetricsSb.append("Log;");
                }
                if (useScreenshot.booleanValue()) {
                    deviceMetricsSb.append("Screenshot;");
                }
                if (useFreeMemory.booleanValue()) {
                    deviceMetricsSb.append("FreeMomery;");
                }
            }
            returnDefinitionJSON.put((Object)"autActions", (Object)this.removeLastSemicolon(sb));
            returnDefinitionJSON.put((Object)"deviceMetrics", (Object)this.removeLastSemicolon(deviceMetricsSb));
        }
        returnJSON.put((Object)"deviceCapability", (Object)returnDeviceCapabilityJSON);
        returnJSON.put((Object)EXTRA_APPS, (Object)extraApps.toString());
        returnJSON.put((Object)"extraApps2", (Object)returnExtraJSONArray);
        returnJSON.put((Object)"definitions", (Object)returnDefinitionJSON);
        returnJSON.put((Object)"jobUUID", (Object)jobUUID);
        returnJSON.put((Object)"deviceJSON", (Object)returnDeviceJSON);
        return returnJSON;
    }

    public boolean isServerOnSaaS(Map<String, String> headers, String mcUrl, ProxySettings proxy) {
        if (null == proxy) {
            proxy = new ProxySettings();
        }
        String isDLServerOnSaaSURL = mcUrl + "/rest/v2/status/saas";
        HttpUtils.ProxyInfo proxyInfo = HttpUtils.setProxyCfg(proxy.getFsProxyAddress(), proxy.getFsProxyUserName(), proxy.getFsProxyPassword());
        HttpResponse response = HttpUtils.doGet(proxyInfo, isDLServerOnSaaSURL, headers, null);
        if (response.getJsonObject() != null) {
            boolean isError = Boolean.parseBoolean(response.getJsonObject().get((Object)"error").toString());
            return !isError;
        }
        return false;
    }

    private JSONObject parseJSONString(String jsonString) {
        JSONObject jsonObject = null;
        try {
            jsonObject = (JSONObject)JSONValue.parseStrict((String)jsonString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    private String getCookieValue(String setCookie, String cookieName) {
        if (StringUtils.isNullOrEmpty(setCookie)) {
            return null;
        }
        String id = null;
        String[] cookies = setCookie.split(";");
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookies[i].contains(cookieName)) continue;
            int index = cookies[i].indexOf("=");
            id = cookies[i].substring(index + 1);
            break;
        }
        return id;
    }

    private boolean thereIsNoArgumentNullOrEmpty(String ... args) {
        for (String arg : args) {
            if (!StringUtils.isNullOrEmpty(arg)) continue;
            return false;
        }
        return true;
    }

    private String removeLastSemicolon(StringBuilder sb) {
        String result = sb.toString();
        int indexOf = result.lastIndexOf(";");
        if (indexOf > 0) {
            result = result.substring(0, indexOf);
        }
        return result;
    }

    private JSONObject removeIcon(JSONObject jobJSON) {
        if (jobJSON != null) {
            JSONArray extArr;
            JSONObject applicationJSONObject = (JSONObject)jobJSON.get((Object)"application");
            if (applicationJSONObject != null) {
                applicationJSONObject.remove((Object)"icon");
            }
            if ((extArr = (JSONArray)jobJSON.get((Object)EXTRA_APPS)) != null) {
                for (JSONObject extAppJSONObject : extArr) {
                    extAppJSONObject.remove((Object)"icon");
                }
            }
        }
        return jobJSON;
    }

    public Map<String, String> initHeaders(AuthModel authModel, JSONObject loginJson) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (loginJson != null) {
            String hp4mSecret = loginJson.getAsString("x-hp4msecret");
            ArrayList<String> args = new ArrayList<String>();
            args.add(hp4mSecret);
            String oauth2 = "";
            String jSessionId = "";
            if (TOKEN.equals(authModel.getValue())) {
                oauth2 = loginJson.getAsString("OAUTH2_COOKIE_KEY");
                if (StringUtils.isNullOrEmpty(oauth2)) {
                    System.out.println("ERROR:: loginToMC failed with null oauth cookie.");
                    return null;
                }
                args.add(oauth2);
            } else {
                jSessionId = loginJson.getAsString("JSESSIONID");
                if (!StringUtils.isNullOrEmpty(jSessionId)) {
                    args.add(jSessionId);
                }
            }
            if (this.thereIsNoArgumentNullOrEmpty(args.toArray(new String[0]))) {
                headers.put("x-hp4msecret", hp4mSecret);
                if (TOKEN.equals(authModel.getValue())) {
                    headers.put("Cookie", String.format("%s=%s;", "OAUTH2_COOKIE_KEY", oauth2));
                } else if (!StringUtils.isNullOrEmpty(jSessionId)) {
                    headers.put("Cookie", String.format("%s=%s;", "JSESSIONID", jSessionId));
                } else if (loginJson.containsKey((Object)"Cookies")) {
                    headers.put("Cookie", loginJson.getAsString("Cookies"));
                }
                return headers;
            }
        }
        return null;
    }

    private HttpResponse doPost(ProxySettings proxy, String url, Map<String, String> headers, JSONObject body) {
        return HttpUtils.doPost(HttpUtils.setProxyCfg(proxy.getFsProxyAddress(), proxy.getFsProxyUserName(), proxy.getFsProxyPassword()), url, headers, body.toJSONString().getBytes(), true);
    }
}

