/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.mc;

import com.microfocus.application.automation.tools.mc.HttpResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import org.apache.commons.lang.StringUtils;

public class HttpUtils {
    public static final String POST = "POST";
    public static final String GET = "GET";

    private HttpUtils() {
    }

    public static HttpResponse doPost(ProxyInfo proxyInfo, String url, Map<String, String> headers, byte[] data) {
        HttpResponse response = null;
        try {
            response = HttpUtils.doHttp(proxyInfo, POST, url, null, headers, data, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    public static HttpResponse doPost(ProxyInfo proxyInfo, String url, Map<String, String> headers, byte[] data, boolean useCookieManager) {
        HttpResponse response = null;
        try {
            response = HttpUtils.doHttp(proxyInfo, POST, url, null, headers, data, useCookieManager);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    public static HttpResponse doGet(ProxyInfo proxyInfo, String url, Map<String, String> headers, String queryString) {
        HttpResponse response = null;
        try {
            response = HttpUtils.doHttp(proxyInfo, GET, url, queryString, headers, null, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    private static HttpResponse doHttp(ProxyInfo proxyInfo, String requestMethod, String connectionUrl, String queryString, Map<String, String> headers, byte[] data, boolean useCookieManager) throws IOException {
        HttpResponse response = new HttpResponse();
        if (queryString != null && !queryString.isEmpty()) {
            connectionUrl = (String)connectionUrl + "?" + queryString;
        }
        URL url = new URL((String)connectionUrl);
        CookieManager cookieManager = null;
        if (useCookieManager) {
            cookieManager = new CookieManager();
            CookieHandler.setDefault(cookieManager);
        }
        HttpURLConnection connection = (HttpURLConnection)HttpUtils.openConnection(proxyInfo, url);
        connection.setRequestMethod(requestMethod);
        HttpUtils.setConnectionHeaders(connection, headers);
        if (data != null && data.length > 0) {
            connection.setDoOutput(true);
            try {
                OutputStream out = connection.getOutputStream();
                out.write(data);
                out.flush();
                out.close();
            }
            catch (Throwable cause) {
                cause.printStackTrace();
            }
        }
        connection.connect();
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            InputStream inputStream = connection.getInputStream();
            Object object = HttpUtils.convertStreamToObject(inputStream);
            response.setHeaders(connection.getHeaderFields());
            if (null == object) {
                System.out.println(requestMethod + " " + (String)connectionUrl + " return is null.");
            } else if (object instanceof JSONObject) {
                response.setJsonObject((JSONObject)object);
            } else if (object instanceof JSONArray) {
                response.setJsonArray((JSONArray)object);
            } else if (object instanceof Boolean) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((Object)"error", (Object)((Boolean)object == false ? 1 : 0));
                response.setJsonObject(jsonObject);
            }
            if (useCookieManager) {
                response.setCookiesString(HttpUtils.getCookiesString(cookieManager));
            }
        } else {
            System.out.println(requestMethod + " " + (String)connectionUrl + " failed with response code:" + responseCode);
        }
        connection.disconnect();
        return response;
    }

    private static String getCookiesString(CookieManager cookieManager) {
        StringBuilder ret = new StringBuilder();
        if (cookieManager != null) {
            List<HttpCookie> cookies = cookieManager.getCookieStore().getCookies();
            for (HttpCookie cookie : cookies) {
                ret.append(cookie.getName()).append("=").append(cookie.getValue()).append(";");
            }
        }
        return ret.toString();
    }

    private static URLConnection openConnection(final ProxyInfo proxyInfo, URL _url) throws IOException {
        Proxy proxy = null;
        if (proxyInfo != null && !proxyInfo.isEmpty()) {
            try {
                int port = Integer.parseInt(proxyInfo.port.trim());
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyInfo.host, port));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (proxy != null && !proxyInfo.isEmpty()) {
            Authenticator authenticator = new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxyInfo.userName, proxyInfo.password.toCharArray());
                }
            };
            Authenticator.setDefault(authenticator);
        }
        if (proxy == null) {
            return _url.openConnection();
        }
        return _url.openConnection(proxy);
    }

    private static void setConnectionHeaders(HttpURLConnection connection, Map<String, String> headers) {
        if (connection != null && headers != null && headers.size() != 0) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                connection.setRequestProperty(header.getKey(), header.getValue());
            }
        }
    }

    private static Object convertStreamToObject(InputStream inputStream) {
        Object obj = null;
        if (inputStream != null) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuffer res = new StringBuffer();
                while ((line = reader.readLine()) != null) {
                    res.append(line);
                }
                obj = JSONValue.parseStrict((String)res.toString());
            }
            catch (ClassCastException e) {
                System.out.println("WARN::INVALIDE JSON Object" + e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    public static ProxyInfo setProxyCfg(String host, String port, String userName, String password) {
        return new ProxyInfo(host, port, userName, password);
    }

    public static ProxyInfo setProxyCfg(String host, String port) {
        ProxyInfo proxyInfo = new ProxyInfo();
        proxyInfo.host = host;
        proxyInfo.port = port;
        return proxyInfo;
    }

    public static ProxyInfo setProxyCfg(String address, String userName, String password) {
        ProxyInfo proxyInfo = new ProxyInfo();
        if (address != null) {
            int index;
            if (address.endsWith("/")) {
                int end = address.lastIndexOf("/");
                address = address.substring(0, end);
            }
            if ((index = address.lastIndexOf(58)) > 0) {
                proxyInfo.host = address.substring(0, index);
                proxyInfo.port = address.substring(index + 1, address.length());
            } else {
                proxyInfo.host = address;
                proxyInfo.port = "80";
            }
        }
        proxyInfo.userName = userName;
        proxyInfo.password = password;
        return proxyInfo;
    }

    static class ProxyInfo {
        String host;
        String port;
        String userName;
        String password;

        public ProxyInfo() {
        }

        public ProxyInfo(String host, String port, String userName, String password) {
            this.host = host;
            this.port = port;
            this.userName = userName;
            this.password = password;
        }

        public boolean isEmpty() {
            return StringUtils.isEmpty((String)this.host) || StringUtils.isEmpty((String)this.port) || StringUtils.isEmpty((String)this.userName) || StringUtils.isEmpty((String)this.password);
        }
    }
}

