/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.lr.run;

import com.microfocus.application.automation.tools.common.model.HealthAnalyzerModel;
import com.microfocus.application.automation.tools.common.model.VariableListWrapper;
import com.microfocus.application.automation.tools.common.model.VariableWrapper;
import com.microfocus.application.automation.tools.common.utils.HealthAnalyzerCommon;
import com.microfocus.application.automation.tools.common.utils.OperatingSystem;
import com.microfocus.application.automation.tools.lr.Messages;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.DataBoundConstructor;

public class HealthAnalyzerLrStep
extends HealthAnalyzerModel {
    private static final String LR_REGISTRY_PATH = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Wow6432Node\\Mercury Interactive\\LoadRunner\\CurrentVersion";
    private static final transient HealthAnalyzerCommon healthAnalyzerCommon = new HealthAnalyzerCommon(Messages.ProductName());
    private final boolean checkLrInstallation;
    private final boolean checkOsVersion;
    private final VariableListWrapper checkFiles;

    @DataBoundConstructor
    public HealthAnalyzerLrStep(boolean checkLrInstallation, boolean checkOsVersion, VariableListWrapper checkFiles) {
        this.checkLrInstallation = checkLrInstallation;
        this.checkOsVersion = checkOsVersion;
        this.checkFiles = checkFiles;
    }

    public boolean isCheckOsVersion() {
        return this.checkOsVersion;
    }

    public VariableListWrapper getCheckFiles() {
        return this.checkFiles;
    }

    public boolean isFilesExist() {
        return this.checkFiles != null;
    }

    public List<VariableWrapper> getFilesList() {
        return this.checkFiles != null ? this.checkFiles.getFilesList() : null;
    }

    public boolean isCheckLrInstallation() {
        return this.checkLrInstallation;
    }

    @Override
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        healthAnalyzerCommon.ifCheckedPerformWindowsInstallationCheck(LR_REGISTRY_PATH, this.checkLrInstallation, workspace);
        healthAnalyzerCommon.ifCheckedPerformFilesExistenceCheck(this.getFilesList(), this.isFilesExist(), workspace);
        healthAnalyzerCommon.ifCheckedPerformOsCheck(OperatingSystem.WINDOWS, this.checkOsVersion, workspace);
    }

    @Extension
    public static class DescriptorImpl
    extends HealthAnalyzerModel.HealthAnalyzerModelDescriptor {
        @Override
        public String toString() {
            return "Info in DescriptorImpl at HealthAnalyzerLrStep";
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.ProductName();
        }
    }
}

