/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.lr.model;

import com.microfocus.application.automation.tools.lr.Messages;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SummaryDataLogModel
extends AbstractDescribableImpl<SummaryDataLogModel> {
    private boolean logVusersStates;
    private boolean logErrorCount;
    private boolean logTransactionStatistics;
    private String pollingInterval;

    @DataBoundConstructor
    public SummaryDataLogModel(boolean logVusersStates, boolean logErrorCount, boolean logTransactionStatistics, String pollingInterval) {
        this.logVusersStates = logVusersStates;
        this.logErrorCount = logErrorCount;
        this.logTransactionStatistics = logTransactionStatistics;
        this.pollingInterval = pollingInterval;
    }

    public boolean getLogVusersStates() {
        return this.logVusersStates;
    }

    public boolean getLogErrorCount() {
        return this.logErrorCount;
    }

    public boolean getLogTransactionStatistics() {
        return this.logTransactionStatistics;
    }

    public String getPollingInterval() {
        return this.pollingInterval;
    }

    public void addToProps(Properties props) {
        if (StringUtils.isEmpty((String)this.pollingInterval)) {
            this.pollingInterval = "30";
        }
        props.put("SummaryDataLog", BooleanUtils.toInteger((boolean)this.logVusersStates) + ";" + BooleanUtils.toInteger((boolean)this.logErrorCount) + ";" + BooleanUtils.toInteger((boolean)this.logTransactionStatistics) + ";" + Integer.parseInt(this.pollingInterval));
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<SummaryDataLogModel> {
        @Nonnull
        public String getDisplayName() {
            return Messages.SummaryDataLogModel();
        }

        public FormValidation doCheckPollingInterval(@QueryParameter String value) {
            if (!StringUtils.isNumeric((String)value)) {
                return FormValidation.error((String)"Polling Interval must be a number");
            }
            return FormValidation.ok();
        }
    }
}

