/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.lr.model;

import com.microfocus.application.automation.tools.lr.Messages;
import com.microfocus.application.automation.tools.lr.model.AdditionalAttributeModel;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class ScriptRTSModel
extends AbstractDescribableImpl<ScriptRTSModel> {
    private String scriptName;
    private List<AdditionalAttributeModel> additionalAttributes;
    static int additionalAttributeCounter = 1;

    @DataBoundConstructor
    public ScriptRTSModel(String scriptName, List<AdditionalAttributeModel> additionalAttributes) {
        this.scriptName = scriptName;
        this.additionalAttributes = additionalAttributes;
    }

    public List<AdditionalAttributeModel> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    void addAdditionalAttributesToPropsFile(Properties props, String scriptName, EnvVars envVars) {
        for (AdditionalAttributeModel additionalAttribute : this.additionalAttributes) {
            if (StringUtils.isEmpty((String)additionalAttribute.getName())) continue;
            props.put("AdditionalAttribute" + additionalAttributeCounter, scriptName + ";" + additionalAttribute.getName() + ";" + envVars.expand(additionalAttribute.getValue()) + ";" + additionalAttribute.getDescription());
            ++additionalAttributeCounter;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ScriptRTSModel> {
        @Nonnull
        public String getDisplayName() {
            return Messages.ScriptRTSModel();
        }
    }
}

