/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.commonResultUpload.xmlreader.configloader;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.microfocus.application.automation.tools.commonResultUpload.CommonUploadLogger;
import com.microfocus.application.automation.tools.commonResultUpload.service.CustomizationService;
import com.microfocus.application.automation.tools.commonResultUpload.xmlreader.model.EntitiesFieldMap;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EntitiesFieldMapLoader {
    private static final String ILLEGAL = "Illegal ";
    private static final String[] TEST_SET_REQUIRED_FIELDS = new String[]{"root", "name", "subtype-id"};
    private static final String[] RUN_REQUIRED_FIELDS = new String[]{"root"};
    private static String[] testRquiredFields;
    private static Set<String> exceptionalFields;

    private EntitiesFieldMapLoader() {
    }

    public static EntitiesFieldMap load(String yamlContent, CommonUploadLogger logger, CustomizationService cs, boolean isCreateNewTest) {
        testRquiredFields = isCreateNewTest ? new String[]{"root", "name", "subtype-id"} : new String[]{"root", "subtype-id"};
        return EntitiesFieldMapLoader.load(yamlContent, logger, cs);
    }

    public static EntitiesFieldMap load(String yamlContent, CommonUploadLogger logger, CustomizationService cs) {
        EntitiesFieldMap entitiesFieldMap;
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            entitiesFieldMap = (EntitiesFieldMap)mapper.readValue(yamlContent, EntitiesFieldMap.class);
        }
        catch (IOException | RuntimeException e) {
            logger.error("Field mapping is not in right format. " + e.getMessage());
            return null;
        }
        if (!EntitiesFieldMapLoader.validateFieldMapping(entitiesFieldMap, logger, cs)) {
            return null;
        }
        return entitiesFieldMap;
    }

    private static boolean validateFieldMapping(EntitiesFieldMap entitiesFieldMap, CommonUploadLogger logger, CustomizationService cs) {
        if (!EntitiesFieldMapLoader.checkRequiredFields(entitiesFieldMap, logger)) {
            return false;
        }
        if (!EntitiesFieldMapLoader.checkEntitiesFieldName(cs, entitiesFieldMap, logger)) {
            return false;
        }
        return EntitiesFieldMapLoader.checkEntitiesSubtype(cs, entitiesFieldMap, logger);
    }

    private static boolean checkEntitiesSubtype(CustomizationService cs, EntitiesFieldMap entitiesFieldMap, CommonUploadLogger logger) {
        if (!EntitiesFieldMapLoader.checkSubtypeIdLlegal(cs, entitiesFieldMap.getTestset(), "test-set", logger)) {
            return false;
        }
        return EntitiesFieldMapLoader.checkSubtypeIdLlegal(cs, entitiesFieldMap.getTest(), "test", logger);
    }

    private static boolean checkSubtypeIdLlegal(CustomizationService cs, Map<String, String> fieldMap, String entityName, CommonUploadLogger logger) {
        Map<String, String> subtypeMap;
        String subtypeId = fieldMap.get("subtype-id");
        if (!EntitiesFieldMapLoader.containsValue(subtypeId = subtypeId.substring(2, subtypeId.length()), subtypeMap = cs.getEntitySubTypes(entityName))) {
            logger.error(ILLEGAL + entityName + " subtype-id: " + subtypeId);
            return false;
        }
        return true;
    }

    private static boolean checkRequiredFields(EntitiesFieldMap entitiesFieldMap, CommonUploadLogger logger) {
        for (String field : TEST_SET_REQUIRED_FIELDS) {
            if (entitiesFieldMap.getTestset().containsKey(field)) continue;
            logger.error(field + " should be set in test-set's field mapping.");
            return false;
        }
        for (String field : testRquiredFields) {
            if (entitiesFieldMap.getTest().containsKey(field)) continue;
            logger.error(field + " should be set in test's field mapping.");
            return false;
        }
        for (String field : RUN_REQUIRED_FIELDS) {
            if (entitiesFieldMap.getRun().containsKey(field)) continue;
            logger.error(field + " should be set in run's field mapping.");
            return false;
        }
        return true;
    }

    private static boolean checkEntitiesFieldName(CustomizationService cs, EntitiesFieldMap entitiesFieldMap, CommonUploadLogger logger) {
        if (!EntitiesFieldMapLoader.checkFieldNameLegal(cs, "test-set", entitiesFieldMap.getTestset(), logger)) {
            return false;
        }
        if (!EntitiesFieldMapLoader.checkFieldNameLegal(cs, "test", entitiesFieldMap.getTest(), logger)) {
            return false;
        }
        return EntitiesFieldMapLoader.checkFieldNameLegal(cs, "run", entitiesFieldMap.getRun(), logger);
    }

    private static boolean checkFieldNameLegal(CustomizationService cs, String entityName, Map<String, String> fieldMap, CommonUploadLogger logger) {
        Map<String, String> entityFields = cs.getEntityFields(entityName);
        for (String fieldName : fieldMap.keySet()) {
            String label;
            if (!(EntitiesFieldMapLoader.containsValue(fieldName, entityFields) || fieldName.equals("root") || fieldName.contains("|") || EntitiesFieldMapLoader.isExceptionalFields(fieldName))) {
                logger.error(ILLEGAL + entityName + " field name: " + fieldName);
                return false;
            }
            if (!fieldName.startsWith("udf|") || entityFields.containsKey(label = fieldName.substring(fieldName.indexOf("udf|") + "udf|".length()))) continue;
            logger.error(ILLEGAL + entityName + " label: " + fieldName);
            return false;
        }
        return true;
    }

    private static boolean isExceptionalFields(String filedName) {
        return exceptionalFields.contains(filedName);
    }

    private static boolean containsValue(String value, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            if (!value.equals(map.get(key))) continue;
            return true;
        }
        return false;
    }

    static {
        exceptionalFields = new HashSet<String>();
        exceptionalFields.add("stepMessage");
        exceptionalFields.add("stepRegEx");
    }
}

