/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.commonResultUpload.xmlreader;

import com.microfocus.application.automation.tools.commonResultUpload.xmlreader.ValueTranslator;
import com.microfocus.application.automation.tools.commonResultUpload.xmlreader.XpathReader;
import com.microfocus.application.automation.tools.commonResultUpload.xmlreader.model.EntitiesFieldMap;
import com.microfocus.application.automation.tools.commonResultUpload.xmlreader.model.XmlResultEntity;
import hudson.FilePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TestSetReader {
    private XpathReader xr;
    private ValueTranslator translator;
    private EntitiesFieldMap entitiesFieldMap;
    private static final String ROOT = "root";

    public TestSetReader(FilePath filePath, EntitiesFieldMap entitiesFieldMap) throws IOException, ParserConfigurationException, InterruptedException, SAXException {
        this.xr = new XpathReader(filePath);
        this.translator = new ValueTranslator(this.xr);
        this.entitiesFieldMap = entitiesFieldMap;
    }

    public TestSetReader(String resultPath, EntitiesFieldMap entitiesFieldMap) throws IOException, SAXException, ParserConfigurationException {
        this.xr = new XpathReader(resultPath);
        this.translator = new ValueTranslator(this.xr);
        this.entitiesFieldMap = entitiesFieldMap;
    }

    public List<XmlResultEntity> readTestsets() throws XPathExpressionException {
        List<XmlResultEntity> testsets = this.readEntities(this.entitiesFieldMap.getTestset(), this.xr.getDoc());
        return testsets;
    }

    private List<XmlResultEntity> readEntities(Map<String, String> configMap, Node node) throws XPathExpressionException {
        String rootXpath = configMap.get(ROOT);
        rootXpath = rootXpath.substring(2, rootXpath.length());
        NodeList nodes = this.xr.getNodeListFromNode(rootXpath, node);
        ArrayList<XmlResultEntity> entities = new ArrayList<XmlResultEntity>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            XmlResultEntity entity = new XmlResultEntity();
            Node currentNode = nodes.item(i);
            HashMap<String, String> fieldsMap = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : configMap.entrySet()) {
                String fieldName = entry.getKey();
                String fieldValue = configMap.get(fieldName);
                if (ROOT.equals(fieldName)) continue;
                fieldValue = this.translator.translate(fieldValue, currentNode);
                fieldsMap.put(fieldName, fieldValue);
            }
            entity.setValueMap(fieldsMap);
            Map<String, String> nextConfigMap = this.entitiesFieldMap.getNextConfigMap(configMap);
            if (nextConfigMap != null) {
                List<XmlResultEntity> subEntities = this.readEntities(nextConfigMap, currentNode);
                entity.setSubEntities(subEntities);
            }
            entities.add(entity);
        }
        return entities;
    }
}

