/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.commonResultUpload.uploader;

import com.microfocus.application.automation.tools.commonResultUpload.CommonUploadLogger;
import com.microfocus.application.automation.tools.commonResultUpload.service.CustomizationService;
import com.microfocus.application.automation.tools.commonResultUpload.service.FolderService;
import com.microfocus.application.automation.tools.commonResultUpload.service.RestService;
import com.microfocus.application.automation.tools.commonResultUpload.service.UDFTranslator;
import com.microfocus.application.automation.tools.commonResultUpload.service.VersionControlService;
import com.microfocus.application.automation.tools.commonResultUpload.uploader.RunUploader;
import com.microfocus.application.automation.tools.commonResultUpload.uploader.TestInstanceUploader;
import com.microfocus.application.automation.tools.commonResultUpload.uploader.TestSetUploader;
import com.microfocus.application.automation.tools.commonResultUpload.uploader.TestUploader;
import com.microfocus.application.automation.tools.commonResultUpload.xmlreader.XmlReader;
import com.microfocus.application.automation.tools.commonResultUpload.xmlreader.configloader.EntitiesFieldMapLoader;
import com.microfocus.application.automation.tools.commonResultUpload.xmlreader.configloader.RunStatusMapLoader;
import com.microfocus.application.automation.tools.commonResultUpload.xmlreader.model.EntitiesFieldMap;
import com.microfocus.application.automation.tools.commonResultUpload.xmlreader.model.RunStatusMap;
import com.microfocus.application.automation.tools.commonResultUpload.xmlreader.model.XmlResultEntity;
import com.microfocus.application.automation.tools.rest.RestClient;
import com.microfocus.application.automation.tools.results.service.AlmRestTool;
import com.microfocus.application.automation.tools.results.service.AttachmentUploadService;
import com.microfocus.application.automation.tools.sse.sdk.Logger;
import com.microfocus.application.automation.tools.sse.sdk.authenticator.AuthenticationTool;
import hudson.FilePath;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Uploader {
    private RestClient restClient;
    private Map<String, String> params;
    private CommonUploadLogger logger;
    private CustomizationService cs;
    private VersionControlService vs;
    private UDFTranslator udt;
    private RestService rs;
    private FolderService fs;
    private Run<?, ?> run;
    private FilePath workspace;

    public Uploader(Run<?, ?> run, FilePath workspace, CommonUploadLogger logger, Map<String, String> params) {
        this.run = run;
        this.workspace = workspace;
        this.logger = logger;
        this.params = params;
    }

    public void upload() {
        this.restClient = new RestClient(this.params.get("almServerUrl"), this.params.get("almDomain"), this.params.get("almProject"), this.params.get("username"));
        boolean login = AuthenticationTool.getInstance().authenticate(this.restClient, this.params.get("username"), this.params.get("password"), this.params.get("almServerUrl"), this.params.get("clientType"), this.logger);
        if (login) {
            this.init();
            if (!this.rs.getDomains().contains(this.params.get("almDomain"))) {
                this.logger.error("Invalid domain name:" + this.params.get("almDomain"));
                return;
            }
            if (!this.rs.getProjects(this.params.get("almDomain")).contains(this.params.get("almProject"))) {
                this.logger.error("Invalid project name:" + this.params.get("almProject"));
                return;
            }
            List<XmlResultEntity> xmlResultEntities = this.getUploadData();
            if (xmlResultEntities == null || xmlResultEntities.size() == 0) {
                return;
            }
            TestSetUploader testSetUploader = this.getTestSetUploader();
            if (testSetUploader == null) {
                return;
            }
            AlmRestTool almRestTool = new AlmRestTool(this.restClient, (Logger)this.logger);
            this.params.put("actualUser", almRestTool.getActualUsername());
            testSetUploader.upload(xmlResultEntities);
        } else {
            this.logger.error("Login failed.");
        }
    }

    private void init() {
        this.cs = new CustomizationService(this.restClient, this.logger);
        this.vs = new VersionControlService(this.restClient, this.logger);
        this.udt = new UDFTranslator(this.cs, this.logger);
        this.rs = new RestService(this.restClient, this.logger, this.udt);
        this.fs = new FolderService(this.rs);
        AttachmentUploadService.init(this.run, this.workspace, this.restClient, this.logger);
    }

    private TestSetUploader getTestSetUploader() {
        RunStatusMap runStatusMap = RunStatusMapLoader.load(this.params.get("runStatusMapping"), this.logger);
        if (runStatusMap == null) {
            return null;
        }
        RunUploader runu = new RunUploader(this.logger, this.params, this.rs, this.cs, runStatusMap.getStatus());
        TestInstanceUploader tiu = new TestInstanceUploader(this.logger, this.params, this.rs, runu, this.cs);
        TestUploader testu = new TestUploader(this.logger, this.params, this.rs, this.fs, tiu, this.cs, this.vs);
        return new TestSetUploader(this.logger, this.params, this.rs, this.fs, testu);
    }

    private List<XmlResultEntity> getUploadData() {
        List<XmlResultEntity> xmlResultEntities = new ArrayList<XmlResultEntity>();
        EntitiesFieldMap entitiesFieldMap = EntitiesFieldMapLoader.load(this.params.get("fieldMapping"), this.logger, this.cs, "true".equals(this.params.get("createNewTest")));
        if (entitiesFieldMap == null) {
            return xmlResultEntities;
        }
        XmlReader xmlReader = new XmlReader(this.run, this.workspace, this.logger);
        xmlResultEntities = xmlReader.scan(this.params.get("testingResultFile"), entitiesFieldMap);
        if (xmlResultEntities == null || xmlResultEntities.size() == 0) {
            this.logger.error("No test result content is found.");
        }
        return xmlResultEntities;
    }
}

