/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.commonResultUpload.uploader;

import com.microfocus.application.automation.tools.commonResultUpload.CommonUploadLogger;
import com.microfocus.application.automation.tools.commonResultUpload.service.FolderService;
import com.microfocus.application.automation.tools.commonResultUpload.service.RestService;
import com.microfocus.application.automation.tools.commonResultUpload.uploader.TestUploader;
import com.microfocus.application.automation.tools.commonResultUpload.xmlreader.model.XmlResultEntity;
import com.microfocus.application.automation.tools.results.service.AttachmentUploadService;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TestSetUploader {
    public static final String TEST_SET_REST_PREFIX = "test-sets";
    private static final String TEST_SET_FOLDERS_REST_PREFIX = "test-set-folders";
    private Map<String, String> params;
    private CommonUploadLogger logger;
    private RestService restService;
    private FolderService folderService;
    private TestUploader testuploader;

    public TestSetUploader(CommonUploadLogger logger, Map<String, String> params, RestService restService, FolderService folderService, TestUploader testuploader) {
        this.logger = logger;
        this.params = params;
        this.restService = restService;
        this.folderService = folderService;
        this.testuploader = testuploader;
    }

    public void upload(List<XmlResultEntity> xmlResultEntities) {
        this.logger.info("Test set upload start.");
        Map<String, String> folder = this.createOrFindTestsetFolder();
        for (XmlResultEntity xmlResultEntity : xmlResultEntities) {
            Map<String, String> testset = xmlResultEntity.getValueMap();
            Map<String, String> existTestset = this.folderService.findEntityInFolder(folder, testset, TEST_SET_REST_PREFIX, TEST_SET_FOLDERS_REST_PREFIX, new String[]{"id", "name", "subtype-id"});
            this.uploadOrUpdateTestset(existTestset, testset, xmlResultEntity);
        }
    }

    private boolean uploadOrUpdateTestset(Map<String, String> existTestset, Map<String, String> testset, XmlResultEntity xmlResultEntity) {
        String attachment = testset.get("attachment");
        testset.remove("attachment");
        Map<String, String> newTestset = existTestset != null ? existTestset : this.restService.create(TEST_SET_REST_PREFIX, testset);
        if (newTestset == null) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)attachment)) {
            AttachmentUploadService.getInstance().upload(attachment, TEST_SET_REST_PREFIX, newTestset.get("id"));
        }
        this.testuploader.upload(newTestset, xmlResultEntity.getSubEntities());
        return true;
    }

    private Map<String, String> createOrFindTestsetFolder() {
        if (!StringUtils.isEmpty((String)this.params.get("almTestSetFolder"))) {
            return this.folderService.createOrFindPath(TEST_SET_FOLDERS_REST_PREFIX, "0", this.params.get("almTestSetFolder"));
        }
        return null;
    }
}

