/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.commonResultUpload.uploader;

import com.microfocus.application.automation.tools.commonResultUpload.CommonUploadLogger;
import com.microfocus.application.automation.tools.commonResultUpload.service.CustomizationService;
import com.microfocus.application.automation.tools.commonResultUpload.service.RestService;
import com.microfocus.application.automation.tools.commonResultUpload.service.RunStatusResolver;
import com.microfocus.application.automation.tools.commonResultUpload.uploader.StepBean;
import com.microfocus.application.automation.tools.commonResultUpload.uploader.TestUploader;
import com.microfocus.application.automation.tools.commonResultUpload.uploader.UploaderHelper;
import com.microfocus.application.automation.tools.commonResultUpload.xmlreader.configloader.RunStatusMapLoader;
import com.microfocus.application.automation.tools.results.service.AttachmentUploadService;
import com.microfocus.application.automation.tools.sse.sdk.Base64Encoder;
import java.sql.Date;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class RunUploader {
    public static final String RUN_PREFIX = "runs";
    public static final String RUN_STEP_PREFIX = "run-steps";
    public static final String DESSTEP_REST_PREFIX = "design-steps";
    private static final String RUN_VERSION_MAP_NAME = "udf|Run On Version";
    private static final String VC_VERSION_NUMBER = "vc-version-number";
    private CommonUploadLogger logger;
    private Map<String, String> params;
    private Map<String, String> runStatusMapping;
    private RestService restService;
    private CustomizationService customizationService;

    public RunUploader(CommonUploadLogger logger, Map<String, String> params, RestService restService, CustomizationService customizationService, Map<String, String> runStatusMapping) {
        this.logger = logger;
        this.params = params;
        this.restService = restService;
        this.customizationService = customizationService;
        this.runStatusMapping = runStatusMapping;
    }

    public void upload(Map<String, String> testset, Map<String, String> test, Map<String, String> testconfig, Map<String, String> testinstance, Map<String, String> run, boolean isCreateDesStep) {
        Object query;
        List<Map<String, String>> steps;
        String attachment = run.get("attachment");
        run.remove("attachment");
        boolean containsStep = false;
        if (run.containsKey("stepMessage")) {
            containsStep = true;
        }
        String stepMessage = run.get("stepMessage");
        run.remove("stepMessage");
        String stepRegEx = run.get("stepRegEx");
        run.remove("stepRegEx");
        run.put("test-config-id", testconfig.get("id"));
        run.put("cycle-id", testset.get("id"));
        run.put("test-id", test.get("id"));
        run.put("testcycl-id", testinstance.get("id"));
        run.put("owner", this.params.get("actualUser"));
        run.put("name", this.generateImportRunName());
        run.put("duration", this.convertDuration(run.get("duration")));
        run.put("subtype-id", this.customizationService.getRunSubtypeIdByTestInstance(testinstance.get("subtype-id")));
        if (StringUtils.isNotEmpty((String)run.get("detail"))) {
            run.put("detail", this.convertDetail(run.get("detail")));
        }
        if (!this.shouldProceedVersionForRun(test, run)) {
            return;
        }
        if (isCreateDesStep && (steps = this.restService.get(null, DESSTEP_REST_PREFIX, (String)(query = String.format("fields=id,name&query={parent-id[%s]}", test.get("id"))))) != null && steps.size() > 0) {
            ArrayList<String> ids = new ArrayList<String>();
            for (Map<String, String> step : steps) {
                ids.add(step.get("id"));
            }
            query = "ids-to-delete=" + String.join((CharSequence)",", ids);
            this.restService.bulkDelete(DESSTEP_REST_PREFIX, (String)query);
        }
        String runstatus = RunStatusResolver.getRunStatus(run.get("status"), this.runStatusMapping);
        String runId = null;
        if (StringUtils.isNotEmpty((String)runstatus)) {
            run.remove("status");
            createdRun = this.restService.create(RUN_PREFIX, run);
            runId = createdRun.get("id");
            HashMap<String, String> updateRun = new HashMap<String, String>();
            updateRun.put("id", createdRun.get("id"));
            updateRun.put("status", runstatus);
            Map<String, String> updateResult = this.restService.update(RUN_PREFIX, updateRun);
            if (updateResult == null) {
                for (int i = 0; i < 3 && updateResult == null; ++i) {
                    updateResult = this.restService.update(RUN_PREFIX, updateRun);
                }
            }
            if (StringUtils.isNotEmpty((String)attachment) && updateResult != null) {
                AttachmentUploadService.getInstance().upload(attachment, RUN_PREFIX, updateResult.get("id"));
            }
        } else {
            createdRun = this.restService.create(RUN_PREFIX, run);
            runId = createdRun.get("id");
            if (StringUtils.isNotEmpty((String)attachment)) {
                AttachmentUploadService.getInstance().upload(attachment, RUN_PREFIX, createdRun.get("id"));
            }
        }
        if (containsStep) {
            Map<String, String> stepStatus = RunStatusMapLoader.load(this.params.get("runStatusMapping"), this.logger).getStepStatus();
            if (stepStatus == null || stepStatus.size() == 0) {
                throw new RuntimeException("Please configure 'stepstatus' mapping.");
            }
            if (StringUtils.isEmpty((String)stepRegEx)) {
                throw new RuntimeException("Please configure 'stepRegEx' mapping.");
            }
            List<StepBean> stepBeans = new UploaderHelper(stepMessage, stepRegEx, stepStatus).parseMessage();
            if (stepBeans == null || stepBeans.size() == 0) {
                this.logger.info("No any new run steps to be detected.");
            } else {
                this.restService.bulkCreate(RUN_STEP_PREFIX, this.buildRunStepBody(stepBeans, runId));
                if (isCreateDesStep) {
                    this.restService.bulkCreate(DESSTEP_REST_PREFIX, this.buildDesStepBody(stepBeans, test.get("id")));
                }
            }
        }
    }

    private Map<String, Map<String, String>> buildDesStepBody(List<StepBean> stepBeans, String testId) {
        LinkedHashMap<String, Map<String, String>> stepBody = new LinkedHashMap<String, Map<String, String>>();
        for (StepBean stepBean : stepBeans) {
            HashMap<String, Object> step = new HashMap<String, Object>();
            step.put("step-order", "" + stepBean.getOrder());
            step.put("name", "Step " + stepBean.getOrder());
            step.put("parent-id", testId);
            step.put("expected", "n/a");
            step.put("description", stepBean.getStepName());
            stepBody.put(stepBean.getStepName(), step);
        }
        return stepBody;
    }

    private Map<String, Map<String, String>> buildRunStepBody(List<StepBean> stepBeans, String runId) {
        LinkedHashMap<String, Map<String, String>> stepBody = new LinkedHashMap<String, Map<String, String>>();
        for (StepBean stepBean : stepBeans) {
            HashMap<String, Object> step = new HashMap<String, Object>();
            step.put("step-order", "" + stepBean.getOrder());
            step.put("name", "Step " + stepBean.getOrder());
            step.put("parent-id", runId);
            step.put("expected", "n/a");
            step.put("description", stepBean.getStepName());
            step.put("status", stepBean.getStatus());
            step.put("actual", this.escapeHTML(stepBean.getActualValue()));
            stepBody.put(stepBean.getStepName(), step);
        }
        return stepBody;
    }

    private String escapeHTML(String actualValue) {
        if (StringUtils.isEmpty((String)actualValue)) {
            return "";
        }
        actualValue = StringEscapeUtils.escapeHtml((String)actualValue);
        String[] lines = actualValue.split("(\\r?\\n)");
        StringBuilder htmlBodyBuilder = new StringBuilder();
        for (String line : lines) {
            String replacedLine = line.replaceAll(" ", "&nbsp;");
            htmlBodyBuilder.append(this.generateHtmlBody(replacedLine));
        }
        return "<html>\n<body>\n" + String.valueOf(htmlBodyBuilder) + "</body>\n</html>";
    }

    private String generateHtmlBody(String body) {
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append("<div align=\"left\" style=\"min-height: 9pt;\">");
        htmlBuilder.append("<font face=\"Arial\">");
        htmlBuilder.append("<span dir=\"ltr\" style=\"font-size:8pt;\">");
        htmlBuilder.append(body);
        htmlBuilder.append("</span>");
        htmlBuilder.append("</font>");
        htmlBuilder.append("</div>");
        htmlBuilder.append("\n");
        return htmlBuilder.toString();
    }

    private String convertDetail(String detail) {
        if (StringUtils.isNotEmpty((String)detail)) {
            detail = detail.replaceAll("<", "&lt;");
            detail = detail.replaceAll(">", "&gt;");
            return Base64Encoder.encode(detail.getBytes());
        }
        return detail;
    }

    private String convertDuration(String duration) {
        if (duration != null && duration.length() > 0) {
            Float durationTime = Float.valueOf(0.0f);
            try {
                durationTime = Float.valueOf(duration);
            }
            catch (NumberFormatException e) {
                return String.valueOf(0);
            }
            return String.valueOf(durationTime.intValue());
        }
        return String.valueOf(0);
    }

    private String generateImportRunName() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(System.currentTimeMillis()));
        return String.format("Import_Run_%d-%d_%d-%d-%d", cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13));
    }

    private boolean shouldProceedVersionForRun(Map<String, String> test, Map<String, String> run) {
        for (String noVersionTest : TestUploader.NO_VERSION_TESTS) {
            if (!test.get("subtype-id").equals(noVersionTest)) continue;
            return true;
        }
        boolean shouldProceed = true;
        boolean versioningEnabled = this.customizationService.isVersioningEnabled("test");
        if (versioningEnabled && run.containsKey(RUN_VERSION_MAP_NAME) && StringUtils.isNotEmpty((String)test.get(VC_VERSION_NUMBER))) {
            if (StringUtils.isEmpty((String)run.get(RUN_VERSION_MAP_NAME))) {
                run.put(RUN_VERSION_MAP_NAME, test.get(VC_VERSION_NUMBER));
                this.logger.info("Run on version not found. Set it as the latest test version.");
            } else {
                try {
                    int testLatestVersion = Integer.parseInt(test.get(VC_VERSION_NUMBER));
                    int runVersion = Integer.parseInt(run.get(RUN_VERSION_MAP_NAME));
                    if (runVersion > testLatestVersion) {
                        this.logger.error("Run version larger than test latest version.");
                        shouldProceed = false;
                    }
                    if (runVersion < 1) {
                        run.put(RUN_VERSION_MAP_NAME, "1");
                        this.logger.info("Run on version is " + runVersion + ". Minimum version should be 1. Set it to 1.");
                    }
                }
                catch (NumberFormatException e) {
                    this.logger.error("Version number illegal. " + e.getMessage());
                    shouldProceed = false;
                }
            }
        }
        return shouldProceed;
    }
}

