/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.commonResultUpload.service;

import com.microfocus.application.automation.tools.results.service.almentities.IAlmConsts;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public final class RunStatusResolver {
    private static Set<String> operators = new HashSet<String>();
    private static Set<String> ALM_STATUS = new HashSet<String>();

    private RunStatusResolver() {
    }

    public static String getRunStatus(String status, Map<String, String> runStatusMapping) {
        String passCondition = null;
        String failedCondition = null;
        boolean containsOperator = false;
        for (Map.Entry<String, String> entry : runStatusMapping.entrySet()) {
            if (RunStatusResolver.containsOperator(entry.getKey())) {
                containsOperator = true;
                if (IAlmConsts.IStatuses.PASSED.value().equalsIgnoreCase(entry.getValue())) {
                    passCondition = entry.getKey();
                    break;
                }
                if (IAlmConsts.IStatuses.FAILED.value().equalsIgnoreCase(entry.getValue())) {
                    failedCondition = entry.getKey();
                    break;
                }
            }
            if (!RunStatusResolver.containsOperator(entry.getValue())) continue;
            containsOperator = true;
            if (IAlmConsts.IStatuses.PASSED.value().equalsIgnoreCase(entry.getKey())) {
                passCondition = entry.getValue();
                break;
            }
            if (!IAlmConsts.IStatuses.FAILED.value().equalsIgnoreCase(entry.getKey())) continue;
            failedCondition = entry.getValue();
            break;
        }
        if (containsOperator) {
            if (!StringUtils.isEmpty(passCondition)) {
                return RunStatusResolver.resolveCondition(status, passCondition) ? IAlmConsts.IStatuses.PASSED.value() : IAlmConsts.IStatuses.FAILED.value();
            }
            if (!StringUtils.isEmpty(failedCondition)) {
                return RunStatusResolver.resolveCondition(status, failedCondition) ? IAlmConsts.IStatuses.FAILED.value() : IAlmConsts.IStatuses.PASSED.value();
            }
            throw new RuntimeException("Run Status is not configured correctly.");
        }
        if (StringUtils.isEmpty((String)status)) {
            throw new RuntimeException("The value of 'status' is null or empty.");
        }
        if (runStatusMapping.get(status) == null || !ALM_STATUS.contains(runStatusMapping.get(status))) {
            throw new RuntimeException("'" + status + "' is not configured correctly in Run Status Mapping.");
        }
        return runStatusMapping.get(status);
    }

    private static boolean containsOperator(String mapping) {
        for (String operator : operators) {
            if (!mapping.startsWith(operator)) continue;
            return true;
        }
        return false;
    }

    private static boolean resolveCondition(String statusValue, String condition) {
        String mark = condition.substring(0, 2);
        String conditionValue = condition.substring(2);
        if (conditionValue.equals("NULL")) {
            switch (mark) {
                case "==": {
                    return StringUtils.isEmpty((String)statusValue);
                }
                case "!=": {
                    return !StringUtils.isEmpty((String)statusValue);
                }
            }
            throw new IllegalArgumentException("Condition mark is incorrect for run status NULL.");
        }
        if (!operators.contains(mark)) {
            throw new IllegalArgumentException("Condition mark is incorrect.");
        }
        if (!(mark.equals("==") || mark.equals("!=") || RunStatusResolver.isNumeric(conditionValue) && RunStatusResolver.isNumeric(statusValue))) {
            throw new IllegalArgumentException("'" + statusValue + "' or '" + conditionValue + "' is not numerical.");
        }
        switch (mark) {
            case "==": {
                if (RunStatusResolver.isNumeric(conditionValue) && RunStatusResolver.isNumeric(statusValue)) {
                    return Double.parseDouble(statusValue) == Double.parseDouble(conditionValue);
                }
                return statusValue.equals(conditionValue);
            }
            case "!=": {
                if (RunStatusResolver.isNumeric(conditionValue) && RunStatusResolver.isNumeric(statusValue)) {
                    return Double.parseDouble(statusValue) != Double.parseDouble(conditionValue);
                }
                return !statusValue.equals(conditionValue);
            }
            case ">>": {
                return Double.parseDouble(statusValue) > Double.parseDouble(conditionValue);
            }
            case ">=": {
                return Double.parseDouble(statusValue) >= Double.parseDouble(conditionValue);
            }
            case "<<": {
                return Double.parseDouble(statusValue) < Double.parseDouble(conditionValue);
            }
            case "<=": {
                return Double.parseDouble(statusValue) <= Double.parseDouble(conditionValue);
            }
        }
        throw new IllegalArgumentException("Condition mark is incorrect.");
    }

    private static boolean isNumeric(String strNum) {
        Pattern pattern = Pattern.compile("-?\\d+(\\.\\d+)?");
        if (strNum == null) {
            return false;
        }
        return pattern.matcher(strNum).matches();
    }

    static {
        operators.add("==");
        operators.add("!=");
        operators.add(">>");
        operators.add(">=");
        operators.add("<<");
        operators.add("<=");
        ALM_STATUS.add("No Run");
        ALM_STATUS.add("Passed");
        ALM_STATUS.add("Failed");
        ALM_STATUS.add("Blocked");
        ALM_STATUS.add("Not Completed");
    }
}

