/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.commonResultUpload.service;

import com.microfocus.application.automation.tools.common.SSEException;
import com.microfocus.application.automation.tools.commonResultUpload.CommonUploadLogger;
import com.microfocus.application.automation.tools.commonResultUpload.rest.CreateAlmEntityEntityRequest;
import com.microfocus.application.automation.tools.commonResultUpload.rest.GetAlmEntityRequest;
import com.microfocus.application.automation.tools.commonResultUpload.rest.UpdateAlmEntityEntityRequest;
import com.microfocus.application.automation.tools.commonResultUpload.service.UDFTranslator;
import com.microfocus.application.automation.tools.rest.RestClient;
import com.microfocus.application.automation.tools.sse.common.XPathUtils;
import com.microfocus.application.automation.tools.sse.sdk.ResourceAccessLevel;
import com.microfocus.application.automation.tools.sse.sdk.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class RestService {
    private RestClient restClient;
    private CreateAlmEntityEntityRequest createAlmEntityRequest;
    private GetAlmEntityRequest getAlmEntityRequest;
    private UpdateAlmEntityEntityRequest updateAlmEntityRequest;
    private UDFTranslator udt;
    private CommonUploadLogger logger;

    public RestService(RestClient restClient, CommonUploadLogger logger, UDFTranslator udt) {
        this.restClient = restClient;
        this.logger = logger;
        this.createAlmEntityRequest = new CreateAlmEntityEntityRequest(restClient, logger);
        this.getAlmEntityRequest = new GetAlmEntityRequest(restClient, logger);
        this.updateAlmEntityRequest = new UpdateAlmEntityEntityRequest(restClient, logger);
        this.udt = udt;
    }

    public Map<String, String> create(String restPrefix, Map<String, String> valueMap) {
        this.udt.translate(restPrefix, valueMap);
        return this.createAlmEntityRequest.perform(restPrefix, valueMap);
    }

    public Map<String, Map<String, String>> bulkCreate(String restPrefix, Map<String, Map<String, String>> valueMap) {
        return this.createAlmEntityRequest.bulkCreate(restPrefix, valueMap);
    }

    public Response bulkDelete(String restPrefix, String queryString) {
        String url = this.restClient.buildRestRequest(restPrefix);
        Response response = this.restClient.httpDelete(url, queryString, this.getHeaders(), ResourceAccessLevel.PROTECTED);
        return this.handleBulkResult(response);
    }

    private Response handleBulkResult(Response response) {
        if (response.getFailure() != null) {
            throw new RuntimeException("Got invalid response from Server, see details: [" + response.toString() + "]");
        }
        return null;
    }

    protected Map<String, String> getHeaders() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("Content-Type", "application/xml;type=collection");
        ret.put("Accept", "application/xml");
        ret.put("X-XSRF-TOKEN", this.restClient.getXsrfTokenValue());
        return ret;
    }

    public List<Map<String, String>> get(String id, String restPrefix, String queryString) {
        return this.getAlmEntityRequest.perform(id, restPrefix, queryString);
    }

    public Map<String, String> update(String restPrefix, Map<String, String> valueMap) {
        this.udt.translate(restPrefix, valueMap);
        return this.updateAlmEntityRequest.perform(restPrefix, valueMap);
    }

    public List<String> getDomains() {
        String url = this.restClient.getServerUrl();
        if (!url.endsWith("/")) {
            url = String.format("%s/", url);
        }
        url = String.format("%s%s/domains", url, "rest");
        return this.getDomainOrProjectListFromResponse("Domain", url);
    }

    public List<String> getProjects(String domain) {
        String url = this.restClient.getServerUrl();
        if (!url.endsWith("/")) {
            url = String.format("%s/", url);
        }
        url = String.format("%s%s/domains/%s/projects", url, "rest", domain);
        return this.getDomainOrProjectListFromResponse("Project", url);
    }

    private List<String> getDomainOrProjectListFromResponse(String dopo, String url) {
        Response response = this.restClient.httpGet(url, null, null, ResourceAccessLevel.PROTECTED);
        ArrayList<String> list = new ArrayList<String>();
        if (response.isOk() && !response.toString().equals("")) {
            Document document = null;
            try {
                document = XPathUtils.getDocument(response.toString());
            }
            catch (SSEException e) {
                this.logger.error("Get xml document failed: " + e.getMessage());
                this.logger.error("Please check ALM server's status.");
            }
            if (document != null) {
                NodeList domainList = document.getElementsByTagName(dopo);
                for (int i = 0; i < domainList.getLength(); ++i) {
                    String project = domainList.item(i).getAttributes().getNamedItem("Name").getTextContent();
                    list.add(project);
                }
            } else {
                this.logger.error("Cannot get any content from response while getting " + dopo);
            }
        } else {
            this.logger.error("Get " + dopo + "s failed from: " + url);
            this.logger.error(response.getFailure().toString());
        }
        return list;
    }
}

