/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.commonResultUpload.service;

import com.microfocus.application.automation.tools.commonResultUpload.service.CriteriaTranslator;
import com.microfocus.application.automation.tools.commonResultUpload.service.RestService;
import com.microfocus.application.automation.tools.results.service.AlmRestTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class FolderService {
    private static final String FOLDER_SEPERATOR = "\\";
    private RestService restService;

    public FolderService(RestService restService) {
        this.restService = restService;
    }

    public Map<String, String> createOrFindPath(String prefix, String parentId, String path) {
        ArrayList<Map<String, String>> folders = new ArrayList<Map<String, String>>();
        StringTokenizer tokenizer = new StringTokenizer(path, FOLDER_SEPERATOR);
        while (tokenizer.hasMoreTokens()) {
            String itemString = tokenizer.nextToken();
            Map<String, String> folder = this.createFolder(prefix, parentId, itemString);
            if (folder == null) continue;
            folders.add(folder);
            parentId = folder.get("id");
        }
        if (folders.size() > 0) {
            return (Map)folders.get(folders.size() - 1);
        }
        return null;
    }

    public Map<String, String> createFolder(String prefix, String parentId, String folderName) {
        Map<String, String> existsFolder = this.checkFolderExits(prefix, parentId, folderName);
        if (existsFolder == null) {
            existsFolder = new HashMap<String, String>();
            existsFolder.put("parent-id", parentId);
            existsFolder.put("name", folderName);
            return this.restService.create(prefix, existsFolder);
        }
        return existsFolder;
    }

    public Map<String, String> checkFolderExits(String prefix, String parentId, String folderName) {
        String query = String.format("fields=id,name&query={parent-id[%s];name[%s]}", parentId, AlmRestTool.getEncodedString(folderName));
        List<Map<String, String>> entities = this.restService.get(null, prefix, query);
        if (entities.size() > 0) {
            return entities.get(0);
        }
        return null;
    }

    public List<Map<String, String>> getSubFolders(String prefix, String parentFolderId) {
        String query = String.format("fields=id,name&query={parent-id[%s]}", parentFolderId);
        return this.restService.get(null, prefix, query);
    }

    public Map<String, String> findEntityInFolder(Map<String, String> testFolder, Map<String, String> test, String entityPrefix, String folderPrefix, String[] queryFields) {
        ArrayList<Map<String, String>> foundTests = new ArrayList<Map<String, String>>();
        test.put("q|parent-id", testFolder.get("id"));
        if (test.get("q|id") == null || test.get("q|id").isEmpty()) {
            test.put("q|name", test.get("name"));
        }
        this.findEntityInFolderAndSub(foundTests, test, entityPrefix, folderPrefix, queryFields);
        return foundTests.size() > 0 ? (Map)foundTests.get(0) : null;
    }

    private void findEntityInFolderAndSub(List<Map<String, String>> foundTests, Map<String, String> test, String entityPrefix, String folderPrefix, String[] queryFields) {
        List<Map<String, String>> existTests = this.restService.get(null, entityPrefix, CriteriaTranslator.getCriteriaString(queryFields, test));
        if (existTests == null || existTests.size() == 0) {
            List<Map<String, String>> subFolders = this.getSubFolders(folderPrefix, test.get("parent-id"));
            if (subFolders != null) {
                for (Map<String, String> subfolder : subFolders) {
                    test.put("q|parent-id", subfolder.get("id"));
                    test.put("q|name", test.get("name"));
                    this.findEntityInFolderAndSub(foundTests, test, entityPrefix, folderPrefix, queryFields);
                }
            }
        } else {
            foundTests.addAll(existTests);
        }
    }
}

