/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.commonResultUpload.service;

import com.microfocus.application.automation.tools.commonResultUpload.CommonUploadLogger;
import com.microfocus.application.automation.tools.rest.RestClient;
import com.microfocus.application.automation.tools.sse.common.XPathUtils;
import com.microfocus.application.automation.tools.sse.sdk.ResourceAccessLevel;
import com.microfocus.application.automation.tools.sse.sdk.Response;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CustomizationService {
    public static final String RUN_ENTITY_NAME = "run";
    public static final String TEST_INSTANCE_ENTITY_NAME = "test-instance";
    public static final String TEST_ENTITY_NAME = "test";
    public static final String TEST_SET_ENTITY_NAME = "test-set";
    private RestClient client;
    private CommonUploadLogger logger;
    private Map<String, Map<String, String>> subtypeCache;
    private Map<String, Map<String, String>> fieldCache;

    public CustomizationService(RestClient client, CommonUploadLogger logger) {
        this.client = client;
        this.logger = logger;
        this.subtypeCache = new HashMap<String, Map<String, String>>();
        this.fieldCache = new HashMap<String, Map<String, String>>();
    }

    public String getRunSubtypeIdByTestInstance(String testInstanceSubtypeId) {
        return this.getSubtypeIdByName(RUN_ENTITY_NAME, this.getSubtypeNameById(TEST_INSTANCE_ENTITY_NAME, testInstanceSubtypeId));
    }

    public String getTestInstanceSubtypeIdByTest(String testSubtypeId) {
        return this.getSubtypeIdByName(TEST_INSTANCE_ENTITY_NAME, this.getSubtypeNameById(TEST_ENTITY_NAME, testSubtypeId));
    }

    public String getSubtypeIdByName(String entityName, String subtypeName) {
        return this.getEntitySubTypes(entityName).get(subtypeName);
    }

    public String getSubtypeNameById(String entityName, String subtypeId) {
        for (Map.Entry<String, String> subtype : this.getEntitySubTypes(entityName).entrySet()) {
            if (!subtype.getValue().equals(subtypeId)) continue;
            return subtype.getKey();
        }
        return null;
    }

    public Map<String, String> getEntitySubTypes(String entityName) {
        if (this.subtypeCache.get(entityName) == null) {
            String suffix = String.format("customization/entities/%s/types", entityName);
            String url = this.client.buildRestRequest(suffix);
            Response response = this.client.httpGet(url, null, null, ResourceAccessLevel.PROTECTED);
            if (response.isOk() && !response.toString().equals("")) {
                this.logger.info(String.format("Get customization entity subtypes success. [%s]", entityName));
                Map<String, String> customizationMap = XPathUtils.getEntitySubtypesMap(response.toString());
                this.subtypeCache.put(entityName, customizationMap);
                return customizationMap;
            }
            this.logger.error("Get customization entity subtypes failed from: " + url);
            this.logger.error(response.getFailure().toString());
            return null;
        }
        return this.subtypeCache.get(entityName);
    }

    public String getUDFNameByLabel(String entityName, String label) {
        return this.getEntityFields(entityName).get(label);
    }

    public Map<String, String> getEntityFields(String entityName) {
        if (this.fieldCache.get(entityName) == null) {
            String suffix = String.format("customization/entities/%s/fields", entityName);
            String url = this.client.buildRestRequest(suffix);
            Response response = this.client.httpGet(url, null, null, ResourceAccessLevel.PROTECTED);
            if (response.isOk() && !response.toString().equals("")) {
                this.logger.info(String.format("Get customization entity fields success. [%s]", entityName));
                Map<String, String> entityFieldsMap = XPathUtils.getEntityFieldsMap(response.toString());
                this.fieldCache.put(entityName, entityFieldsMap);
                return entityFieldsMap;
            }
            this.logger.error("Get customization entity fields failed from: " + url);
            this.logger.error(response.getFailure().toString());
            return null;
        }
        return this.fieldCache.get(entityName);
    }

    public boolean isVersioningEnabled(String entityName) {
        String suffix = String.format("customization/entities/%s", entityName);
        String url = this.client.buildRestRequest(suffix);
        Response response = this.client.httpGet(url, null, null, ResourceAccessLevel.PROTECTED);
        if (response.isOk() && !response.toString().equals("")) {
            this.logger.log(String.format("INFO: -- Get Entity Resource Descriptor success. [%s]", entityName));
            Document document = XPathUtils.getDocument(response.toString());
            Element element = (Element)document.getElementsByTagName("SupportsVC").item(0);
            return "true".equals(element.getTextContent());
        }
        this.logger.log("ERR: Get entities failed from: " + url);
        this.logger.log("ERR: " + String.valueOf(response.getFailure()));
        return false;
    }
}

