/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.commonResultUpload.rest;

import com.microfocus.application.automation.tools.commonResultUpload.CommonUploadLogger;
import com.microfocus.application.automation.tools.commonResultUpload.rest.BasicPostEntityRequest;
import com.microfocus.application.automation.tools.rest.RestClient;
import com.microfocus.application.automation.tools.sse.common.RestXmlUtils;
import com.microfocus.application.automation.tools.sse.sdk.ResourceAccessLevel;
import com.microfocus.application.automation.tools.sse.sdk.Response;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;

public class CreateAlmEntityEntityRequest
extends BasicPostEntityRequest {
    public CreateAlmEntityEntityRequest(RestClient client, CommonUploadLogger logger) {
        super(client, logger, "Create");
    }

    @Override
    public Map<String, String> perform(String restPrefix, Map<String, String> valueMap) {
        String url = this.client.buildRestRequest(restPrefix);
        Response response = this.client.httpPost(url, this.getDataBytes(valueMap), this.getHeaders(), ResourceAccessLevel.PROTECTED);
        return this.handleResult(response, valueMap, restPrefix);
    }

    @Override
    public Map<String, Map<String, String>> bulkCreate(String restPrefix, Map<String, Map<String, String>> valueMap) {
        String url = this.client.buildRestRequest(restPrefix);
        Map<String, String> headers = this.getHeaders();
        headers.put("Content-Type", "application/xml;type=collection");
        Response response = this.client.httpPost(url, this.getBulkDataBytes(valueMap), headers, ResourceAccessLevel.PROTECTED);
        return this.handleBulkResult(response);
    }

    private byte[] getBulkDataBytes(Map<String, Map<String, String>> valueMap) {
        StringBuilder builder = new StringBuilder("<Entities>");
        for (Map.Entry<String, Map<String, String>> entry : valueMap.entrySet()) {
            StringBuilder entityBuilder = new StringBuilder("<Entity><Fields>");
            for (Map.Entry<String, String> entity : entry.getValue().entrySet()) {
                entityBuilder.append(RestXmlUtils.fieldXml(entity.getKey(), StringEscapeUtils.escapeXml10((String)entity.getValue())));
            }
            entityBuilder.append("</Fields></Entity>");
            builder.append(entityBuilder.toString());
        }
        builder.append("</Entities>");
        this.logger.info("Request body: " + builder.toString());
        return builder.toString().getBytes();
    }

    private Map<String, Map<String, String>> handleBulkResult(Response response) {
        if (response.getFailure() != null) {
            throw new RuntimeException("Got invalid response from Server, see details: [" + response.toString() + "]");
        }
        return null;
    }
}

