/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.commonResultUpload;

import com.microfocus.application.automation.tools.sse.sdk.Logger;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class CommonUploadLogger
implements Logger {
    private static final String ERR_PREFIX = "ERR: ";
    private static final String INFO_PREFIX = "INFO: ";
    private static final String WARN_PREFIX = "WARN: ";
    private List<String> failedMessages;
    private PrintStream printStream;

    public CommonUploadLogger(PrintStream printStream) {
        this.printStream = printStream;
        this.failedMessages = new ArrayList<String>();
    }

    @Override
    public void error(String message) {
        this.failedMessages.add((String)message);
        message = ERR_PREFIX + (String)message;
        this.log((String)message);
    }

    public void info(String message) {
        message = INFO_PREFIX + (String)message;
        this.log((String)message);
    }

    public void warn(String message) {
        message = WARN_PREFIX + (String)message;
        this.log((String)message);
    }

    @Override
    public void log(String message) {
        if (this.printStream != null) {
            this.printStream.println(message);
        }
    }

    public List<String> getFailedMessages() {
        return this.failedMessages;
    }
}

