/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.commonResultUpload;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.cloudbees.plugins.credentials.matchers.IdMatcher;
import com.microfocus.application.automation.tools.Messages;
import com.microfocus.application.automation.tools.commonResultUpload.CommonUploadLogger;
import com.microfocus.application.automation.tools.commonResultUpload.uploader.Uploader;
import com.microfocus.application.automation.tools.model.AlmServerSettingsModel;
import com.microfocus.application.automation.tools.settings.AlmServerSettingsGlobalConfiguration;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.VariableResolver;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CommonResultUploadBuilder
extends Recorder
implements SimpleBuildStep {
    private String almServerName;
    private String credentialsId;
    private String almDomain;
    private String clientType;
    private String almProject;
    private String almTestFolder;
    private String almTestSetFolder;
    private String testingResultFile;
    private String runStatusMapping;
    private String fieldMapping;
    private boolean createNewTest;
    private boolean updateDesSteps;

    @DataBoundConstructor
    public CommonResultUploadBuilder(String almServerName, String credentialsId, String almDomain, String clientType, String almProject, String almTestFolder, String almTestSetFolder, String testingResultFile, String runStatusMapping, String fieldMapping, boolean createNewTest, boolean updateDesSteps) {
        this.almServerName = almServerName;
        this.credentialsId = credentialsId;
        this.almDomain = almDomain;
        this.clientType = clientType;
        this.almProject = almProject;
        this.almTestFolder = almTestFolder;
        this.almTestSetFolder = almTestSetFolder;
        this.testingResultFile = testingResultFile;
        this.runStatusMapping = runStatusMapping;
        this.fieldMapping = fieldMapping;
        this.createNewTest = createNewTest;
        this.updateDesSteps = updateDesSteps;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        CommonUploadLogger logger = new CommonUploadLogger(taskListener.getLogger());
        UsernamePasswordCredentials credentials = this.getCredentialsById(this.credentialsId, run);
        if (credentials == null) {
            logger.warn("Can not find credentials with the credentialsId:" + this.credentialsId);
            run.setResult(Result.ABORTED);
            return;
        }
        VariableResolver.ByMap varResolver = new VariableResolver.ByMap((Map)run.getEnvironment(taskListener));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("almServerName", this.almServerName);
        params.put("almServerUrl", this.getAlmServerUrl(this.almServerName));
        params.put("username", credentials.getUsername());
        params.put("password", credentials.getPassword().getPlainText());
        params.put("almDomain", Util.replaceMacro((String)this.almDomain, (VariableResolver)varResolver));
        params.put("clientType", this.clientType);
        params.put("almProject", Util.replaceMacro((String)this.almProject, (VariableResolver)varResolver));
        params.put("almTestFolder", Util.replaceMacro((String)this.almTestFolder, (VariableResolver)varResolver));
        params.put("almTestSetFolder", Util.replaceMacro((String)this.almTestSetFolder, (VariableResolver)varResolver));
        params.put("runStatusMapping", Util.replaceMacro((String)this.runStatusMapping, (VariableResolver)varResolver));
        params.put("testingResultFile", Util.replaceMacro((String)this.testingResultFile, (VariableResolver)varResolver));
        params.put("fieldMapping", Util.replaceMacro((String)this.fieldMapping, (VariableResolver)varResolver));
        params.put("createNewTest", String.valueOf(this.createNewTest));
        params.put("updateDesSteps", String.valueOf(this.updateDesSteps));
        Uploader uploader = new Uploader(run, workspace, logger, params);
        uploader.upload();
        if (logger.getFailedMessages().size() > 0) {
            logger.log("----------------------------------------------------------------");
            logger.log("Failed upload summary:");
            for (String failedMessage : logger.getFailedMessages()) {
                logger.log(failedMessage);
            }
            run.setResult(Result.UNSTABLE);
        }
    }

    private String getAlmServerUrl(String almServerName) {
        AlmServerSettingsModel[] almServers = AlmServerSettingsGlobalConfiguration.getInstance().getInstallations();
        if (almServers != null && almServers.length > 0) {
            for (AlmServerSettingsModel almServerModel : almServers) {
                if (!almServerName.equalsIgnoreCase(almServerModel.getAlmServerName())) continue;
                return almServerModel.getAlmServerUrl();
            }
        }
        return "";
    }

    private UsernamePasswordCredentials getCredentialsById(String credentialsId, Run<?, ?> run) {
        UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)credentialsId, StandardUsernamePasswordCredentials.class, run, (List)URIRequirementBuilder.create().build());
        return credentials;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean isUpdateDesSteps() {
        return this.updateDesSteps;
    }

    public void setUpdateDesSteps(boolean updateDesSteps) {
        this.updateDesSteps = updateDesSteps;
    }

    public String getAlmServerName() {
        return this.almServerName;
    }

    public void setAlmServerName(String almServerName) {
        this.almServerName = almServerName;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getAlmDomain() {
        return this.almDomain;
    }

    public void setAlmDomain(String almDomain) {
        this.almDomain = almDomain;
    }

    public String getClientType() {
        return this.clientType;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public String getAlmProject() {
        return this.almProject;
    }

    public void setAlmProject(String almProject) {
        this.almProject = almProject;
    }

    public String getAlmTestFolder() {
        return this.almTestFolder;
    }

    public void setAlmTestFolder(String almTestFolder) {
        this.almTestFolder = almTestFolder;
    }

    public String getAlmTestSetFolder() {
        return this.almTestSetFolder;
    }

    public void setAlmTestSetFolder(String almTestSetFolder) {
        this.almTestSetFolder = almTestSetFolder;
    }

    public String getTestingResultFile() {
        return this.testingResultFile;
    }

    public void setTestingResultFile(String testingResultFile) {
        this.testingResultFile = testingResultFile;
    }

    public String getRunStatusMapping() {
        return this.runStatusMapping;
    }

    public void setRunStatusMapping(String runStatusMapping) {
        this.runStatusMapping = runStatusMapping;
    }

    public String getFieldMapping() {
        return this.fieldMapping;
    }

    public void setFieldMapping(String fieldMapping) {
        this.fieldMapping = fieldMapping;
    }

    public boolean isCreateNewTest() {
        return this.createNewTest;
    }

    public void setCreateNewTest(boolean createNewTest) {
        this.createNewTest = createNewTest;
    }

    @Extension
    @Symbol(value={"commonResultUploadBuilder"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.CommonResultUploadBuilderName();
        }

        public boolean hasAlmServers() {
            return AlmServerSettingsGlobalConfiguration.getInstance().hasAlmServers();
        }

        public AlmServerSettingsModel[] getAlmServers() {
            return AlmServerSettingsGlobalConfiguration.getInstance().getInstallations();
        }

        public FormValidation doCheckAlmUserName(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"User name must be set");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAlmDomain(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Domain must be set");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAlmProject(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Project must be set");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAlmTestFolder(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"TestFolder are missing");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAlmTestSetFolder(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"TestSetFolder are missing");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTestingResultFile(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Testing result file must be set");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project, @QueryParameter String credentialsId) {
            if (project == null || !project.hasPermission(Item.CONFIGURE)) {
                return new StandardUsernameListBoxModel().includeCurrentValue(credentialsId);
            }
            return new StandardUsernameListBoxModel().includeEmptyValue().includeAs(project instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM, project, StandardUsernamePasswordCredentials.class, URIRequirementBuilder.create().build()).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item project, @QueryParameter String value) {
            for (ListBoxModel.Option o : CredentialsProvider.listCredentials(StandardUsernamePasswordCredentials.class, (Item)project, (Authentication)(project instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM), (List)URIRequirementBuilder.create().build(), (CredentialsMatcher)new IdMatcher(value))) {
                if (!StringUtils.equals((String)value, (String)o.value)) continue;
                return FormValidation.ok();
            }
            return FormValidation.warning((String)("Cannot find any credentials with id " + value));
        }

        public String defaultFieldMapping() {
            return "testset:\n  root: \"x:/result/suites/suite\"\n  name: \"x:name\"\n  udf|duration: \"x:duration\"\n  udf|list: \"x:list\"\n  subtype-id: \"v:hp.qc.test-set.default\"\n  #subtype-id: \"v:hp.qc.test-set.default\"\n  #subtype-id: \"v:hp.qc.test-set.external\"\n  #subtype-id: \"v:hp.sse.test-set.process\"\ntest:\n  root: \"x:cases/case\"\n  name: \"x:testName|v:_|x:testId\" # Use \"|\" to create a combined value, e.g.: <testName element value>_<testId element value>\n  subtype-id: \"v:MANUAL\"\n  #subtype-id: \"v:SERVICE-TEST\"\n  #subtype-id: \"v:SYSTEM-TEST\"\n  #subtype-id: \"v:VAPI-XP-TEST\"\n  #subtype-id: \"v:ALT-SCENARIO\"\n  #subtype-id: \"v:BUSINESS-PROCESS\"\n  #subtype-id: \"v:FLOW\"\n  #subtype-id: \"v:LEANFT-TEST\"\n  #subtype-id: \"v:LR-SCENARIO\"\n  #subtype-id: \"v:QAINSPECT-TEST\"\nrun:\n  root: \"x:.\" # \".\" means the same XML object as defined above in 'test' entity, all elements defined below are searched from the same root element as 'test' root\n  #root: \"x:/result/suites/suite/cases/case\"\n  duration: \"x:duration\" # This system field is integer, if you want to save a float number, please create a string format UDF\n  status: \"x:status\"\n  udf|Run On Version: \"x:RunOnVersion\" # Create an UDF and set its label to \"run on version\", to trigger the versioning logic\n  udf|Date: \"2020-03-30\" # Date type field value should be in format \"yyyy-mm-dd\"\n";
        }

        public String defaultRunStatusMapping() {
            return "status:\n  Passed: \"==True\" # If status attribute is \"True\" in report, the run in ALM will be marked as \"Passed\". Else will be \"Failed\".\n  #Failed: \">=0\" # If status attribute value greater or equals than 0, then run in ALM will be marked as \"Failed\".  \n  #Passed condition and Failed condition are mutual exclusion.";
        }
    }
}

