/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.common.utils;

import java.util.Arrays;
import java.util.List;

public enum OperatingSystem {
    LINUX,
    WINDOWS,
    MAC;

    private static final List<String> POSIX_NAMES;
    private static String os;
    private static boolean windows;
    private static boolean mac;
    private static boolean linux;

    public static String getOs() {
        return os;
    }

    public static void refreshOsVariablesForSlave() {
        os = System.getProperty("os.name").toLowerCase();
        windows = os.contains(WINDOWS.name().toLowerCase());
        mac = os.contains(MAC.name().toLowerCase());
        linux = POSIX_NAMES.contains(os.toLowerCase());
    }

    public boolean equalsCurrentOs() {
        OperatingSystem.refreshOsVariablesForSlave();
        return linux || os.contains(this.name().toLowerCase());
    }

    public static boolean isWindows() {
        return windows;
    }

    public static boolean isMac() {
        return mac;
    }

    public static boolean isLinux() {
        return linux;
    }

    static {
        POSIX_NAMES = Arrays.asList("linux", "os/2", "irix", "hp-ux", "aix", "soalris", "sunos");
        os = System.getProperty("os.name").toLowerCase();
        windows = os.contains(WINDOWS.name().toLowerCase());
        mac = os.contains(MAC.name().toLowerCase());
        linux = POSIX_NAMES.contains(os.toLowerCase());
    }
}

