/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.common.utils;

import com.microfocus.application.automation.tools.common.Messages;
import com.microfocus.application.automation.tools.common.masterToSlave.FunctionFileCallable;
import com.microfocus.application.automation.tools.common.masterToSlave.SupplierFileCallable;
import com.microfocus.application.automation.tools.common.model.VariableWrapper;
import com.microfocus.application.automation.tools.common.utils.OperatingSystem;
import hudson.AbortException;
import hudson.FilePath;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class HealthAnalyzerCommon
implements Serializable {
    private static final String AN_EXCEPTION_WAS_THROWN = "An exception was thrown";
    private static final Logger logger = Logger.getLogger(HealthAnalyzerCommon.class.getName());
    private final String productName;

    public HealthAnalyzerCommon(@Nonnull String productName) {
        Objects.requireNonNull(productName, Messages.HealthAnalyzerCommon_productNameValueMustBeNotNull());
        this.productName = productName;
    }

    public void ifCheckedPerformWindowsInstallationCheck(@Nonnull String registryPath, boolean toCheck, FilePath workspace) throws IOException, InterruptedException {
        if (toCheck) {
            Objects.requireNonNull(registryPath, Messages.HealthAnalyzerCommon_registryValueMustBeNotNull());
            if (!this.isRegistryExistsOnSlave(registryPath, workspace)) {
                throw new AbortException(Messages.HealthAnalyzerCommon_notInstalled(this.productName));
            }
        }
    }

    public boolean isRegistryExistsOnSlave(@Nonnull String registryPath, FilePath workspace) throws InterruptedException {
        FunctionFileCallable<String, Boolean> callable = new FunctionFileCallable<String, Boolean>(this::isRegistryExist, registryPath);
        try {
            if (OperatingSystem.isWindows()) {
                return (Boolean)workspace.act(callable);
            }
            throw new AbortException(Messages.HealthAnalyzerCommon_registryWorksOnlyOnWindows());
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, AN_EXCEPTION_WAS_THROWN, e);
            return false;
        }
    }

    public boolean isRegistryExist(@Nonnull String registryPath) throws InterruptedException, AbortException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Callable<Boolean> task = () -> this.startRegistryQueryAndGetStatus(registryPath);
        Future<Boolean> future = executor.submit(task);
        executor.shutdown();
        executor.awaitTermination(500L, TimeUnit.MILLISECONDS);
        return this.getFutureResult(future);
    }

    private boolean getFutureResult(Future<Boolean> future) throws InterruptedException, AbortException {
        try {
            return future.isDone() && future.get() != false;
        }
        catch (ExecutionException e) {
            throw new AbortException("failed to get result from the thread to check if registry exist: " + e.getMessage());
        }
    }

    private boolean startRegistryQueryAndGetStatus(@Nonnull String registryPath) throws IOException {
        ProcessBuilder builder = new ProcessBuilder("reg", "query", registryPath);
        Process reg = builder.start();
        return this.isProcessStreamHasRegistry(reg);
    }

    private boolean isProcessStreamHasRegistry(@Nonnull Process reg) throws IOException {
        try (BufferedReader output = new BufferedReader(new InputStreamReader(reg.getInputStream()));){
            Stream<String> keys = output.lines().filter(l -> !l.isEmpty());
            boolean bl = keys.findFirst().isPresent();
            return bl;
        }
    }

    private boolean isFileExistOnSlave(@Nonnull String path, FilePath workspace) throws InterruptedException {
        FunctionFileCallable<String, Boolean> callable = new FunctionFileCallable<String, Boolean>(this::isFileExist, path);
        try {
            return (Boolean)workspace.act(callable);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, AN_EXCEPTION_WAS_THROWN, e);
            return false;
        }
    }

    public boolean isFileExist(String path) throws AbortException {
        if (path == null || path.isEmpty()) {
            return true;
        }
        File file = Paths.get(path, new String[0]).toFile();
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new AbortException(Messages.HealthAnalyzerCommon_isDirectory(path));
            }
            return file.isFile();
        }
        return false;
    }

    public void ifCheckedPerformFilesExistenceCheck(List<VariableWrapper> files, boolean toCheck, FilePath workspace) throws AbortException, InterruptedException {
        if (!toCheck || files == null || files.isEmpty()) {
            return;
        }
        for (VariableWrapper file : files) {
            if (this.isFileExistOnSlave(file.getField(), workspace)) continue;
            throw new AbortException(Messages.HealthAnalyzerCommon_fileNotExist(file.getField()));
        }
    }

    public void ifCheckedPerformOsCheck(OperatingSystem os, boolean toCheck, FilePath workspace) throws InterruptedException {
        SupplierFileCallable<Boolean> supplier = new SupplierFileCallable<Boolean>(os::equalsCurrentOs);
        try {
            if (toCheck && !((Boolean)workspace.act(supplier)).booleanValue()) {
                throw new AbortException(Messages.HealthAnalyzerCommon_operatingSystemIncorrect(os.toString().toLowerCase()));
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, AN_EXCEPTION_WAS_THROWN, e);
        }
    }
}

