/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.common.run;

import com.microfocus.application.automation.tools.common.Messages;
import com.microfocus.application.automation.tools.common.model.HealthAnalyzerModel;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class HealthAnalyzerBuilder
extends Builder
implements SimpleBuildStep {
    private final List<HealthAnalyzerModel> products;

    @DataBoundConstructor
    public HealthAnalyzerBuilder(List<HealthAnalyzerModel> products) {
        this.products = products;
    }

    public List<HealthAnalyzerModel> getProducts() {
        return this.products;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        for (HealthAnalyzerModel product : this.products) {
            product.perform(run, workspace, launcher, listener);
        }
    }

    @Extension
    @Symbol(value={"healthAnalyzer"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        @Nonnull
        public String getDisplayName() {
            return Messages.HealthAnalyzerBuilder_displayName(com.microfocus.application.automation.tools.Messages.CompanyName());
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public List<HealthAnalyzerModel.HealthAnalyzerModelDescriptor> getProducts() {
            return HealthAnalyzerModel.HealthAnalyzerModelDescriptor.all();
        }
    }
}

