/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.xpath.functions;

import javax.xml.transform.TransformerException;
import org.htmlunit.xpath.XPathContext;
import org.htmlunit.xpath.functions.Function3Args;
import org.htmlunit.xpath.functions.WrongNumberArgsException;
import org.htmlunit.xpath.objects.XObject;
import org.htmlunit.xpath.objects.XString;
import org.htmlunit.xpath.res.XPATHMessages;

public class FuncSubstring
extends Function3Args {
    @Override
    public XObject execute(XPathContext xctxt) throws TransformerException {
        XString substr;
        int startIndex;
        XString s1 = this.m_arg0.execute(xctxt).xstr();
        double start = this.m_arg1.execute(xctxt).num();
        int lenOfS1 = s1.length();
        if (lenOfS1 <= 0) {
            return XString.EMPTYSTRING;
        }
        if (Double.isNaN(start)) {
            start = -1000000.0;
            startIndex = 0;
        } else {
            int n = startIndex = (start = (double)Math.round(start)) > 0.0 ? (int)start - 1 : 0;
        }
        if (null != this.arg2_) {
            double len = this.arg2_.num(xctxt);
            if (len < 1.0) {
                return XString.EMPTYSTRING;
            }
            int end = (int)((double)Math.round(len) + start) - 1;
            if (end < 0) {
                end = 0;
            } else if (end > lenOfS1) {
                end = lenOfS1;
            }
            if (startIndex > lenOfS1) {
                startIndex = lenOfS1;
            }
            substr = s1.substring(startIndex, end);
        } else {
            if (startIndex > lenOfS1) {
                startIndex = lenOfS1;
            }
            substr = s1.substring(startIndex);
        }
        return substr;
    }

    @Override
    public void checkNumberArgs(int argNum) throws WrongNumberArgsException {
        if (argNum < 2) {
            this.reportWrongNumberArgs();
        }
    }

    @Override
    protected void reportWrongNumberArgs() throws WrongNumberArgsException {
        throw new WrongNumberArgsException(XPATHMessages.createXPATHMessage("ER_TWO_OR_THREE", null));
    }
}

