/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.dto.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum CIEventType {
    UNDEFINED("undefined"),
    QUEUED("queued"),
    STARTED("started"),
    FINISHED("finished"),
    SCM("scm"),
    DELETED("deleted"),
    REMOVED_FROM_QUEUE("removed_from_queue"),
    RENAMED("renamed"),
    CHANGE_EXEC_STATE("change_exec_state");

    private String value;

    private CIEventType(String value) {
        this.value = value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static CIEventType fromValue(String value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("value MUST NOT be null nor empty");
        }
        CIEventType result = UNDEFINED;
        for (CIEventType v : CIEventType.values()) {
            if (v.value.compareTo(value) != 0) continue;
            result = v;
            break;
        }
        return result;
    }
}

