/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.dto;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.hp.octane.integrations.dto.DTOBase;
import com.hp.octane.integrations.dto.DTOInternalProviderBase;
import com.hp.octane.integrations.dto.causes.impl.DTOCausesProvider;
import com.hp.octane.integrations.dto.configuration.impl.DTOConfigsProvider;
import com.hp.octane.integrations.dto.connectivity.impl.DTOConnectivityProvider;
import com.hp.octane.integrations.dto.coverage.impl.DTOCoverageProvider;
import com.hp.octane.integrations.dto.entities.impl.DTOEntityProvider;
import com.hp.octane.integrations.dto.events.impl.DTOEventsProvider;
import com.hp.octane.integrations.dto.executor.impl.DTOExecutorsProvider;
import com.hp.octane.integrations.dto.general.impl.DTOGeneralProvider;
import com.hp.octane.integrations.dto.parameters.impl.DTOParametersProvider;
import com.hp.octane.integrations.dto.pipelines.impl.DTOPipelinesProvider;
import com.hp.octane.integrations.dto.scm.impl.DTOSCMProvider;
import com.hp.octane.integrations.dto.securityscans.impl.DTOSecurityContextProvider;
import com.hp.octane.integrations.dto.tests.impl.DTOJUnitTestsProvider;
import com.hp.octane.integrations.dto.tests.impl.DTOTestsProvider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;

public final class DTOFactory {
    private static final DTOFactory instance = new DTOFactory();
    private final DTOConfiguration configuration = new DTOConfiguration();

    private DTOFactory() {
    }

    public static DTOFactory getInstance() {
        return instance;
    }

    public <T extends DTOBase> T newDTO(Class<T> targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("target type MUST NOT be null");
        }
        if (!targetType.isInterface()) {
            throw new IllegalArgumentException("target type MUST be an Interface");
        }
        if (!this.configuration.registry.containsKey(targetType)) {
            throw new IllegalArgumentException("requested type " + targetType + " is not supported");
        }
        try {
            return ((DTOInternalProviderBase)this.configuration.registry.get(targetType)).instantiateDTO(targetType);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("failed to instantiate " + targetType, ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("access denied to " + targetType, iae);
        }
    }

    public <T extends DTOBase> InputStream dtoToJsonStream(T dto) {
        return this.dtoToStream(dto, this.configuration.objectMapper);
    }

    public <T extends DTOBase> InputStream dtoToXmlStream(T dto) {
        return this.dtoToStream(dto, (ObjectMapper)this.configuration.getXmlMapper());
    }

    private <T extends DTOBase> InputStream dtoToStream(T dto, ObjectMapper objectMapper) {
        if (dto == null) {
            throw new IllegalArgumentException("dto MUST NOT be null");
        }
        try {
            return new ByteArrayInputStream(objectMapper.writeValueAsBytes(dto));
        }
        catch (JsonProcessingException jpe) {
            throw new RuntimeException("failed to serialize " + dto + " to JSON", jpe);
        }
    }

    public <T extends DTOBase> String dtoToJson(T dto) {
        return this.dtoToString(dto, this.configuration.objectMapper);
    }

    public <T extends DTOBase> String dtoToXml(T dto) {
        return this.dtoToString(dto, (ObjectMapper)this.configuration.getXmlMapper());
    }

    private <T extends DTOBase> String dtoToString(T dto, ObjectMapper objectMapper) {
        if (dto == null) {
            throw new IllegalArgumentException("dto MUST NOT be null");
        }
        try {
            return objectMapper.writeValueAsString(dto);
        }
        catch (JsonProcessingException jpe) {
            throw new RuntimeException("failed to serialize " + dto + " to JSON", jpe);
        }
    }

    public <T extends DTOBase> InputStream dtoCollectionToJsonStream(List<T> dto) {
        if (dto == null) {
            throw new IllegalArgumentException("dto MUST NOT be null");
        }
        try {
            return new ByteArrayInputStream(this.configuration.objectMapper.writeValueAsBytes(dto));
        }
        catch (JsonProcessingException jpe) {
            throw new RuntimeException("failed to serialize " + dto + " to JSON", jpe);
        }
    }

    public <T extends DTOBase> String dtoCollectionToJson(List<T> dto) {
        if (dto == null) {
            throw new IllegalArgumentException("dto MUST NOT be null");
        }
        try {
            return this.configuration.objectMapper.writeValueAsString(dto);
        }
        catch (JsonProcessingException jpe) {
            throw new RuntimeException("failed to serialize " + dto + " to JSON", jpe);
        }
    }

    public <T extends DTOBase> T dtoFromJson(String json, Class<T> targetType) {
        return this.dtoFromString(json, targetType, this.configuration.objectMapper);
    }

    public <T extends DTOBase> T dtoFromXml(String json, Class<T> targetType) {
        return this.dtoFromString(json, targetType, (ObjectMapper)this.configuration.getXmlMapper());
    }

    private <T extends DTOBase> T dtoFromString(String string, Class<T> targetType, ObjectMapper objectMapper) {
        if (targetType == null) {
            throw new IllegalArgumentException("target type MUST NOT be null");
        }
        if (!targetType.isInterface()) {
            throw new IllegalArgumentException("target type MUST be an Interface");
        }
        try {
            return (T)((DTOBase)objectMapper.readValue(string, targetType));
        }
        catch (IOException ioe) {
            throw new RuntimeException("failed to deserialize " + string + " into " + targetType, ioe);
        }
    }

    public <T extends DTOBase> T[] dtoCollectionFromJson(String json, Class<T[]> targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("target type MUST NOT be null");
        }
        if (!targetType.isArray()) {
            throw new IllegalArgumentException("target type MUST be an Array");
        }
        try {
            return (DTOBase[])this.configuration.objectMapper.readValue(json, targetType);
        }
        catch (IOException ioe) {
            throw new RuntimeException("failed to deserialize " + json + " into " + targetType, ioe);
        }
    }

    public <T extends DTOBase> T dtoFromJsonFile(File jsonFile, Class<T> targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("target type MUST NOT be null");
        }
        if (!targetType.isInterface()) {
            throw new IllegalArgumentException("target type MUST be an Interface");
        }
        try {
            return (T)((DTOBase)this.configuration.objectMapper.readValue(jsonFile, targetType));
        }
        catch (IOException ioe) {
            throw new RuntimeException("failed to deserialize " + jsonFile.getName() + " into " + targetType, ioe);
        }
    }

    public <T extends DTOBase> T dtoFromXmlFile(File xml, Class<T> targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("target type MUST NOT be null");
        }
        if (!targetType.isInterface()) {
            throw new IllegalArgumentException("target type MUST be an Interface");
        }
        try {
            return (T)((DTOBase)this.configuration.getXmlMapper().readValue(xml, targetType));
        }
        catch (IOException ioe) {
            throw new RuntimeException("failed to deserialize " + xml.getName() + " into " + targetType, ioe);
        }
    }

    public void initXmlMapper(XMLInputFactory xmlInputFactory, XMLOutputFactory xmlOutputFactory) {
        this.configuration.initXmlMapper(xmlInputFactory, xmlOutputFactory);
    }

    public XmlMapper getXMLMapper() {
        return this.configuration.getXmlMapper();
    }

    public static class DTOConfiguration {
        private final Map<Class<? extends DTOBase>, DTOInternalProviderBase> registry = new HashMap<Class<? extends DTOBase>, DTOInternalProviderBase>();
        private final ObjectMapper objectMapper = new ObjectMapper();
        private XmlMapper xmlMapper = null;
        private SimpleModule module;

        private DTOConfiguration() {
            LinkedList<DTOInternalProviderBase> providers = new LinkedList<DTOInternalProviderBase>();
            providers.add(new DTOCausesProvider(this));
            providers.add(new DTOConfigsProvider(this));
            providers.add(new DTOConnectivityProvider(this));
            providers.add(new DTOCoverageProvider(this));
            providers.add(new DTOEventsProvider(this));
            providers.add(new DTOGeneralProvider(this));
            providers.add(new DTOParametersProvider(this));
            providers.add(new DTOPipelinesProvider(this));
            providers.add(new DTOSCMProvider(this));
            providers.add(new DTOTestsProvider(this));
            providers.add(new DTOExecutorsProvider(this));
            providers.add(new DTOJUnitTestsProvider(this));
            providers.add(new DTOEntityProvider(this));
            providers.add(new DTOSecurityContextProvider(this));
            SimpleAbstractTypeResolver resolver = new SimpleAbstractTypeResolver();
            for (DTOInternalProviderBase dtoProvider : providers) {
                for (Map.Entry<Class<? extends DTOBase>, Class> dtoPair : dtoProvider.getDTOPairs().entrySet()) {
                    this.registry.put(dtoPair.getKey(), dtoProvider);
                    resolver.addMapping(dtoPair.getKey(), dtoPair.getValue());
                }
            }
            this.module = new SimpleModule();
            this.module.setAbstractTypes(resolver);
            this.objectMapper.registerModule((Module)this.module);
        }

        private void initXmlMapper(XmlMapper mapper) {
            this.xmlMapper = mapper;
            this.xmlMapper.registerModule((Module)this.module);
            this.xmlMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        }

        public void initXmlMapper(XMLInputFactory xmlInputFactory, XMLOutputFactory xmlOutputFactory) {
            this.initXmlMapper(new XmlMapper(xmlInputFactory, xmlOutputFactory));
        }

        public XmlMapper getXmlMapper() {
            if (this.xmlMapper == null) {
                this.initXmlMapper(new XmlMapper());
            }
            return this.xmlMapper;
        }
    }
}

