/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.uft.model;

import com.microfocus.application.automation.tools.EncryptionUtils;
import hudson.model.Node;
import hudson.util.Secret;
import org.apache.commons.lang.StringUtils;

public class UftRunAsUser {
    private String username;
    private String encodedPwd;
    private Secret pwd;

    public UftRunAsUser(String username, String encodedPwd) {
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException(String.format("%s is required", "UFT_RUN_AS_USER_NAME"));
        }
        if (StringUtils.isBlank((String)encodedPwd)) {
            throw new IllegalArgumentException(String.format("%s is required", "UFT_RUN_AS_USER_ENCODED_PASSWORD"));
        }
        this.username = username;
        this.encodedPwd = encodedPwd;
    }

    public UftRunAsUser(String username, Secret pwd) {
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException(String.format("%s is required", "UFT_RUN_AS_USER_NAME"));
        }
        if (pwd == null) {
            throw new IllegalArgumentException(String.format("%s is required", "UFT_RUN_AS_USER_PASSWORD"));
        }
        this.username = username;
        this.pwd = pwd;
    }

    public String getUsername() {
        return this.username;
    }

    public String getEncodedPassword() {
        return this.encodedPwd;
    }

    public String getEncodedPasswordAsEncrypted(Node node) throws EncryptionUtils.EncryptionException {
        return EncryptionUtils.encrypt(this.encodedPwd, node);
    }

    public Secret getPassword() {
        return this.pwd;
    }

    public String getPasswordAsEncrypted(Node node) throws EncryptionUtils.EncryptionException {
        return EncryptionUtils.encrypt(this.pwd.getPlainText(), node);
    }
}

