/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.sse.sdk;

import com.microfocus.application.automation.tools.common.SSEException;
import com.microfocus.application.automation.tools.rest.RestClient;
import com.microfocus.application.automation.tools.sse.common.StringUtils;
import com.microfocus.application.automation.tools.sse.common.XPathUtils;
import com.microfocus.application.automation.tools.sse.result.PublisherFactory;
import com.microfocus.application.automation.tools.sse.result.model.junit.Testsuites;
import com.microfocus.application.automation.tools.sse.sdk.Args;
import com.microfocus.application.automation.tools.sse.sdk.Client;
import com.microfocus.application.automation.tools.sse.sdk.Logger;
import com.microfocus.application.automation.tools.sse.sdk.Response;
import com.microfocus.application.automation.tools.sse.sdk.RunResponse;
import com.microfocus.application.automation.tools.sse.sdk.authenticator.AuthenticationTool;
import com.microfocus.application.automation.tools.sse.sdk.handler.PollHandler;
import com.microfocus.application.automation.tools.sse.sdk.handler.PollHandlerFactory;
import com.microfocus.application.automation.tools.sse.sdk.handler.RunHandler;
import com.microfocus.application.automation.tools.sse.sdk.handler.RunHandlerFactory;
import com.microfocus.application.automation.tools.sse.sdk.request.GetBvsRequest;
import com.microfocus.application.automation.tools.sse.sdk.request.GetBvsTestSetsRequest;
import com.microfocus.application.automation.tools.sse.sdk.request.GetTestInstancesRequest;
import com.microfocus.application.automation.tools.sse.sdk.request.GetTestSetRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class RunManager {
    private static final String BVS = "Business Verification Suite";
    private static final String TESTSET = "Test Set";
    private RunHandler _runHandler;
    private PollHandler _pollHandler;
    private Logger _logger;
    private boolean _running = false;
    private boolean _polling = false;

    public Testsuites execute(RestClient client, Args args, Logger logger) throws InterruptedException {
        Testsuites ret = null;
        this._logger = logger;
        this._running = true;
        if (AuthenticationTool.getInstance().authenticate(client, args.getUsername(), args.getPassword(), args.getUrl(), args.getClientType(), logger)) {
            this.initialize(args, client);
            if (this.isValidBvsOrTestSet(client, args) && this.start(args)) {
                this._polling = true;
                if (this.poll()) {
                    ret = new PublisherFactory().create(client, args.getRunType(), args.getEntityId(), this._runHandler.getRunId()).publish(this._runHandler.getNameSuffix(), args.getUrl(), args.getDomain(), args.getProject(), logger);
                }
                this._polling = false;
            } else {
                ret = new Testsuites();
                this.stop();
            }
        }
        return ret;
    }

    private boolean isValidBvsOrTestSet(RestClient client, Args args) {
        if (args.getRunType().equals("BVS")) {
            if (this.isExistingBvs(client, args)) {
                return this.isValidBvs(client, args);
            }
            this._logger.error(String.format("No %s could be found by ID %s!", BVS, args.getEntityId()));
        } else if (args.getRunType().equals("TEST_SET")) {
            if (this.isExistingTestSet(client, args)) {
                return this.hasTestInstances(client, args.getEntityId());
            }
            this._logger.error(String.format("No %s of Functional type could be found by ID %s! \nNote: You can run only functional test sets and build verification suites using this task. Check to make sure that the configured ID is valid (and that it is not a performance test ID).", TESTSET, args.getEntityId()));
        } else {
            this._logger.error("Unknown run type, please check the configuration.");
        }
        return false;
    }

    private boolean isExistingBvs(RestClient client, Args args) {
        Response res = new GetBvsRequest(client, args.getEntityId()).execute();
        return res != null && res.isOk() && res.getData() != null && XPathUtils.hasResults(res.toString());
    }

    private boolean isExistingTestSet(RestClient client, Args args) {
        Response res = new GetTestSetRequest(client, args.getEntityId()).execute();
        return res != null && res.isOk() && res.getData() != null && XPathUtils.hasResults(res.toString());
    }

    private boolean isValidBvs(RestClient client, Args args) {
        boolean ok;
        List<String> ids = this.getBvsTestSetsIds(client, args);
        boolean bl = ok = !ids.isEmpty();
        if (ok) {
            Response res = new GetTestInstancesRequest((Client)client, ids).execute();
            if (res != null && res.isOk() && res.getData() != null) {
                List<String> nonEmptyIds = XPathUtils.getTestSetIds(res.toString());
                ids.removeAll(nonEmptyIds);
                if (!ids.isEmpty()) {
                    ok = false;
                    this._logger.error(String.format("%s with ID %s is invalid, the following test sets contain no tests or are not type of functional: %s", BVS, args.getEntityId(), Arrays.toString(ids.toArray())));
                }
            } else {
                ok = false;
                this._logger.error(String.format("Cannot get the test sets of %s with ID %s!", BVS, args.getEntityId()));
            }
        } else {
            this._logger.error(String.format("%s with ID %s is empty or contains no test sets of type functional!", BVS, args.getEntityId()));
        }
        return ok;
    }

    private List<String> getBvsTestSetsIds(RestClient client, Args args) {
        Response res = new GetBvsTestSetsRequest(client, args.getEntityId()).execute();
        if (res == null || !res.isOk() || res.getData() == null) {
            return Collections.emptyList();
        }
        return XPathUtils.getTestSetIds(res.toString());
    }

    private boolean hasTestInstances(RestClient client, String id) {
        boolean ok;
        Response res = new GetTestInstancesRequest((Client)client, id).execute();
        boolean bl = ok = res.isOk() && res.getData() != null && XPathUtils.hasResults(res.toString());
        if (!ok) {
            this._logger.error(String.format("%s with ID %s is empty or is not of type functional!", TESTSET, id));
        }
        return ok;
    }

    private void initialize(Args args, RestClient client) {
        String entityId = args.getEntityId();
        this._runHandler = new RunHandlerFactory().create(client, args.getRunType(), entityId);
        this._pollHandler = new PollHandlerFactory().create(client, args.getRunType(), entityId);
    }

    private boolean poll() throws InterruptedException {
        return this._pollHandler.poll(this._logger);
    }

    public void stop() {
        this._logger.log("Stopping run...");
        if (this._runHandler != null) {
            this._runHandler.stop();
            this._running = false;
        }
        if (this._pollHandler != null) {
            this._polling = false;
        }
    }

    private boolean start(Args args) {
        boolean ret = false;
        Response response = this._runHandler.start(args.getDuration(), args.getPostRunAction(), args.getEnvironmentConfigurationId(), args.getCdaDetails());
        if (this.isOk(response, args)) {
            RunResponse runResponse = this.getRunResponse(response);
            this.setRunId(runResponse);
            if (runResponse.isSucceeded()) {
                ret = true;
            }
        }
        this.logReportUrl(ret, args, response);
        return ret;
    }

    private void setRunId(RunResponse runResponse) {
        String runId = runResponse.getRunId();
        if (StringUtils.isNullOrEmpty(runId)) {
            this._logger.log("No run ID");
            throw new SSEException("No run ID");
        }
        this._runHandler.setRunId(runId);
        this._pollHandler.setRunId(runId);
    }

    private void logReportUrl(boolean isSucceeded, Args args, Response response) {
        if (isSucceeded) {
            this._logger.log(String.format("%s run report for run id %s is at: %s", args.getRunType(), this._runHandler.getRunId(), this._runHandler.getReportUrl(args)));
        } else {
            String errMessage = "Failed to prepare timeslot for run. No entity of type " + args.getRunType() + " with id " + args.getEntityId() + " exists.";
            this._logger.log(String.format(errMessage + "\nNote: You can run only functional test sets and build verification suites using this plugin. Check to make sure that the configured ID is valid (and that it is not a performance test ID).", new Object[0]));
            this._logger.log(response.toString());
        }
    }

    private RunResponse getRunResponse(Response response) {
        return this._runHandler.getRunResponse(response);
    }

    private boolean isOk(Response response, Args args) {
        boolean ret = false;
        if (response.isOk()) {
            this._logger.log(String.format("Executing %s ID: %s in %s/%s %sDescription: %s", args.getRunType(), args.getEntityId(), args.getDomain(), args.getProject(), StringUtils.NEW_LINE, args.getDescription()));
            ret = true;
        } else {
            Throwable cause = response.getFailure();
            if (cause != null) {
                this._logger.log(String.format("Failed to start %s ID: %s, ALM Server URL: %s (Exception: %s)", args.getRunType(), args.getEntityId(), args.getUrl(), cause.getMessage()));
            } else {
                this._logger.log(String.format("Failed to execute %s ID: %s, ALM Server URL: %s (Response: %s)", args.getRunType(), args.getEntityId(), args.getUrl(), response.getStatusCode()));
            }
        }
        return ret;
    }

    public boolean getRunning() {
        return this._running;
    }

    public boolean getPolling() {
        return this._polling;
    }
}

