/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.sse.sdk;

import com.microfocus.application.automation.tools.common.ALMRESTVersionUtils;
import com.microfocus.application.automation.tools.common.SSEException;
import com.microfocus.application.automation.tools.model.ALMVersion;
import com.microfocus.application.automation.tools.sse.sdk.Client;
import com.microfocus.application.automation.tools.sse.sdk.Response;
import com.microfocus.application.automation.tools.sse.sdk.request.GetALMVersionRequest;

public class ALMRunReportUrlBuilder {
    public String build(Client client, String serverUrl, String domain, String project, String runId) {
        String ret = "NA";
        try {
            ALMVersion version = this.getALMVersion(client);
            int majorVersion = this.toInt(version.getMajorVersion());
            int minorVersion = this.toInt(version.getMinorVersion());
            ret = majorVersion < 12 || majorVersion == 12 && minorVersion < 2 ? client.buildWebUIRequest(String.format("lab/index.jsp?processRunId=%s", runId)) : (majorVersion >= 16 ? String.format("%sui/?redirected&p=%s/%s&execution-report#!/test-set-report/%s", serverUrl, domain, project, runId) : String.format("%sui/?redirected&p=%s/%s&execution-report#/test-set-report/%s", serverUrl, domain, project, runId));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean isNewReport(Client client) {
        ALMVersion version = this.getALMVersion(client);
        return this.toInt(version.getMajorVersion()) == 12 && this.toInt(version.getMinorVersion()) >= 2 || this.toInt(version.getMajorVersion()) > 12;
    }

    private int toInt(String str) {
        return Integer.parseInt(str);
    }

    private ALMVersion getALMVersion(Client client) {
        ALMVersion ret = null;
        Response response = new GetALMVersionRequest(client).execute();
        if (!response.isOk()) {
            throw new SSEException(String.format("Failed to get ALM version. HTTP status code: %d", response.getStatusCode()), response.getFailure());
        }
        ret = ALMRESTVersionUtils.toModel(response.getData());
        return ret;
    }
}

