/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.sse.common;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.microfocus.application.automation.tools.common.SSEException;
import com.microfocus.application.automation.tools.sse.common.JsonHandlerMasterToSlave;
import com.microfocus.application.automation.tools.sse.sdk.Logger;
import hudson.FilePath;
import hudson.model.Node;
import hudson.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import jenkins.model.Jenkins;
import net.minidev.json.JSONArray;

public class JsonHandler {
    private static Logger logger;

    public JsonHandler(Logger logger) {
        JsonHandler.logger = logger;
    }

    public Object load(String selectedNode, String path) {
        Object parsedJson;
        logger.log(String.format("Loading JSON file from: [%s]", path));
        try {
            String jsonTxt = "";
            if (selectedNode.equals("master")) {
                jsonTxt = JsonHandler.getStream(new File(path));
            } else {
                Node node = Jenkins.getInstance().getNode(selectedNode);
                FilePath filePath = new FilePath(node.getChannel(), path);
                JsonHandlerMasterToSlave uftMasterToSlave = new JsonHandlerMasterToSlave();
                try {
                    jsonTxt = (String)filePath.act((FilePath.FileCallable)uftMasterToSlave);
                }
                catch (IOException e) {
                    logger.log(String.format("File path not found %s", e.getMessage()));
                }
                catch (InterruptedException e) {
                    logger.log(String.format("Remote operation failed %s", e.getMessage()));
                }
            }
            parsedJson = Configuration.defaultConfiguration().addOptions(new Option[]{Option.ALWAYS_RETURN_LIST}).jsonProvider().parse(jsonTxt);
        }
        catch (Throwable e) {
            throw new SSEException(String.format("Failed to load JSON from: [%s]", path), e);
        }
        return parsedJson;
    }

    public static String getStream(File path) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(String.valueOf(path));
        }
        catch (FileNotFoundException e) {
            logger.log(String.format("File path not found %s", e.getMessage()));
        }
        String jsonText = "";
        try {
            jsonText = IOUtils.toString((InputStream)is, (String)String.valueOf(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            logger.log(String.format("Failed to create the json object %s", e.getMessage()));
        }
        return jsonText;
    }

    public String getValueFromJsonAsString(Object jsonObject, String pathToRead, boolean shouldGetSingleValueOnly) {
        String value = "";
        try {
            Object extractedObject = JsonPath.read((Object)jsonObject, (String)pathToRead, (Predicate[])new Predicate[0]);
            while (extractedObject instanceof JSONArray && shouldGetSingleValueOnly) {
                extractedObject = ((JSONArray)extractedObject).get(0);
            }
            value = extractedObject.toString();
        }
        catch (Throwable e) {
            logger.log(String.format("Failed to get the value of [%s] from the JSON file.\n\tError was: %s", pathToRead, e.getMessage()));
        }
        return value;
    }
}

